/*
 * Decompiled with CFR 0.152.
 */
package org.apache.qpid.server.security.auth.sasl.plain;

import java.io.IOException;
import javax.security.sasl.SaslException;
import javax.security.sasl.SaslServer;
import org.apache.qpid.server.security.auth.AuthenticationResult;
import org.apache.qpid.server.security.auth.manager.UsernamePasswordAuthenticationProvider;

public class PlainAdapterSaslServer
implements SaslServer {
    public static final String MECHANISM = "PLAIN";
    private final PasswordValidator _passwordValidator;
    private String _authorizationId;
    private boolean _complete = false;

    public PlainAdapterSaslServer(PasswordValidator passwordValidator) {
        this._passwordValidator = passwordValidator;
    }

    public PlainAdapterSaslServer(final UsernamePasswordAuthenticationProvider<?> authProvider) {
        this(new PasswordValidator(){

            @Override
            public boolean validatePassword(String user, String password) {
                AuthenticationResult authenticationResult = authProvider.authenticate(user, password);
                return authenticationResult != null && authenticationResult.getStatus() == AuthenticationResult.AuthenticationStatus.SUCCESS;
            }
        });
    }

    @Override
    public String getMechanismName() {
        return MECHANISM;
    }

    @Override
    public byte[] evaluateResponse(byte[] response) throws SaslException {
        int authzidNullPosition = this.findNullPosition(response, 0);
        if (authzidNullPosition < 0) {
            throw new SaslException("Invalid PLAIN encoding, authzid null terminator not found");
        }
        int authcidNullPosition = this.findNullPosition(response, authzidNullPosition + 1);
        if (authcidNullPosition < 0) {
            throw new SaslException("Invalid PLAIN encoding, authcid null terminator not found");
        }
        try {
            String authzid = new String(response, authzidNullPosition + 1, authcidNullPosition - authzidNullPosition - 1, "utf8");
            int passwordLen = response.length - authcidNullPosition - 1;
            String pwd = new String(response, authcidNullPosition + 1, passwordLen, "utf8");
            if (!this._passwordValidator.validatePassword(authzid, pwd)) {
                throw new SaslException("Authentication failed");
            }
            this._authorizationId = authzid;
            this._complete = true;
            return null;
        }
        catch (IOException e) {
            if (e instanceof SaslException) {
                throw (SaslException)e;
            }
            throw new SaslException("Error processing data: " + e, e);
        }
    }

    private int findNullPosition(byte[] response, int startPosition) {
        for (int position = startPosition; position < response.length; ++position) {
            if (response[position] != 0) continue;
            return position;
        }
        return -1;
    }

    @Override
    public boolean isComplete() {
        return this._complete;
    }

    @Override
    public String getAuthorizationID() {
        return this._authorizationId;
    }

    @Override
    public byte[] unwrap(byte[] incoming, int offset, int len) throws SaslException {
        throw new SaslException("Unsupported operation");
    }

    @Override
    public byte[] wrap(byte[] outgoing, int offset, int len) throws SaslException {
        throw new SaslException("Unsupported operation");
    }

    @Override
    public Object getNegotiatedProperty(String propName) {
        return null;
    }

    @Override
    public void dispose() throws SaslException {
    }

    public static interface PasswordValidator {
        public boolean validatePassword(String var1, String var2);
    }
}

