/*
 * Decompiled with CFR 0.152.
 */
package org.apache.qpid.server.security.auth.sasl.external;

import java.security.Principal;
import javax.security.auth.x500.X500Principal;
import javax.security.sasl.SaslException;
import javax.security.sasl.SaslServer;
import org.apache.qpid.server.model.AuthenticationProvider;
import org.apache.qpid.server.security.auth.UsernamePrincipal;
import org.apache.qpid.transport.network.security.ssl.SSLUtil;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class ExternalSaslServer
implements SaslServer {
    private static final Logger LOGGER = LoggerFactory.getLogger(ExternalSaslServer.class);
    public static final String MECHANISM = "EXTERNAL";
    private boolean _complete = false;
    private final AuthenticationProvider<?> _authenticationProvider;
    private final Principal _externalPrincipal;
    private final boolean _useFullDN;

    public ExternalSaslServer(Principal externalPrincipal, boolean useFullDN, AuthenticationProvider<?> authenticationProvider) {
        this._useFullDN = useFullDN;
        this._externalPrincipal = externalPrincipal;
        this._authenticationProvider = authenticationProvider;
    }

    @Override
    public String getMechanismName() {
        return MECHANISM;
    }

    @Override
    public byte[] evaluateResponse(byte[] response) throws SaslException {
        this._complete = true;
        return null;
    }

    @Override
    public boolean isComplete() {
        return this._complete;
    }

    @Override
    public String getAuthorizationID() {
        return this.getAuthenticatedPrincipal() == null ? null : this.getAuthenticatedPrincipal().getName();
    }

    @Override
    public byte[] unwrap(byte[] incoming, int offset, int len) throws SaslException {
        throw new SaslException("Unsupported operation");
    }

    @Override
    public byte[] wrap(byte[] outgoing, int offset, int len) throws SaslException {
        throw new SaslException("Unsupported operation");
    }

    @Override
    public Object getNegotiatedProperty(String propName) {
        return null;
    }

    @Override
    public void dispose() throws SaslException {
    }

    public Principal getAuthenticatedPrincipal() {
        if (this._externalPrincipal instanceof X500Principal && !this._useFullDN) {
            String dn = ((X500Principal)this._externalPrincipal).getName("RFC2253");
            LOGGER.debug("Parsing username from Principal DN: {}", (Object)dn);
            String username = SSLUtil.getIdFromSubjectDN((String)dn);
            if (username.isEmpty()) {
                LOGGER.debug("CN value was empty in Principal name, unable to construct username");
                return null;
            }
            LOGGER.debug("Constructing Principal with username: {}", (Object)username);
            return new UsernamePrincipal(username, this._authenticationProvider);
        }
        LOGGER.debug("Using external Principal: {}", (Object)this._externalPrincipal);
        return this._externalPrincipal;
    }
}

