/*
 * Decompiled with CFR 0.152.
 */
package org.apache.qpid.server.security.auth.sasl.crammd5;

import java.io.File;
import java.io.IOException;
import java.security.Principal;
import java.util.List;
import javax.security.auth.callback.PasswordCallback;
import javax.security.auth.login.AccountNotFoundException;
import javax.security.sasl.SaslException;
import javax.security.sasl.SaslServer;
import org.apache.qpid.server.model.AuthenticationProvider;
import org.apache.qpid.server.security.auth.database.PrincipalDatabase;
import org.apache.qpid.server.security.auth.sasl.UsernamePasswordInitialiser;

public class CRAMMD5HexInitialiser
extends UsernamePasswordInitialiser {
    @Override
    public String getMechanismName() {
        return "CRAM-MD5-HEX";
    }

    @Override
    public void initialise(PrincipalDatabase db) {
        super.initialise(new HexifyPrincipalDatabase(db));
    }

    private static class HexifyPrincipalDatabase
    implements PrincipalDatabase {
        private PrincipalDatabase _realPrincipalDatabase;

        HexifyPrincipalDatabase(PrincipalDatabase db) {
            this._realPrincipalDatabase = db;
        }

        private char[] toHex(char[] password) {
            StringBuilder sb = new StringBuilder();
            for (char c : password) {
                if ((byte)c > -1 && (byte)c < 16) {
                    sb.append(0);
                }
                sb.append(Integer.toHexString(c & 0xFF));
            }
            char[] hex = new char[sb.length()];
            sb.getChars(0, sb.length(), hex, 0);
            return hex;
        }

        @Override
        public void setPassword(Principal principal, PasswordCallback callback) throws IOException, AccountNotFoundException {
            this._realPrincipalDatabase.setPassword(principal, callback);
            char[] plainPassword = callback.getPassword();
            char[] hexPassword = this.toHex(plainPassword);
            callback.setPassword(hexPassword);
        }

        @Override
        public boolean verifyPassword(String principal, char[] password) throws AccountNotFoundException {
            return this._realPrincipalDatabase.verifyPassword(principal, password);
        }

        @Override
        public boolean updatePassword(Principal principal, char[] password) throws AccountNotFoundException {
            return this._realPrincipalDatabase.updatePassword(principal, password);
        }

        @Override
        public boolean createPrincipal(Principal principal, char[] password) {
            return this._realPrincipalDatabase.createPrincipal(principal, password);
        }

        @Override
        public boolean deletePrincipal(Principal principal) throws AccountNotFoundException {
            return this._realPrincipalDatabase.deletePrincipal(principal);
        }

        @Override
        public Principal getUser(String username) {
            return this._realPrincipalDatabase.getUser(username);
        }

        @Override
        public List<Principal> getUsers() {
            return this._realPrincipalDatabase.getUsers();
        }

        @Override
        public void reload() throws IOException {
            this._realPrincipalDatabase.reload();
        }

        @Override
        public void open(File passwordFile) throws IOException {
            throw new UnsupportedOperationException();
        }

        @Override
        public List<String> getMechanisms() {
            return this._realPrincipalDatabase.getMechanisms();
        }

        @Override
        public SaslServer createSaslServer(String mechanism, String localFQDN, Principal externalPrincipal) throws SaslException {
            return this._realPrincipalDatabase.createSaslServer(mechanism, localFQDN, externalPrincipal);
        }

        @Override
        public AuthenticationProvider<?> getAuthenticationProvider() {
            return this._realPrincipalDatabase.getAuthenticationProvider();
        }
    }
}

