/*
 * Decompiled with CFR 0.152.
 */
package org.apache.qpid.server.security.auth.manager.oauth2;

import org.apache.qpid.server.model.AuthenticationProvider;
import org.apache.qpid.server.model.ConfiguredObject;
import org.apache.qpid.server.security.QpidPrincipal;

public class OAuth2UserPrincipal
implements QpidPrincipal {
    private final String _accessToken;
    private final String _name;
    private final AuthenticationProvider<?> _authenticationProvider;

    public OAuth2UserPrincipal(String name, String accessToken, AuthenticationProvider<?> authenticationProvider) {
        if (name == null) {
            throw new IllegalArgumentException("name cannot be null");
        }
        if (accessToken == null) {
            throw new IllegalArgumentException("accessToken cannot be null");
        }
        this._name = name;
        this._accessToken = accessToken;
        this._authenticationProvider = authenticationProvider;
    }

    public String getAccessToken() {
        return this._accessToken;
    }

    @Override
    public String getName() {
        return this._name;
    }

    @Override
    public ConfiguredObject<?> getOrigin() {
        return this._authenticationProvider;
    }

    @Override
    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (o == null || this.getClass() != o.getClass()) {
            return false;
        }
        OAuth2UserPrincipal that = (OAuth2UserPrincipal)o;
        if (!this._accessToken.equals(that._accessToken)) {
            return false;
        }
        return this._name.equals(that._name);
    }

    @Override
    public int hashCode() {
        int result = this._accessToken.hashCode();
        result = 31 * result + this._name.hashCode();
        return result;
    }

    @Override
    public String toString() {
        return this.getName();
    }
}

