/*
 * Decompiled with CFR 0.152.
 */
package org.apache.qpid.server.security.auth.manager.oauth2;

import java.nio.charset.StandardCharsets;
import java.util.HashMap;
import java.util.Map;
import javax.security.sasl.SaslException;
import javax.security.sasl.SaslServer;

class OAuth2SaslServer
implements SaslServer {
    public static final String MECHANISM = "XOAUTH2";
    public static final String ACCESS_TOKEN_PROPERTY = "accessToken";
    private static final String BEARER_PREFIX = "Bearer ";
    private String _accessToken;
    private boolean _isComplete;

    OAuth2SaslServer() {
    }

    @Override
    public String getMechanismName() {
        return MECHANISM;
    }

    @Override
    public byte[] evaluateResponse(byte[] response) throws SaslException {
        Map<String, String> responsePairs = this.splitResponse(response);
        String auth = responsePairs.get("auth");
        if (auth != null) {
            if (!auth.startsWith(BEARER_PREFIX)) {
                throw new SaslException("The 'auth' part of response does not not begin with the expected prefix");
            }
        } else {
            throw new SaslException("The mandatory 'auth' part of the response was absent.");
        }
        this._accessToken = auth.substring(BEARER_PREFIX.length());
        this._isComplete = true;
        return new byte[0];
    }

    @Override
    public boolean isComplete() {
        return this._isComplete;
    }

    @Override
    public String getAuthorizationID() {
        return null;
    }

    @Override
    public Object getNegotiatedProperty(String propName) {
        if (!this._isComplete) {
            throw new IllegalStateException("authentication exchange has not completed");
        }
        if (ACCESS_TOKEN_PROPERTY.equals(propName)) {
            return this._accessToken;
        }
        return null;
    }

    @Override
    public byte[] unwrap(byte[] incoming, int offset, int len) throws SaslException {
        throw new SaslException("");
    }

    @Override
    public byte[] wrap(byte[] outgoing, int offset, int len) throws SaslException {
        throw new SaslException("");
    }

    @Override
    public void dispose() throws SaslException {
        this._accessToken = null;
    }

    private Map<String, String> splitResponse(byte[] response) {
        String[] splitResponse = new String(response, StandardCharsets.US_ASCII).split("\u0001");
        HashMap<String, String> responseItems = new HashMap<String, String>(splitResponse.length);
        for (String nameValue : splitResponse) {
            String[] nameValueSplit;
            if (nameValue.length() <= 0 || (nameValueSplit = nameValue.split("=", 2)).length != 2) continue;
            responseItems.put(nameValueSplit[0], nameValueSplit[1]);
        }
        return responseItems;
    }
}

