/*
 * Decompiled with CFR 0.152.
 */
package org.apache.qpid.server.security.auth.manager;

import java.io.IOException;
import java.security.Principal;
import java.util.Arrays;
import java.util.Collections;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import javax.security.auth.callback.Callback;
import javax.security.auth.callback.CallbackHandler;
import javax.security.auth.callback.NameCallback;
import javax.security.auth.callback.PasswordCallback;
import javax.security.auth.callback.UnsupportedCallbackException;
import javax.security.auth.login.AccountNotFoundException;
import javax.security.sasl.AuthorizeCallback;
import javax.security.sasl.Sasl;
import javax.security.sasl.SaslException;
import javax.security.sasl.SaslServer;
import org.apache.qpid.server.model.Container;
import org.apache.qpid.server.model.ManagedObject;
import org.apache.qpid.server.model.PasswordCredentialManagingAuthenticationProvider;
import org.apache.qpid.server.security.auth.AuthenticationResult;
import org.apache.qpid.server.security.auth.UsernamePrincipal;
import org.apache.qpid.server.security.auth.manager.AbstractAuthenticationManager;
import org.apache.qpid.server.security.auth.sasl.plain.PlainPasswordCallback;
import org.apache.qpid.server.security.auth.sasl.plain.PlainSaslServer;
import org.apache.qpid.server.security.auth.sasl.scram.ScramSaslServer;
import org.apache.qpid.server.security.auth.sasl.scram.ScramSaslServerSourceAdapter;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

@ManagedObject(category=false, type="Simple", register=false)
public class SimpleAuthenticationManager
extends AbstractAuthenticationManager<SimpleAuthenticationManager>
implements PasswordCredentialManagingAuthenticationProvider<SimpleAuthenticationManager> {
    private static final Logger _logger = LoggerFactory.getLogger(SimpleAuthenticationManager.class);
    private static final String PLAIN_MECHANISM = "PLAIN";
    private static final String CRAM_MD5_MECHANISM = "CRAM-MD5";
    private static final String SCRAM_SHA1_MECHANISM = "SCRAM-SHA-1";
    private static final String SCRAM_SHA256_MECHANISM = "SCRAM-SHA-256";
    private final Map<String, String> _users = Collections.synchronizedMap(new HashMap());
    private volatile ScramSaslServerSourceAdapter _scramSha1Adapter;
    private volatile ScramSaslServerSourceAdapter _scramSha256Adapter;

    public SimpleAuthenticationManager(Map<String, Object> attributes, Container<?> container) {
        super(attributes, container);
    }

    @Override
    protected void postResolveChildren() {
        super.postResolveChildren();
        ScramSaslServerSourceAdapter.PasswordSource passwordSource = new ScramSaslServerSourceAdapter.PasswordSource(){

            @Override
            public char[] getPassword(String username) {
                String password = (String)SimpleAuthenticationManager.this._users.get(username);
                return password == null ? null : password.toCharArray();
            }
        };
        int scramIterationCount = this.getContextValue(Integer.class, "qpid.auth.scram.iteration_count");
        this._scramSha1Adapter = new ScramSaslServerSourceAdapter(scramIterationCount, "HmacSHA1", "SHA-1", passwordSource);
        this._scramSha256Adapter = new ScramSaslServerSourceAdapter(scramIterationCount, "HmacSHA256", "SHA-256", passwordSource);
    }

    public void addUser(String username, String password) {
        this.createUser(username, password, Collections.EMPTY_MAP);
    }

    @Override
    public List<String> getMechanisms() {
        return Collections.unmodifiableList(Arrays.asList(PLAIN_MECHANISM, CRAM_MD5_MECHANISM, SCRAM_SHA1_MECHANISM, SCRAM_SHA256_MECHANISM));
    }

    @Override
    public SaslServer createSaslServer(String mechanism, String localFQDN, Principal externalPrincipal) throws SaslException {
        if (PLAIN_MECHANISM.equals(mechanism)) {
            return new PlainSaslServer(new SimplePlainCallbackHandler());
        }
        if (CRAM_MD5_MECHANISM.equals(mechanism)) {
            return Sasl.createSaslServer(mechanism, "AMQP", localFQDN, null, new SimpleCramMd5CallbackHandler());
        }
        if (SCRAM_SHA1_MECHANISM.equals(mechanism)) {
            return new ScramSaslServer(this._scramSha1Adapter, mechanism, "HmacSHA1", "SHA-1");
        }
        if (SCRAM_SHA256_MECHANISM.equals(mechanism)) {
            return new ScramSaslServer(this._scramSha256Adapter, mechanism, "HmacSHA256", "SHA-256");
        }
        throw new SaslException("Unknown mechanism: " + mechanism);
    }

    @Override
    public AuthenticationResult authenticate(SaslServer server, byte[] response) {
        try {
            byte[] challenge = server.evaluateResponse(response != null ? response : new byte[]{});
            if (server.isComplete()) {
                String authorizationID = server.getAuthorizationID();
                _logger.debug("Authenticated as " + authorizationID);
                return new AuthenticationResult(new UsernamePrincipal(authorizationID, this), challenge);
            }
            return new AuthenticationResult(challenge, AuthenticationResult.AuthenticationStatus.CONTINUE);
        }
        catch (SaslException e) {
            return new AuthenticationResult(AuthenticationResult.AuthenticationStatus.ERROR, e);
        }
    }

    @Override
    public AuthenticationResult authenticate(String username, String password) {
        String userPassword;
        if (this._users.containsKey(username) && (userPassword = this._users.get(username)).equals(password)) {
            return new AuthenticationResult(new UsernamePrincipal(username, this));
        }
        return new AuthenticationResult(AuthenticationResult.AuthenticationStatus.ERROR);
    }

    @Override
    public boolean createUser(String username, String password, Map<String, String> attributes) {
        this._users.put(username, password);
        return true;
    }

    @Override
    public void deleteUser(String username) throws AccountNotFoundException {
        if (this._users.remove(username) == null) {
            throw new AccountNotFoundException("No such user: '" + username + "'");
        }
    }

    @Override
    public void setPassword(String username, String password) throws AccountNotFoundException {
        if (!this._users.containsKey(username)) {
            throw new AccountNotFoundException("No such user: '" + username + "'");
        }
        this._users.put(username, password);
    }

    @Override
    public Map<String, Map<String, String>> getUsers() {
        HashMap<String, Map<String, String>> users = new HashMap<String, Map<String, String>>();
        for (String username : this._users.keySet()) {
            users.put(username, Collections.EMPTY_MAP);
        }
        return users;
    }

    @Override
    public void reload() throws IOException {
    }

    private class SimplePlainCallbackHandler
    implements CallbackHandler {
        private SimplePlainCallbackHandler() {
        }

        @Override
        public void handle(Callback[] callbacks) throws IOException, UnsupportedCallbackException {
            String username = null;
            for (Callback callback : callbacks) {
                if (callback instanceof NameCallback) {
                    username = ((NameCallback)callback).getDefaultName();
                    continue;
                }
                if (callback instanceof PlainPasswordCallback) {
                    if (!SimpleAuthenticationManager.this._users.containsKey(username)) continue;
                    PlainPasswordCallback plainPasswordCallback = (PlainPasswordCallback)callback;
                    String password = plainPasswordCallback.getPlainPassword();
                    plainPasswordCallback.setAuthenticated(password.equals(SimpleAuthenticationManager.this._users.get(username)));
                    continue;
                }
                if (callback instanceof AuthorizeCallback) {
                    ((AuthorizeCallback)callback).setAuthorized(true);
                    continue;
                }
                throw new UnsupportedCallbackException(callback);
            }
        }
    }

    private class SimpleCramMd5CallbackHandler
    implements CallbackHandler {
        private SimpleCramMd5CallbackHandler() {
        }

        @Override
        public void handle(Callback[] callbacks) throws IOException, UnsupportedCallbackException {
            String username = null;
            for (Callback callback : callbacks) {
                if (callback instanceof NameCallback) {
                    username = ((NameCallback)callback).getDefaultName();
                    continue;
                }
                if (callback instanceof PasswordCallback) {
                    if (SimpleAuthenticationManager.this._users.containsKey(username)) {
                        String password = (String)SimpleAuthenticationManager.this._users.get(username);
                        ((PasswordCallback)callback).setPassword(password.toCharArray());
                        continue;
                    }
                    throw new SaslException("Authentication failed");
                }
                if (callback instanceof AuthorizeCallback) {
                    ((AuthorizeCallback)callback).setAuthorized(true);
                    continue;
                }
                throw new UnsupportedCallbackException(callback);
            }
        }
    }
}

