/*
 * Decompiled with CFR 0.152.
 */
package org.apache.qpid.server.security.auth.manager;

import com.google.common.util.concurrent.Futures;
import com.google.common.util.concurrent.ListenableFuture;
import com.google.common.util.concurrent.SettableFuture;
import java.io.File;
import java.io.FileNotFoundException;
import java.io.IOException;
import java.nio.file.Files;
import java.nio.file.LinkOption;
import java.nio.file.Path;
import java.security.AccessControlException;
import java.security.Principal;
import java.util.Collections;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Set;
import java.util.UUID;
import java.util.concurrent.ConcurrentHashMap;
import java.util.concurrent.Executor;
import javax.security.auth.login.AccountNotFoundException;
import javax.security.sasl.SaslException;
import javax.security.sasl.SaslServer;
import org.apache.qpid.server.configuration.IllegalConfigurationException;
import org.apache.qpid.server.model.AbstractConfiguredObject;
import org.apache.qpid.server.model.ConfiguredObject;
import org.apache.qpid.server.model.Container;
import org.apache.qpid.server.model.ExternalFileBasedAuthenticationManager;
import org.apache.qpid.server.model.ManagedAttributeField;
import org.apache.qpid.server.model.State;
import org.apache.qpid.server.model.StateTransition;
import org.apache.qpid.server.model.User;
import org.apache.qpid.server.security.auth.AuthenticationResult;
import org.apache.qpid.server.security.auth.UsernamePrincipal;
import org.apache.qpid.server.security.auth.database.PrincipalDatabase;
import org.apache.qpid.server.security.auth.manager.AbstractAuthenticationManager;
import org.apache.qpid.server.util.FileHelper;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public abstract class PrincipalDatabaseAuthenticationManager<T extends PrincipalDatabaseAuthenticationManager<T>>
extends AbstractAuthenticationManager<T>
implements ExternalFileBasedAuthenticationManager<T> {
    private static final Logger LOGGER = LoggerFactory.getLogger(PrincipalDatabaseAuthenticationManager.class);
    private final Map<Principal, PrincipalAdapter> _userMap = new ConcurrentHashMap<Principal, PrincipalAdapter>();
    private PrincipalDatabase _principalDatabase;
    @ManagedAttributeField
    private String _path;

    protected PrincipalDatabaseAuthenticationManager(Map<String, Object> attributes, Container<?> broker) {
        super(attributes, broker);
    }

    @Override
    protected void validateOnCreate() {
        super.validateOnCreate();
        File passwordFile = new File(this._path);
        if (passwordFile.exists() && !passwordFile.canRead()) {
            throw new IllegalConfigurationException(String.format("Cannot read password file '%s'. Please check permissions.", this._path));
        }
    }

    @Override
    protected void onCreate() {
        super.onCreate();
        File passwordFile = new File(this._path);
        if (!passwordFile.exists()) {
            try {
                Path path = new FileHelper().createNewFile(passwordFile, this.getContextValue(String.class, "qpid.default_posix_file_permissions"));
                if (!Files.exists(path, new LinkOption[0])) {
                    throw new IllegalConfigurationException(String.format("Cannot create password file at '%s'", this._path));
                }
            }
            catch (IOException e) {
                throw new IllegalConfigurationException(String.format("Cannot create password file at '%s'", this._path), e);
            }
        }
    }

    @Override
    protected void onOpen() {
        super.onOpen();
        this.initialise();
    }

    @Override
    protected void postResolve() {
        super.postResolve();
        this._principalDatabase = this.createDatabase();
    }

    protected abstract PrincipalDatabase createDatabase();

    @Override
    public String getPath() {
        return this._path;
    }

    public void initialise() {
        try {
            this._principalDatabase.open(new File(this._path));
        }
        catch (FileNotFoundException e) {
            throw new IllegalConfigurationException("Exception opening password database: " + e.getMessage(), e);
        }
        catch (IOException e) {
            throw new IllegalConfigurationException("Cannot use password database at :" + this._path, e);
        }
    }

    @Override
    public List<String> getMechanisms() {
        return this._principalDatabase.getMechanisms();
    }

    @Override
    public SaslServer createSaslServer(String mechanism, String localFQDN, Principal externalPrincipal) throws SaslException {
        return this._principalDatabase.createSaslServer(mechanism, localFQDN, externalPrincipal);
    }

    @Override
    public AuthenticationResult authenticate(SaslServer server, byte[] response) {
        try {
            byte[] challenge = server.evaluateResponse(response != null ? response : new byte[]{});
            if (server.isComplete()) {
                String userId = server.getAuthorizationID();
                return new AuthenticationResult(new UsernamePrincipal(userId, this), challenge);
            }
            return new AuthenticationResult(challenge, AuthenticationResult.AuthenticationStatus.CONTINUE);
        }
        catch (SaslException e) {
            return new AuthenticationResult(AuthenticationResult.AuthenticationStatus.ERROR, e);
        }
    }

    @Override
    public AuthenticationResult authenticate(String username, String password) {
        try {
            if (this._principalDatabase.verifyPassword(username, password.toCharArray())) {
                return new AuthenticationResult(new UsernamePrincipal(username, this));
            }
            return new AuthenticationResult(AuthenticationResult.AuthenticationStatus.CONTINUE);
        }
        catch (AccountNotFoundException e) {
            return new AuthenticationResult(AuthenticationResult.AuthenticationStatus.CONTINUE);
        }
    }

    public PrincipalDatabase getPrincipalDatabase() {
        return this._principalDatabase;
    }

    @Override
    @StateTransition(currentState={State.UNINITIALIZED, State.ERRORED}, desiredState=State.ACTIVE)
    public ListenableFuture<Void> activate() {
        final SettableFuture returnVal = SettableFuture.create();
        final List<Principal> users = this._principalDatabase == null ? Collections.emptyList() : this._principalDatabase.getUsers();
        this._userMap.clear();
        if (!users.isEmpty()) {
            for (final Principal user : users) {
                final PrincipalAdapter principalAdapter = new PrincipalAdapter(user);
                principalAdapter.registerWithParents();
                principalAdapter.openAsync().addListener(new Runnable(){

                    @Override
                    public void run() {
                        PrincipalDatabaseAuthenticationManager.this._userMap.put(user, principalAdapter);
                        if (PrincipalDatabaseAuthenticationManager.this._userMap.size() == users.size()) {
                            PrincipalDatabaseAuthenticationManager.this.setState(State.ACTIVE);
                            returnVal.set(null);
                        }
                    }
                }, (Executor)this.getTaskExecutor());
            }
            return returnVal;
        }
        this.setState(State.ACTIVE);
        return Futures.immediateFuture(null);
    }

    @Override
    @StateTransition(currentState={State.ACTIVE, State.QUIESCED, State.ERRORED, State.UNINITIALIZED}, desiredState=State.DELETED)
    public ListenableFuture<Void> doDelete() {
        File file = new File(this._path);
        if (file.exists() && file.isFile()) {
            file.delete();
        }
        this.deleted();
        this.setState(State.DELETED);
        return Futures.immediateFuture(null);
    }

    @Override
    public boolean createUser(String username, String password, Map<String, String> attributes) {
        HashMap<String, Object> userAttrs = new HashMap<String, Object>();
        userAttrs.put("name", username);
        userAttrs.put("password", password);
        User user = this.createChild(User.class, userAttrs, new ConfiguredObject[0]);
        return user != null;
    }

    private void deleteUserFromDatabase(String username) throws AccountNotFoundException {
        UsernamePrincipal principal = new UsernamePrincipal(username, this);
        this.getPrincipalDatabase().deletePrincipal(principal);
        this._userMap.remove(principal);
    }

    @Override
    public void deleteUser(String username) throws AccountNotFoundException {
        UsernamePrincipal principal = new UsernamePrincipal(username, this);
        PrincipalAdapter user = this._userMap.get(principal);
        if (user == null) {
            throw new AccountNotFoundException("No such user: '" + username + "'");
        }
        user.delete();
    }

    @Override
    public void setPassword(String username, String password) throws AccountNotFoundException {
        UsernamePrincipal principal = new UsernamePrincipal(username, this);
        User user = this._userMap.get(principal);
        if (user != null) {
            user.setPassword(password);
        }
    }

    @Override
    public Map<String, Map<String, String>> getUsers() {
        HashMap<String, Map<String, String>> users = new HashMap<String, Map<String, String>>();
        for (Principal principal : this.getPrincipalDatabase().getUsers()) {
            users.put(principal.getName(), Collections.emptyMap());
        }
        return users;
    }

    @Override
    public void reload() throws IOException {
        this.getPrincipalDatabase().reload();
    }

    @Override
    public <C extends ConfiguredObject> ListenableFuture<C> addChildAsync(Class<C> childClass, Map<String, Object> attributes, ConfiguredObject ... otherParents) {
        if (childClass == User.class) {
            String username = (String)attributes.get("name");
            String password = (String)attributes.get("password");
            UsernamePrincipal p = new UsernamePrincipal(username, this);
            PrincipalAdapter principalAdapter = new PrincipalAdapter(p);
            principalAdapter.create();
            try {
                boolean created = this.getPrincipalDatabase().createPrincipal(p, password.toCharArray());
                if (!created) {
                    throw new IllegalArgumentException("User '" + username + "' was not added into principal database");
                }
            }
            catch (RuntimeException e) {
                principalAdapter.deleteAsync();
                throw e;
            }
            this._userMap.put(p, principalAdapter);
            return Futures.immediateFuture((Object)principalAdapter);
        }
        return super.addChildAsync(childClass, attributes, otherParents);
    }

    @Override
    protected void validateChange(ConfiguredObject<?> updatedObject, Set<String> changedAttributes) {
        super.validateChange(updatedObject, changedAttributes);
        ExternalFileBasedAuthenticationManager updated = (ExternalFileBasedAuthenticationManager)updatedObject;
        if (changedAttributes.contains("name") && !this.getName().equals(updated.getName())) {
            throw new IllegalConfigurationException("Changing the name of authentication provider is not supported");
        }
        if (changedAttributes.contains("type") && !this.getType().equals(updated.getType())) {
            throw new IllegalConfigurationException("Changing the type of authentication provider is not supported");
        }
    }

    @Override
    protected void changeAttributes(Map<String, Object> attributes) {
        block3: {
            super.changeAttributes(attributes);
            if (this.getState() != State.DELETED && this.getDesiredState() != State.DELETED) {
                try {
                    this.initialise();
                    this.setState(State.ACTIVE);
                }
                catch (RuntimeException e) {
                    if (this.getState() == State.ERRORED) break block3;
                    throw e;
                }
            }
        }
    }

    private static Map<String, Object> createPrincipalAttributes(PrincipalDatabaseAuthenticationManager manager, Principal user) {
        HashMap<String, Object> attributes = new HashMap<String, Object>();
        attributes.put("id", UUID.randomUUID());
        attributes.put("name", user.getName());
        return attributes;
    }

    private class PrincipalAdapter
    extends AbstractConfiguredObject<PrincipalAdapter>
    implements User<PrincipalAdapter> {
        private final Principal _user;
        @ManagedAttributeField
        private String _password;

        public PrincipalAdapter(Principal user) {
            super(PrincipalAdapter.parentsMap(PrincipalDatabaseAuthenticationManager.this), PrincipalDatabaseAuthenticationManager.createPrincipalAttributes(PrincipalDatabaseAuthenticationManager.this, user));
            this._user = user;
        }

        @Override
        public void onValidate() {
            super.onValidate();
            if (!this.isDurable()) {
                throw new IllegalArgumentException(this.getClass().getSimpleName() + " must be durable");
            }
        }

        @Override
        public String getPassword() {
            return this._password;
        }

        @Override
        public void setPassword(String password) {
            this.setAttributes(Collections.singletonMap("password", password));
        }

        @Override
        public boolean changeAttribute(String name, Object desired) throws IllegalStateException, AccessControlException, IllegalArgumentException {
            if (name.equals("password")) {
                try {
                    String desiredPassword = (String)desired;
                    boolean changed = PrincipalDatabaseAuthenticationManager.this.getPrincipalDatabase().updatePassword(this._user, desiredPassword.toCharArray());
                    if (changed) {
                        return super.changeAttribute(name, desired);
                    }
                    return false;
                }
                catch (AccountNotFoundException e) {
                    throw new IllegalStateException(e);
                }
            }
            return super.changeAttribute(name, desired);
        }

        @StateTransition(currentState={State.UNINITIALIZED, State.ERRORED}, desiredState=State.ACTIVE)
        private ListenableFuture<Void> activate() {
            this.setState(State.ACTIVE);
            return Futures.immediateFuture(null);
        }

        @StateTransition(currentState={State.ACTIVE}, desiredState=State.DELETED)
        private ListenableFuture<Void> doDelete() {
            try {
                String userName = this._user.getName();
                PrincipalDatabaseAuthenticationManager.this.deleteUserFromDatabase(userName);
            }
            catch (AccountNotFoundException accountNotFoundException) {
                // empty catch block
            }
            this.deleted();
            this.setState(State.DELETED);
            return Futures.immediateFuture(null);
        }
    }
}

