/*
 * Decompiled with CFR 0.152.
 */
package org.apache.qpid.server.security.auth.manager;

import java.io.IOException;
import java.security.Principal;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collections;
import java.util.Iterator;
import java.util.List;
import java.util.Map;
import javax.security.auth.callback.Callback;
import javax.security.auth.callback.CallbackHandler;
import javax.security.auth.callback.NameCallback;
import javax.security.auth.callback.PasswordCallback;
import javax.security.auth.callback.UnsupportedCallbackException;
import javax.security.sasl.AuthorizeCallback;
import javax.security.sasl.Sasl;
import javax.security.sasl.SaslException;
import javax.security.sasl.SaslServer;
import org.apache.qpid.server.model.Broker;
import org.apache.qpid.server.model.ManagedObject;
import org.apache.qpid.server.model.ManagedObjectFactoryConstructor;
import org.apache.qpid.server.security.auth.AuthenticationResult;
import org.apache.qpid.server.security.auth.UsernamePrincipal;
import org.apache.qpid.server.security.auth.manager.ConfigModelPasswordManagingAuthenticationProvider;
import org.apache.qpid.server.security.auth.manager.ManagedUser;
import org.apache.qpid.server.security.auth.sasl.plain.PlainAdapterSaslServer;
import org.apache.qpid.server.security.auth.sasl.scram.ScramSaslServer;
import org.apache.qpid.server.security.auth.sasl.scram.ScramSaslServerSourceAdapter;

@ManagedObject(category=false, type="Plain")
public class PlainAuthenticationProvider
extends ConfigModelPasswordManagingAuthenticationProvider<PlainAuthenticationProvider> {
    private final List<String> _mechanisms = Collections.unmodifiableList(Arrays.asList("PLAIN", "CRAM-MD5", "SCRAM-SHA-1", "SCRAM-SHA-256"));
    private volatile ScramSaslServerSourceAdapter _scramSha1Adapter;
    private volatile ScramSaslServerSourceAdapter _scramSha256Adapter;

    @ManagedObjectFactoryConstructor
    protected PlainAuthenticationProvider(Map<String, Object> attributes, Broker broker) {
        super(attributes, broker);
    }

    @Override
    protected void postResolveChildren() {
        super.postResolveChildren();
        ScramSaslServerSourceAdapter.PasswordSource passwordSource = new ScramSaslServerSourceAdapter.PasswordSource(){

            @Override
            public char[] getPassword(String username) {
                ManagedUser user = PlainAuthenticationProvider.this.getUser(username);
                return user == null ? null : user.getPassword().toCharArray();
            }
        };
        int scramIterationCount = this.getContextValue(Integer.class, "qpid.auth.scram.iteration_count");
        this._scramSha1Adapter = new ScramSaslServerSourceAdapter(scramIterationCount, "HmacSHA1", "SHA-1", passwordSource);
        this._scramSha256Adapter = new ScramSaslServerSourceAdapter(scramIterationCount, "HmacSHA256", "SHA-256", passwordSource);
    }

    @Override
    protected String createStoredPassword(String password) {
        return password;
    }

    @Override
    void validateUser(ManagedUser managedUser) {
    }

    @Override
    public List<String> getMechanisms() {
        return this._mechanisms;
    }

    @Override
    public SaslServer createSaslServer(String mechanism, String localFQDN, Principal externalPrincipal) throws SaslException {
        if ("PLAIN".equals(mechanism)) {
            return new PlainAdapterSaslServer(this);
        }
        if ("CRAM-MD5".equals(mechanism)) {
            return Sasl.createSaslServer(mechanism, "AMQP", localFQDN, null, new ServerCallbackHandler());
        }
        if ("SCRAM-SHA-1".equals(mechanism)) {
            return new ScramSaslServer(this._scramSha1Adapter, mechanism, "HmacSHA1", "SHA-1");
        }
        if ("SCRAM-SHA-256".equals(mechanism)) {
            return new ScramSaslServer(this._scramSha256Adapter, mechanism, "HmacSHA256", "SHA-256");
        }
        throw new SaslException("Unsupported mechanism: " + mechanism);
    }

    @Override
    public AuthenticationResult authenticate(String username, String password) {
        ManagedUser user = this.getUser(username);
        AuthenticationResult result = user != null && user.getPassword().equals(password) ? new AuthenticationResult(new UsernamePrincipal(username, this)) : new AuthenticationResult(AuthenticationResult.AuthenticationStatus.ERROR);
        return result;
    }

    private class ServerCallbackHandler
    implements CallbackHandler {
        String _username;

        private ServerCallbackHandler() {
        }

        @Override
        public void handle(Callback[] callbacks) throws IOException, UnsupportedCallbackException {
            Callback callback;
            ArrayList<Callback> callbackList = new ArrayList<Callback>(Arrays.asList(callbacks));
            Iterator iter = callbackList.iterator();
            while (iter.hasNext()) {
                callback = (Callback)iter.next();
                if (!(callback instanceof NameCallback)) continue;
                this._username = ((NameCallback)callback).getDefaultName();
                iter.remove();
                break;
            }
            if (this._username != null) {
                iter = callbackList.iterator();
                while (iter.hasNext()) {
                    callback = (Callback)iter.next();
                    if (!(callback instanceof PasswordCallback)) continue;
                    iter.remove();
                    ManagedUser user = PlainAuthenticationProvider.this.getUser(this._username);
                    if (user != null) {
                        ((PasswordCallback)callback).setPassword(user.getPassword().toCharArray());
                        break;
                    }
                    ((PasswordCallback)callback).setPassword(null);
                    break;
                }
            }
            for (Callback callback2 : callbackList) {
                if (callback2 instanceof AuthorizeCallback) {
                    ((AuthorizeCallback)callback2).setAuthorized(true);
                    continue;
                }
                throw new UnsupportedCallbackException(callback2);
            }
        }
    }
}

