/*
 * Decompiled with CFR 0.152.
 */
package org.apache.qpid.server.security.auth.manager;

import com.google.common.util.concurrent.Futures;
import com.google.common.util.concurrent.ListenableFuture;
import java.util.Collections;
import java.util.Map;
import org.apache.qpid.server.model.AbstractConfiguredObject;
import org.apache.qpid.server.model.ManagedAttributeField;
import org.apache.qpid.server.model.ManagedObject;
import org.apache.qpid.server.model.ManagedObjectFactoryConstructor;
import org.apache.qpid.server.model.State;
import org.apache.qpid.server.model.StateTransition;
import org.apache.qpid.server.model.User;
import org.apache.qpid.server.security.auth.manager.ConfigModelPasswordManagingAuthenticationProvider;

@ManagedObject(category=false, type="managed")
class ManagedUser
extends AbstractConfiguredObject<ManagedUser>
implements User<ManagedUser> {
    public static final String MANAGED_USER_TYPE = "managed";
    private ConfigModelPasswordManagingAuthenticationProvider<?> _authenticationManager;
    @ManagedAttributeField
    private String _password;

    @ManagedObjectFactoryConstructor
    ManagedUser(Map<String, Object> attributes, ConfigModelPasswordManagingAuthenticationProvider<?> parent) {
        super(ManagedUser.parentsMap(parent), attributes);
        this._authenticationManager = parent;
        this.setState(State.ACTIVE);
    }

    @Override
    protected void onOpen() {
        super.onOpen();
        this._authenticationManager.getUserMap().put(this.getName(), this);
    }

    @Override
    public void onValidate() {
        super.onValidate();
        this._authenticationManager.validateUser(this);
        if (!this.isDurable()) {
            throw new IllegalArgumentException(this.getClass().getSimpleName() + " must be durable");
        }
    }

    @StateTransition(currentState={State.ACTIVE}, desiredState=State.DELETED)
    private ListenableFuture<Void> doDelete() {
        this._authenticationManager.getUserMap().remove(this.getName());
        this.deleted();
        return Futures.immediateFuture(null);
    }

    @Override
    protected boolean changeAttribute(String name, Object desired) {
        String storedPassword;
        if ("password".equals(name) && !(storedPassword = this._authenticationManager.createStoredPassword((String)desired)).equals(this.getActualAttributes().get("password"))) {
            desired = storedPassword;
        }
        return super.changeAttribute(name, desired);
    }

    @Override
    public String getPassword() {
        return this._password;
    }

    @Override
    public void setPassword(String password) {
        this.setAttributes(Collections.singletonMap("password", password));
    }
}

