/*
 * Decompiled with CFR 0.152.
 */
package org.apache.qpid.server.security.auth.manager;

import java.io.IOException;
import java.nio.charset.StandardCharsets;
import java.security.MessageDigest;
import java.security.NoSuchAlgorithmException;
import java.security.Principal;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collections;
import java.util.Iterator;
import java.util.List;
import java.util.Map;
import javax.security.auth.callback.Callback;
import javax.security.auth.callback.CallbackHandler;
import javax.security.auth.callback.NameCallback;
import javax.security.auth.callback.PasswordCallback;
import javax.security.auth.callback.UnsupportedCallbackException;
import javax.security.sasl.AuthorizeCallback;
import javax.security.sasl.SaslException;
import javax.security.sasl.SaslServer;
import javax.xml.bind.DatatypeConverter;
import org.apache.qpid.server.model.Broker;
import org.apache.qpid.server.model.ManagedObject;
import org.apache.qpid.server.model.ManagedObjectFactoryConstructor;
import org.apache.qpid.server.security.auth.AuthenticationResult;
import org.apache.qpid.server.security.auth.UsernamePrincipal;
import org.apache.qpid.server.security.auth.manager.ConfigModelPasswordManagingAuthenticationProvider;
import org.apache.qpid.server.security.auth.manager.ManagedUser;
import org.apache.qpid.server.security.auth.sasl.crammd5.CRAMMD5HashedSaslServer;
import org.apache.qpid.server.security.auth.sasl.plain.PlainAdapterSaslServer;
import org.apache.qpid.server.util.ServerScopedRuntimeException;
import org.apache.qpid.util.Strings;

@ManagedObject(category=false, type="MD5")
public class MD5AuthenticationProvider
extends ConfigModelPasswordManagingAuthenticationProvider<MD5AuthenticationProvider> {
    private final List<String> _mechanisms = Collections.unmodifiableList(Arrays.asList("PLAIN", "CRAM-MD5-HASHED", "CRAM-MD5-HEX"));
    private static final char[] HEX_CHARACTERS = new char[]{'0', '1', '2', '3', '4', '5', '6', '7', '8', '9', 'a', 'b', 'c', 'd', 'e', 'f'};

    @ManagedObjectFactoryConstructor
    protected MD5AuthenticationProvider(Map<String, Object> attributes, Broker broker) {
        super(attributes, broker);
    }

    @Override
    protected String createStoredPassword(String password) {
        byte[] data = password.getBytes(StandardCharsets.UTF_8);
        MessageDigest md = null;
        try {
            md = MessageDigest.getInstance("MD5");
        }
        catch (NoSuchAlgorithmException e) {
            throw new ServerScopedRuntimeException("MD5 not supported although Java compliance requires it");
        }
        md.update(data);
        return DatatypeConverter.printBase64Binary((byte[])md.digest());
    }

    @Override
    void validateUser(ManagedUser managedUser) {
    }

    @Override
    public List<String> getMechanisms() {
        return this._mechanisms;
    }

    @Override
    public SaslServer createSaslServer(String mechanism, String localFQDN, Principal externalPrincipal) throws SaslException {
        if ("PLAIN".equals(mechanism)) {
            return new PlainAdapterSaslServer(this);
        }
        if ("CRAM-MD5-HASHED".equals(mechanism)) {
            return new CRAMMD5HashedSaslServer(mechanism, "AMQP", localFQDN, null, new MD5Callbackhandler(false));
        }
        if ("CRAM-MD5-HEX".equals(mechanism)) {
            return new CRAMMD5HashedSaslServer(mechanism, "AMQP", localFQDN, null, new MD5Callbackhandler(true));
        }
        throw new SaslException("Unsupported mechanism: " + mechanism);
    }

    @Override
    public AuthenticationResult authenticate(String username, String password) {
        ManagedUser user = this.getUser(username);
        AuthenticationResult result = user != null && user.getPassword().equals(this.createStoredPassword(password)) ? new AuthenticationResult(new UsernamePrincipal(username, this)) : new AuthenticationResult(AuthenticationResult.AuthenticationStatus.ERROR);
        return result;
    }

    private class MD5Callbackhandler
    implements CallbackHandler {
        private final boolean _hexify;
        private String _username;

        public MD5Callbackhandler(boolean hexify) {
            this._hexify = hexify;
        }

        @Override
        public void handle(Callback[] callbacks) throws IOException, UnsupportedCallbackException {
            Callback callback;
            ArrayList<Callback> callbackList = new ArrayList<Callback>(Arrays.asList(callbacks));
            Iterator iter = callbackList.iterator();
            while (iter.hasNext()) {
                callback = (Callback)iter.next();
                if (!(callback instanceof NameCallback)) continue;
                this._username = ((NameCallback)callback).getDefaultName();
                iter.remove();
                break;
            }
            if (this._username != null) {
                iter = callbackList.iterator();
                while (iter.hasNext()) {
                    callback = (Callback)iter.next();
                    if (!(callback instanceof PasswordCallback)) continue;
                    iter.remove();
                    ManagedUser user = MD5AuthenticationProvider.this.getUser(this._username);
                    if (user != null) {
                        int i;
                        char[] password;
                        String passwordData = user.getPassword();
                        byte[] passwordBytes = Strings.decodeBase64((String)passwordData);
                        if (this._hexify) {
                            password = new char[passwordBytes.length * 2];
                            for (i = 0; i < passwordBytes.length; ++i) {
                                password[2 * i] = HEX_CHARACTERS[(passwordBytes[i] & 0xF0) >> 4];
                                password[2 * i + 1] = HEX_CHARACTERS[passwordBytes[i] & 0xF];
                            }
                        } else {
                            password = new char[passwordBytes.length];
                            for (i = 0; i < passwordBytes.length; ++i) {
                                password[i] = (char)passwordBytes[i];
                            }
                        }
                        ((PasswordCallback)callback).setPassword(password);
                        break;
                    }
                    ((PasswordCallback)callback).setPassword(null);
                    break;
                }
            }
            for (Callback callback2 : callbackList) {
                if (callback2 instanceof AuthorizeCallback) {
                    ((AuthorizeCallback)callback2).setAuthorized(true);
                    continue;
                }
                throw new UnsupportedCallbackException(callback2);
            }
        }
    }
}

