/*
 * Decompiled with CFR 0.152.
 */
package org.apache.qpid.server.security.auth.manager;

import java.io.IOException;
import java.security.Principal;
import java.util.Collections;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import javax.security.auth.callback.Callback;
import javax.security.auth.callback.CallbackHandler;
import javax.security.auth.callback.UnsupportedCallbackException;
import javax.security.sasl.AuthorizeCallback;
import javax.security.sasl.Sasl;
import javax.security.sasl.SaslException;
import javax.security.sasl.SaslServer;
import org.apache.qpid.server.model.Container;
import org.apache.qpid.server.model.ManagedObject;
import org.apache.qpid.server.model.ManagedObjectFactoryConstructor;
import org.apache.qpid.server.security.auth.AuthenticationResult;
import org.apache.qpid.server.security.auth.UsernamePrincipal;
import org.apache.qpid.server.security.auth.manager.AbstractAuthenticationManager;

@ManagedObject(category=false, type="Kerberos")
public class KerberosAuthenticationManager
extends AbstractAuthenticationManager<KerberosAuthenticationManager> {
    public static final String PROVIDER_TYPE = "Kerberos";
    private static final String GSSAPI_MECHANISM = "GSSAPI";
    private final CallbackHandler _callbackHandler = new GssApiCallbackHandler();

    @ManagedObjectFactoryConstructor
    protected KerberosAuthenticationManager(Map<String, Object> attributes, Container<?> container) {
        super(attributes, container);
    }

    @Override
    public List<String> getMechanisms() {
        return Collections.singletonList(GSSAPI_MECHANISM);
    }

    @Override
    public SaslServer createSaslServer(String mechanism, String localFQDN, Principal externalPrincipal) throws SaslException {
        if (GSSAPI_MECHANISM.equals(mechanism)) {
            return Sasl.createSaslServer(GSSAPI_MECHANISM, "AMQP", localFQDN, new HashMap(), this._callbackHandler);
        }
        throw new SaslException("Unknown mechanism: " + mechanism);
    }

    @Override
    public AuthenticationResult authenticate(SaslServer server, byte[] response) {
        try {
            byte[] challenge = server.evaluateResponse(response != null ? response : new byte[]{});
            if (server.isComplete()) {
                return new AuthenticationResult(new UsernamePrincipal(server.getAuthorizationID(), this), challenge);
            }
            return new AuthenticationResult(challenge, AuthenticationResult.AuthenticationStatus.CONTINUE);
        }
        catch (SaslException e) {
            return new AuthenticationResult(AuthenticationResult.AuthenticationStatus.ERROR, e);
        }
    }

    private static class GssApiCallbackHandler
    implements CallbackHandler {
        private GssApiCallbackHandler() {
        }

        @Override
        public void handle(Callback[] callbacks) throws IOException, UnsupportedCallbackException {
            for (Callback callback : callbacks) {
                if (!(callback instanceof AuthorizeCallback)) {
                    throw new UnsupportedCallbackException(callback);
                }
                ((AuthorizeCallback)callback).setAuthorized(true);
            }
        }
    }
}

