/*
 * Decompiled with CFR 0.152.
 */
package org.apache.qpid.server.security.auth.manager;

import java.security.Principal;
import java.util.Collections;
import java.util.List;
import java.util.Map;
import javax.security.sasl.SaslException;
import javax.security.sasl.SaslServer;
import org.apache.qpid.server.model.Container;
import org.apache.qpid.server.model.ManagedAttributeField;
import org.apache.qpid.server.model.ManagedObjectFactoryConstructor;
import org.apache.qpid.server.security.auth.AuthenticationResult;
import org.apache.qpid.server.security.auth.manager.AbstractAuthenticationManager;
import org.apache.qpid.server.security.auth.manager.ExternalAuthenticationManager;
import org.apache.qpid.server.security.auth.sasl.external.ExternalSaslServer;

public class ExternalAuthenticationManagerImpl
extends AbstractAuthenticationManager<ExternalAuthenticationManagerImpl>
implements ExternalAuthenticationManager<ExternalAuthenticationManagerImpl> {
    public static final String MECHANISM_NAME = "EXTERNAL";
    @ManagedAttributeField
    private boolean _useFullDN;

    @ManagedObjectFactoryConstructor
    protected ExternalAuthenticationManagerImpl(Map<String, Object> attributes, Container<?> container) {
        super(attributes, container);
    }

    @Override
    public boolean getUseFullDN() {
        return this._useFullDN;
    }

    @Override
    public List<String> getMechanisms() {
        return Collections.singletonList(MECHANISM_NAME);
    }

    @Override
    public SaslServer createSaslServer(String mechanism, String localFQDN, Principal externalPrincipal) throws SaslException {
        if (MECHANISM_NAME.equals(mechanism)) {
            return new ExternalSaslServer(externalPrincipal, this._useFullDN, this);
        }
        throw new SaslException("Unknown mechanism: " + mechanism);
    }

    @Override
    public AuthenticationResult authenticate(SaslServer server, byte[] response) {
        try {
            server.evaluateResponse(response != null ? response : new byte[]{});
            Principal principal = ((ExternalSaslServer)server).getAuthenticatedPrincipal();
            if (principal != null) {
                return new AuthenticationResult(principal);
            }
            return new AuthenticationResult(AuthenticationResult.AuthenticationStatus.ERROR);
        }
        catch (SaslException e) {
            return new AuthenticationResult(AuthenticationResult.AuthenticationStatus.ERROR, e);
        }
    }
}

