/*
 * Decompiled with CFR 0.152.
 */
package org.apache.qpid.server.security.auth.manager;

import java.security.Principal;
import java.util.Collections;
import java.util.List;
import java.util.Map;
import javax.security.sasl.SaslException;
import javax.security.sasl.SaslServer;
import org.apache.qpid.server.model.Container;
import org.apache.qpid.server.model.ManagedObject;
import org.apache.qpid.server.model.ManagedObjectFactoryConstructor;
import org.apache.qpid.server.security.auth.AuthenticationResult;
import org.apache.qpid.server.security.auth.UsernamePrincipal;
import org.apache.qpid.server.security.auth.manager.AbstractAuthenticationManager;
import org.apache.qpid.server.security.auth.sasl.anonymous.AnonymousSaslServer;

@ManagedObject(category=false, type="Anonymous")
public class AnonymousAuthenticationManager
extends AbstractAuthenticationManager<AnonymousAuthenticationManager> {
    public static final String PROVIDER_TYPE = "Anonymous";
    public static final String MECHANISM_NAME = "ANONYMOUS";
    public static final String ANONYMOUS_USERNAME = "ANONYMOUS";
    private final Principal _anonymousPrincipal = new UsernamePrincipal("ANONYMOUS", this);
    private final AuthenticationResult _anonymousAuthenticationResult = new AuthenticationResult(this._anonymousPrincipal);

    @ManagedObjectFactoryConstructor
    protected AnonymousAuthenticationManager(Map<String, Object> attributes, Container<?> container) {
        super(attributes, container);
    }

    @Override
    public List<String> getMechanisms() {
        return Collections.singletonList("ANONYMOUS");
    }

    @Override
    public SaslServer createSaslServer(String mechanism, String localFQDN, Principal externalPrincipal) throws SaslException {
        if ("ANONYMOUS".equals(mechanism)) {
            return new AnonymousSaslServer();
        }
        throw new SaslException("Unknown mechanism: " + mechanism);
    }

    @Override
    public AuthenticationResult authenticate(SaslServer server, byte[] response) {
        try {
            byte[] challenge = server.evaluateResponse(response != null ? response : new byte[]{});
            if (server.isComplete()) {
                return this._anonymousAuthenticationResult;
            }
            return new AuthenticationResult(AuthenticationResult.AuthenticationStatus.ERROR);
        }
        catch (SaslException e) {
            return new AuthenticationResult(AuthenticationResult.AuthenticationStatus.ERROR, e);
        }
    }

    public Principal getAnonymousPrincipal() {
        return this._anonymousPrincipal;
    }

    public AuthenticationResult getAnonymousAuthenticationResult() {
        return this._anonymousAuthenticationResult;
    }
}

