/*
 * Decompiled with CFR 0.152.
 */
package org.apache.qpid.server.security.auth.database;

import org.apache.qpid.server.model.AuthenticationProvider;
import org.apache.qpid.server.security.auth.database.PasswordPrincipal;

public class PlainUser
implements PasswordPrincipal {
    private final AuthenticationProvider<?> _authenticationProvider;
    private String _name;
    private char[] _password;
    private boolean _modified = false;
    private boolean _deleted = false;

    PlainUser(String[] data, AuthenticationProvider<?> authenticationProvider) {
        if (data.length != 2) {
            throw new IllegalArgumentException("User Data should be length 2, username, password");
        }
        this._name = data[0];
        this._password = data[1].toCharArray();
        this._authenticationProvider = authenticationProvider;
    }

    public PlainUser(String name, char[] password, AuthenticationProvider<?> authenticationProvider) {
        this._name = name;
        this._password = password;
        this._authenticationProvider = authenticationProvider;
        this._modified = true;
    }

    @Override
    public String getName() {
        return this._name;
    }

    @Override
    public String toString() {
        return this._name;
    }

    @Override
    public char[] getPassword() {
        return this._password;
    }

    @Override
    public byte[] getEncodedPassword() {
        byte[] byteArray = new byte[this._password.length];
        int index = 0;
        for (char c : this._password) {
            byteArray[index++] = (byte)c;
        }
        return byteArray;
    }

    @Override
    public void restorePassword(char[] password) {
        this.setPassword(password);
    }

    @Override
    public void setPassword(char[] password) {
        this._password = password;
        this._modified = true;
    }

    @Override
    public boolean isModified() {
        return this._modified;
    }

    @Override
    public boolean isDeleted() {
        return this._deleted;
    }

    @Override
    public void delete() {
        this._deleted = true;
    }

    @Override
    public void saved() {
        this._modified = false;
    }
}

