/*
 * Decompiled with CFR 0.152.
 */
package org.apache.qpid.server.security.auth.database;

import java.security.Principal;
import java.util.Arrays;
import java.util.Collections;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import javax.security.auth.callback.CallbackHandler;
import javax.security.auth.login.AccountNotFoundException;
import javax.security.sasl.Sasl;
import javax.security.sasl.SaslException;
import javax.security.sasl.SaslServer;
import org.apache.qpid.server.model.AuthenticationProvider;
import org.apache.qpid.server.security.auth.database.AbstractPasswordFilePrincipalDatabase;
import org.apache.qpid.server.security.auth.database.PlainUser;
import org.apache.qpid.server.security.auth.sasl.crammd5.CRAMMD5Initialiser;
import org.apache.qpid.server.security.auth.sasl.plain.PlainInitialiser;
import org.apache.qpid.server.security.auth.sasl.plain.PlainSaslServer;
import org.apache.qpid.server.security.auth.sasl.scram.ScramSaslServer;
import org.apache.qpid.server.security.auth.sasl.scram.ScramSaslServerSourceAdapter;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class PlainPasswordFilePrincipalDatabase
extends AbstractPasswordFilePrincipalDatabase<PlainUser> {
    private final Logger _logger = LoggerFactory.getLogger(PlainPasswordFilePrincipalDatabase.class);
    private final Map<String, CallbackHandler> _callbackHandlerMap = new HashMap<String, CallbackHandler>();
    private final List<String> _mechanisms = Collections.unmodifiableList(Arrays.asList("PLAIN", "CRAM-MD5", "SCRAM-SHA-1", "SCRAM-SHA-256"));
    private final ScramSaslServerSourceAdapter _scramSha1Adapter;
    private final ScramSaslServerSourceAdapter _scramSha256Adapter;

    public PlainPasswordFilePrincipalDatabase(AuthenticationProvider<?> authenticationProvider) {
        super(authenticationProvider);
        PlainInitialiser plainInitialiser = new PlainInitialiser();
        plainInitialiser.initialise(this);
        this._callbackHandlerMap.put("PLAIN", plainInitialiser.getCallbackHandler());
        this._callbackHandlerMap.put("SCRAM-SHA-1", plainInitialiser.getCallbackHandler());
        this._callbackHandlerMap.put("SCRAM-SHA-256", plainInitialiser.getCallbackHandler());
        CRAMMD5Initialiser crammd5Initialiser = new CRAMMD5Initialiser();
        crammd5Initialiser.initialise(this);
        this._callbackHandlerMap.put("CRAM-MD5", crammd5Initialiser.getCallbackHandler());
        ScramSaslServerSourceAdapter.PasswordSource passwordSource = new ScramSaslServerSourceAdapter.PasswordSource(){

            @Override
            public char[] getPassword(String username) {
                return PlainPasswordFilePrincipalDatabase.this.lookupPassword(username);
            }
        };
        int scramIterationCount = authenticationProvider.getContextValue(Integer.class, "qpid.auth.scram.iteration_count");
        this._scramSha1Adapter = new ScramSaslServerSourceAdapter(scramIterationCount, "HmacSHA1", "SHA-1", passwordSource);
        this._scramSha256Adapter = new ScramSaslServerSourceAdapter(scramIterationCount, "HmacSHA256", "SHA-256", passwordSource);
    }

    @Override
    public boolean verifyPassword(String principal, char[] password) throws AccountNotFoundException {
        char[] pwd = this.lookupPassword(principal);
        if (pwd == null) {
            throw new AccountNotFoundException("Unable to lookup the specified users password");
        }
        return this.compareCharArray(pwd, password);
    }

    @Override
    protected PlainUser createUserFromPassword(Principal principal, char[] passwd) {
        return new PlainUser(principal.getName(), passwd, this.getAuthenticationProvider());
    }

    @Override
    protected PlainUser createUserFromFileData(String[] result) {
        return new PlainUser(result, this.getAuthenticationProvider());
    }

    @Override
    protected Logger getLogger() {
        return this._logger;
    }

    @Override
    public List<String> getMechanisms() {
        return this._mechanisms;
    }

    @Override
    public SaslServer createSaslServer(String mechanism, String localFQDN, Principal externalPrincipal) throws SaslException {
        CallbackHandler callbackHandler = this._callbackHandlerMap.get(mechanism);
        if (callbackHandler == null) {
            throw new SaslException("Unsupported mechanism: " + mechanism);
        }
        if ("CRAM-MD5".equals(mechanism)) {
            return Sasl.createSaslServer(mechanism, "AMQP", localFQDN, null, callbackHandler);
        }
        if ("PLAIN".equals(mechanism)) {
            return new PlainSaslServer(callbackHandler);
        }
        if ("SCRAM-SHA-1".equals(mechanism)) {
            return new ScramSaslServer(this._scramSha1Adapter, mechanism, "HmacSHA1", "SHA-1");
        }
        if ("SCRAM-SHA-256".equals(mechanism)) {
            return new ScramSaslServer(this._scramSha256Adapter, mechanism, "HmacSHA256", "SHA-256");
        }
        throw new SaslException("Unsupported mechanism: " + mechanism);
    }
}

