/*
 * Decompiled with CFR 0.152.
 */
package org.apache.qpid.server.security.auth.database;

import java.io.UnsupportedEncodingException;
import java.nio.charset.StandardCharsets;
import java.security.MessageDigest;
import java.security.NoSuchAlgorithmException;
import javax.xml.bind.DatatypeConverter;
import org.apache.qpid.server.model.AuthenticationProvider;
import org.apache.qpid.server.security.auth.database.PasswordPrincipal;
import org.apache.qpid.server.util.ServerScopedRuntimeException;
import org.apache.qpid.util.Strings;

public class HashedUser
implements PasswordPrincipal {
    private final AuthenticationProvider<?> _authenticationProvider;
    private String _name;
    private char[] _password;
    private byte[] _encodedPassword = null;
    private boolean _modified = false;
    private boolean _deleted = false;

    HashedUser(String[] data, AuthenticationProvider<?> authenticationProvider) {
        byte[] encoded_password;
        if (data.length != 2) {
            throw new IllegalArgumentException("User Data should be length 2, username, password");
        }
        this._name = data[0];
        try {
            encoded_password = data[1].getBytes("utf-8");
        }
        catch (UnsupportedEncodingException e) {
            throw new ServerScopedRuntimeException("MD5 encoding not supported, even though the Java standard requires it", e);
        }
        this._encodedPassword = encoded_password;
        byte[] decoded = Strings.decodeBase64((String)data[1]);
        this._password = new char[decoded.length];
        int index = 0;
        for (byte c : decoded) {
            this._password[index++] = (char)c;
        }
        this._authenticationProvider = authenticationProvider;
    }

    public HashedUser(String name, char[] password, AuthenticationProvider<?> authenticationProvider) {
        this._name = name;
        this._authenticationProvider = authenticationProvider;
        this.setPassword(password, false);
    }

    public static byte[] getMD5(byte[] data) {
        MessageDigest md = null;
        try {
            md = MessageDigest.getInstance("MD5");
        }
        catch (NoSuchAlgorithmException e) {
            throw new ServerScopedRuntimeException("MD5 not supported although Java compliance requires it");
        }
        for (byte b : data) {
            md.update(b);
        }
        return md.digest();
    }

    @Override
    public String getName() {
        return this._name;
    }

    @Override
    public String toString() {
        return this._name;
    }

    @Override
    public char[] getPassword() {
        return this._password;
    }

    @Override
    public void setPassword(char[] password) {
        this.setPassword(password, false);
    }

    @Override
    public void restorePassword(char[] password) {
        this.setPassword(password, true);
    }

    void setPassword(char[] password, boolean alreadyHashed) {
        if (alreadyHashed) {
            this._password = password;
        } else {
            byte[] byteArray = new byte[password.length];
            int index = 0;
            for (char c : password) {
                byteArray[index++] = (byte)c;
            }
            byte[] MD5byteArray = HashedUser.getMD5(byteArray);
            this._password = new char[MD5byteArray.length];
            index = 0;
            for (byte c : MD5byteArray) {
                this._password[index++] = (char)c;
            }
        }
        this._modified = true;
        this._encodedPassword = null;
    }

    @Override
    public byte[] getEncodedPassword() {
        if (this._encodedPassword == null) {
            this.encodePassword();
        }
        return this._encodedPassword;
    }

    private void encodePassword() {
        byte[] byteArray = new byte[this._password.length];
        int index = 0;
        for (char c : this._password) {
            byteArray[index++] = (byte)c;
        }
        this._encodedPassword = DatatypeConverter.printBase64Binary((byte[])byteArray).getBytes(StandardCharsets.UTF_8);
    }

    @Override
    public boolean isModified() {
        return this._modified;
    }

    @Override
    public boolean isDeleted() {
        return this._deleted;
    }

    @Override
    public void delete() {
        this._deleted = true;
    }

    @Override
    public void saved() {
        this._modified = false;
    }
}

