/*
 * Decompiled with CFR 0.152.
 */
package org.apache.qpid.server.security.auth.database;

import java.security.Principal;
import java.util.Arrays;
import java.util.Collections;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import javax.security.auth.callback.CallbackHandler;
import javax.security.auth.login.AccountNotFoundException;
import javax.security.sasl.SaslException;
import javax.security.sasl.SaslServer;
import org.apache.qpid.server.model.AuthenticationProvider;
import org.apache.qpid.server.security.auth.database.AbstractPasswordFilePrincipalDatabase;
import org.apache.qpid.server.security.auth.database.HashedUser;
import org.apache.qpid.server.security.auth.sasl.crammd5.CRAMMD5HashedInitialiser;
import org.apache.qpid.server.security.auth.sasl.crammd5.CRAMMD5HashedSaslServer;
import org.apache.qpid.server.security.auth.sasl.crammd5.CRAMMD5HexInitialiser;
import org.apache.qpid.server.security.auth.sasl.crammd5.CRAMMD5HexSaslServer;
import org.apache.qpid.server.security.auth.sasl.plain.PlainAdapterSaslServer;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class Base64MD5PasswordFilePrincipalDatabase
extends AbstractPasswordFilePrincipalDatabase<HashedUser> {
    private final Logger _logger = LoggerFactory.getLogger(Base64MD5PasswordFilePrincipalDatabase.class);
    private List<String> _mechanisms = Collections.unmodifiableList(Arrays.asList("CRAM-MD5-HASHED", "CRAM-MD5-HEX", "PLAIN"));
    private final Map<String, CallbackHandler> _callbackHandlerMap = new HashMap<String, CallbackHandler>();

    public Base64MD5PasswordFilePrincipalDatabase(AuthenticationProvider<?> authenticationProvider) {
        super(authenticationProvider);
        CRAMMD5HashedInitialiser crammd5HashedInitialiser = new CRAMMD5HashedInitialiser();
        crammd5HashedInitialiser.initialise(this);
        this._callbackHandlerMap.put("CRAM-MD5-HASHED", crammd5HashedInitialiser.getCallbackHandler());
        CRAMMD5HexInitialiser crammd5HexInitialiser = new CRAMMD5HexInitialiser();
        crammd5HexInitialiser.initialise(this);
        this._callbackHandlerMap.put("CRAM-MD5-HEX", crammd5HexInitialiser.getCallbackHandler());
    }

    @Override
    public boolean verifyPassword(String principal, char[] password) throws AccountNotFoundException {
        byte[] MD5byteArray;
        char[] pwd = this.lookupPassword(principal);
        if (pwd == null) {
            throw new AccountNotFoundException("Unable to lookup the specified users password");
        }
        byte[] byteArray = new byte[password.length];
        int index = 0;
        for (char c : password) {
            byteArray[index++] = (byte)c;
        }
        try {
            MD5byteArray = HashedUser.getMD5(byteArray);
        }
        catch (Exception e1) {
            this.getLogger().warn("Unable to hash password for user '" + principal + "' for comparison");
            return false;
        }
        char[] hashedPassword = new char[MD5byteArray.length];
        index = 0;
        for (byte c : MD5byteArray) {
            hashedPassword[index++] = (char)c;
        }
        return this.compareCharArray(pwd, hashedPassword);
    }

    @Override
    protected HashedUser createUserFromPassword(Principal principal, char[] passwd) {
        return new HashedUser(principal.getName(), passwd, this.getAuthenticationProvider());
    }

    @Override
    protected HashedUser createUserFromFileData(String[] result) {
        return new HashedUser(result, this.getAuthenticationProvider());
    }

    @Override
    protected Logger getLogger() {
        return this._logger;
    }

    @Override
    public List<String> getMechanisms() {
        return this._mechanisms;
    }

    @Override
    public SaslServer createSaslServer(String mechanism, String localFQDN, Principal externalPrincipal) throws SaslException {
        if ("CRAM-MD5-HASHED".equals(mechanism)) {
            return new CRAMMD5HashedSaslServer(mechanism, "AMQP", localFQDN, null, this.getCallbackHandler(mechanism));
        }
        if ("CRAM-MD5-HEX".equals(mechanism)) {
            return new CRAMMD5HexSaslServer(mechanism, "AMQP", localFQDN, null, this.getCallbackHandler(mechanism));
        }
        if ("PLAIN".equals(mechanism)) {
            return new PlainAdapterSaslServer(new PlainAdapterSaslServer.PasswordValidator(){

                @Override
                public boolean validatePassword(String user, String password) {
                    try {
                        return Base64MD5PasswordFilePrincipalDatabase.this.verifyPassword(user, password.toCharArray());
                    }
                    catch (AccountNotFoundException e) {
                        return false;
                    }
                }
            });
        }
        throw new SaslException("Unsupported mechanism: " + mechanism);
    }

    private CallbackHandler getCallbackHandler(String mechanism) throws SaslException {
        CallbackHandler callbackHandler = this._callbackHandlerMap.get(mechanism);
        if (callbackHandler == null) {
            throw new SaslException("Unsupported mechanism: " + mechanism);
        }
        return callbackHandler;
    }
}

