/*
 * Decompiled with CFR 0.152.
 */
package org.apache.qpid.server.security;

import java.security.Principal;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Collections;
import java.util.HashSet;
import java.util.List;
import java.util.Set;
import javax.security.auth.Subject;
import javax.security.sasl.SaslException;
import javax.security.sasl.SaslServer;
import org.apache.qpid.server.model.AuthenticationProvider;
import org.apache.qpid.server.model.GroupProvider;
import org.apache.qpid.server.security.auth.AuthenticationResult;
import org.apache.qpid.server.security.auth.SubjectAuthenticationResult;

public class SubjectCreator {
    private final boolean _secure;
    private AuthenticationProvider<?> _authenticationProvider;
    private Collection<GroupProvider<?>> _groupProviders;

    public SubjectCreator(AuthenticationProvider<?> authenticationProvider, Collection<GroupProvider<?>> groupProviders, boolean secure) {
        this._authenticationProvider = authenticationProvider;
        this._groupProviders = groupProviders;
        this._secure = secure;
    }

    public AuthenticationProvider<?> getAuthenticationProvider() {
        return this._authenticationProvider;
    }

    public List<String> getMechanisms() {
        HashSet<String> filter;
        List<String> mechanisms = this._authenticationProvider.getMechanisms();
        HashSet<String> hashSet = filter = this._authenticationProvider.getDisabledMechanisms() != null ? new HashSet<String>(this._authenticationProvider.getDisabledMechanisms()) : new HashSet();
        if (!this._secure) {
            filter.addAll(this._authenticationProvider.getSecureOnlyMechanisms());
        }
        if (!filter.isEmpty()) {
            mechanisms = new ArrayList<String>(mechanisms);
            mechanisms.removeAll(filter);
        }
        return mechanisms;
    }

    public SaslServer createSaslServer(String mechanism, String localFQDN, Principal externalPrincipal) throws SaslException {
        if (!this.getMechanisms().contains(mechanism)) {
            throw new SaslException("Unsupported mechanism: " + mechanism + ".\nSupported mechanisms: " + this.getMechanisms());
        }
        return this._authenticationProvider.createSaslServer(mechanism, localFQDN, externalPrincipal);
    }

    public SubjectAuthenticationResult authenticate(SaslServer server, byte[] response) {
        AuthenticationResult authenticationResult = this._authenticationProvider.authenticate(server, response);
        if (server.isComplete()) {
            return this.createResultWithGroups(authenticationResult);
        }
        return new SubjectAuthenticationResult(authenticationResult);
    }

    public SubjectAuthenticationResult createResultWithGroups(AuthenticationResult authenticationResult) {
        if (authenticationResult.getStatus() == AuthenticationResult.AuthenticationStatus.SUCCESS) {
            Subject authenticationSubject = new Subject();
            authenticationSubject.getPrincipals().addAll(authenticationResult.getPrincipals());
            Set<Principal> groupPrincipals = this.getGroupPrincipals(authenticationResult.getMainPrincipal());
            authenticationSubject.getPrincipals().addAll(groupPrincipals);
            authenticationSubject.setReadOnly();
            return new SubjectAuthenticationResult(authenticationResult, authenticationSubject);
        }
        return new SubjectAuthenticationResult(authenticationResult);
    }

    public Subject createSubjectWithGroups(Principal userPrincipal) {
        Subject authenticationSubject = new Subject();
        authenticationSubject.getPrincipals().add(userPrincipal);
        authenticationSubject.getPrincipals().addAll(this.getGroupPrincipals(userPrincipal));
        authenticationSubject.setReadOnly();
        return authenticationSubject;
    }

    Set<Principal> getGroupPrincipals(Principal userPrincipal) {
        HashSet<Principal> principals = new HashSet<Principal>();
        for (GroupProvider<?> groupProvider : this._groupProviders) {
            Set<Principal> groups = groupProvider.getGroupPrincipalsForUser(userPrincipal);
            if (groups == null) continue;
            principals.addAll(groups);
        }
        return Collections.unmodifiableSet(principals);
    }
}

