/*
 * Decompiled with CFR 0.152.
 */
package org.apache.qpid.server.security;

import com.google.common.util.concurrent.Futures;
import com.google.common.util.concurrent.ListenableFuture;
import java.io.ByteArrayInputStream;
import java.io.IOException;
import java.net.URL;
import java.security.GeneralSecurityException;
import java.security.KeyStore;
import java.security.cert.Certificate;
import java.security.cert.CertificateEncodingException;
import java.security.cert.CertificateException;
import java.security.cert.CertificateFactory;
import java.security.cert.X509Certificate;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Date;
import java.util.List;
import java.util.Map;
import javax.net.ssl.KeyManager;
import javax.net.ssl.SSLContext;
import javax.net.ssl.SSLSocket;
import javax.net.ssl.TrustManager;
import javax.net.ssl.TrustManagerFactory;
import javax.net.ssl.X509TrustManager;
import javax.xml.bind.DatatypeConverter;
import org.apache.qpid.server.configuration.IllegalConfigurationException;
import org.apache.qpid.server.configuration.updater.Task;
import org.apache.qpid.server.logging.EventLogger;
import org.apache.qpid.server.logging.messages.TrustStoreMessages;
import org.apache.qpid.server.model.AbstractConfiguredObject;
import org.apache.qpid.server.model.AuthenticationProvider;
import org.apache.qpid.server.model.Broker;
import org.apache.qpid.server.model.IntegrityViolationException;
import org.apache.qpid.server.model.ManagedAttributeField;
import org.apache.qpid.server.model.ManagedObject;
import org.apache.qpid.server.model.ManagedObjectFactoryConstructor;
import org.apache.qpid.server.model.Port;
import org.apache.qpid.server.model.State;
import org.apache.qpid.server.model.StateTransition;
import org.apache.qpid.server.model.TrustStore;
import org.apache.qpid.server.model.VirtualHostNode;
import org.apache.qpid.server.security.SiteSpecificTrustStore;
import org.apache.qpid.transport.network.security.ssl.SSLUtil;
import org.apache.qpid.transport.util.Functions;
import org.apache.qpid.util.Strings;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

@ManagedObject(category=false)
public class SiteSpecificTrustStoreImpl
extends AbstractConfiguredObject<SiteSpecificTrustStoreImpl>
implements SiteSpecificTrustStore<SiteSpecificTrustStoreImpl> {
    private static final Logger LOGGER = LoggerFactory.getLogger(SiteSpecificTrustStoreImpl.class);
    private final Broker<?> _broker;
    private final EventLogger _eventLogger;
    @ManagedAttributeField
    private String _siteUrl;
    @ManagedAttributeField
    private boolean _exposedAsMessageSource;
    @ManagedAttributeField
    private List<VirtualHostNode<?>> _includedVirtualHostNodeMessageSources;
    @ManagedAttributeField
    private List<VirtualHostNode<?>> _excludedVirtualHostNodeMessageSources;
    private volatile TrustManager[] _trustManagers = new TrustManager[0];
    private volatile X509Certificate _x509Certificate;

    @ManagedObjectFactoryConstructor
    public SiteSpecificTrustStoreImpl(Map<String, Object> attributes, Broker<?> broker) {
        super(SiteSpecificTrustStoreImpl.parentsMap(broker), attributes);
        this._broker = broker;
        this._eventLogger = this._broker.getEventLogger();
        this._eventLogger.message(TrustStoreMessages.CREATE(this.getName()));
    }

    @Override
    public String getSiteUrl() {
        return this._siteUrl;
    }

    @Override
    protected void postResolve() {
        super.postResolve();
        if (this.getActualAttributes().containsKey("certificate")) {
            this.decodeCertificate();
        }
    }

    @Override
    public String getCertificate() {
        if (this._x509Certificate != null) {
            try {
                return DatatypeConverter.printBase64Binary((byte[])this._x509Certificate.getEncoded());
            }
            catch (CertificateEncodingException e) {
                throw new IllegalConfigurationException("Unable to encode certificate");
            }
        }
        return null;
    }

    @Override
    public TrustManager[] getTrustManagers() throws GeneralSecurityException {
        if (this._trustManagers == null || this._trustManagers.length == 0) {
            throw new IllegalStateException("Truststore " + this + " defines no trust managers");
        }
        return this._trustManagers;
    }

    @Override
    public Certificate[] getCertificates() throws GeneralSecurityException {
        return new Certificate[]{this._x509Certificate};
    }

    @StateTransition(currentState={State.ACTIVE, State.ERRORED}, desiredState=State.DELETED)
    protected ListenableFuture<Void> doDelete() {
        String storeName = this.getName();
        ArrayList ports = new ArrayList(this._broker.getPorts());
        for (Port port : ports) {
            Collection<TrustStore> collection = port.getTrustStores();
            if (collection == null) continue;
            for (TrustStore store : collection) {
                if (!storeName.equals(store.getAttribute("name"))) continue;
                throw new IntegrityViolationException("Trust store '" + storeName + "' can't be deleted as it is in use by a port: " + port.getName());
            }
        }
        ArrayList authenticationProviders = new ArrayList(this._broker.getAuthenticationProviders());
        for (AuthenticationProvider authenticationProvider : authenticationProviders) {
            if (!authenticationProvider.getAttributeNames().contains("trustStore")) continue;
            Object attributeType = authenticationProvider.getAttribute("type");
            Object attributeValue = authenticationProvider.getAttribute("trustStore");
            if (!"SimpleLDAP".equals(attributeType) || !storeName.equals(attributeValue)) continue;
            throw new IntegrityViolationException("Trust store '" + storeName + "' can't be deleted as it is in use by an authentication manager: " + authenticationProvider.getName());
        }
        this.deleted();
        this.setState(State.DELETED);
        this._eventLogger.message(TrustStoreMessages.DELETE(this.getName()));
        return Futures.immediateFuture(null);
    }

    @StateTransition(currentState={State.UNINITIALIZED, State.ERRORED}, desiredState=State.ACTIVE)
    protected ListenableFuture<Void> doActivate() {
        if (this._x509Certificate == null) {
            this.downloadCertificate();
        }
        if (this._x509Certificate != null) {
            this.generateTrustManagers();
            this.setState(State.ACTIVE);
        } else {
            this.setState(State.ERRORED);
        }
        return Futures.immediateFuture(null);
    }

    private void downloadCertificate() {
        try {
            URL url = new URL(this.getSiteUrl());
            SSLContext sslContext = SSLUtil.tryGetSSLContext();
            sslContext.init(new KeyManager[0], new TrustManager[]{new AlwaysTrustManager()}, null);
            try (SSLSocket socket = (SSLSocket)sslContext.getSocketFactory().createSocket(url.getHost(), url.getPort());){
                socket.startHandshake();
                final Certificate[] certificateChain = socket.getSession().getPeerCertificates();
                if (certificateChain != null && certificateChain.length != 0 && certificateChain[0] instanceof X509Certificate) {
                    this.runTask(new Task<Void, RuntimeException>(){

                        @Override
                        public Void execute() throws RuntimeException {
                            SiteSpecificTrustStoreImpl.this._x509Certificate = (X509Certificate)certificateChain[0];
                            String certificate = SiteSpecificTrustStoreImpl.this.getCertificate();
                            SiteSpecificTrustStoreImpl.this.attributeSet("certificate", certificate, certificate);
                            return null;
                        }

                        @Override
                        public String getObject() {
                            return SiteSpecificTrustStoreImpl.this.getName();
                        }

                        @Override
                        public String getAction() {
                            return "downloadCertificate";
                        }

                        @Override
                        public String getArguments() {
                            return null;
                        }
                    });
                } else {
                    LOGGER.info("No valid certificates available from " + this.getSiteUrl());
                }
            }
        }
        catch (IOException | GeneralSecurityException e) {
            LOGGER.info("Unable to download certificate from " + this.getSiteUrl(), (Throwable)e);
        }
    }

    private void decodeCertificate() {
        byte[] certificateEncoded = Strings.decodeBase64((String)((String)this.getActualAttributes().get("certificate")));
        try (ByteArrayInputStream input = new ByteArrayInputStream(certificateEncoded);){
            CertificateFactory cf = CertificateFactory.getInstance("X.509");
            this._x509Certificate = (X509Certificate)cf.generateCertificate(input);
        }
        catch (IOException | CertificateException e) {
            throw new IllegalConfigurationException("Could not decode certificate", e);
        }
    }

    private void generateTrustManagers() {
        try {
            KeyStore inMemoryKeyStore = KeyStore.getInstance(KeyStore.getDefaultType());
            inMemoryKeyStore.load(null, null);
            inMemoryKeyStore.setCertificateEntry("1", this._x509Certificate);
            TrustManagerFactory tmf = TrustManagerFactory.getInstance(TrustManagerFactory.getDefaultAlgorithm());
            tmf.init(inMemoryKeyStore);
            this._trustManagers = tmf.getTrustManagers();
        }
        catch (IOException | GeneralSecurityException e) {
            throw new IllegalConfigurationException("Cannot load certificate(s) :" + e, e);
        }
    }

    @Override
    public boolean isExposedAsMessageSource() {
        return this._exposedAsMessageSource;
    }

    @Override
    public List<VirtualHostNode<?>> getIncludedVirtualHostNodeMessageSources() {
        return this._includedVirtualHostNodeMessageSources;
    }

    @Override
    public List<VirtualHostNode<?>> getExcludedVirtualHostNodeMessageSources() {
        return this._excludedVirtualHostNodeMessageSources;
    }

    @Override
    public String getCertificateIssuer() {
        return this._x509Certificate == null ? null : this._x509Certificate.getIssuerX500Principal().toString();
    }

    @Override
    public String getCertificateSubject() {
        return this._x509Certificate == null ? null : this._x509Certificate.getSubjectX500Principal().toString();
    }

    @Override
    public String getCertificateSerialNumber() {
        return this._x509Certificate == null ? null : this._x509Certificate.getSerialNumber().toString();
    }

    @Override
    public String getCertificateSignature() {
        return this._x509Certificate == null ? null : Functions.hex((byte[])this._x509Certificate.getSignature(), (int)4096, (CharSequence)" ");
    }

    @Override
    public Date getCertificateValidFromDate() {
        return this._x509Certificate == null ? null : this._x509Certificate.getNotBefore();
    }

    @Override
    public Date getCertificateValidUntilDate() {
        return this._x509Certificate == null ? null : this._x509Certificate.getNotAfter();
    }

    @Override
    public void refreshCertificate() {
        this.downloadCertificate();
    }

    private static class AlwaysTrustManager
    implements X509TrustManager {
        private AlwaysTrustManager() {
        }

        @Override
        public void checkClientTrusted(X509Certificate[] chain, String authType) throws CertificateException {
        }

        @Override
        public void checkServerTrusted(X509Certificate[] chain, String authType) throws CertificateException {
        }

        @Override
        public X509Certificate[] getAcceptedIssuers() {
            return new X509Certificate[0];
        }
    }
}

