/*
 * Decompiled with CFR 0.152.
 */
package org.apache.qpid.server.security;

import java.util.Date;
import org.apache.qpid.server.model.DerivedAttribute;
import org.apache.qpid.server.model.ManagedAttribute;
import org.apache.qpid.server.model.ManagedObject;
import org.apache.qpid.server.model.ManagedOperation;
import org.apache.qpid.server.model.TrustStore;

@ManagedObject(category=false, type="SiteSpecificTrustStore", description="Obtains a SSL/TLS certificate from a given URL which the Trust Store will trust for secure connections (e.g., HTTPS or AMQPS)")
public interface SiteSpecificTrustStore<X extends SiteSpecificTrustStore<X>>
extends TrustStore<X> {
    public static final String CERTIFICATE = "certificate";

    @ManagedAttribute(immutable=true, description="The URL from which to obtain the trusted certificate. This must include the protocol and port. Example: https://example.com:443")
    public String getSiteUrl();

    @DerivedAttribute(persist=true, description="The X.509 certificate obtained from the given URL as base64 encoded representation of the ASN.1 DER encoding")
    public String getCertificate();

    @DerivedAttribute(description="The distinguished name of the issuer of the certificate or null if no issuer information is present")
    public String getCertificateIssuer();

    @DerivedAttribute(description="The distinguished name of the subject of the certificate or null if no subject information is present")
    public String getCertificateSubject();

    @DerivedAttribute(description="The serial number of the certificate assigned by the CA or null if no serial number is present")
    public String getCertificateSerialNumber();

    @DerivedAttribute(description="A (possibly truncated) hex encoded representation of the signature. The bytes are separated by spaces. null if no signature information is present")
    public String getCertificateSignature();

    @DerivedAttribute(description="The start date of the validity of the certificate")
    public Date getCertificateValidFromDate();

    @DerivedAttribute(description="The end date of the validity of the certificate")
    public Date getCertificateValidUntilDate();

    @ManagedOperation(description="Re-download the certificate from the URL", changesConfiguredObjectState=false)
    public void refreshCertificate();
}

