/*
 * Decompiled with CFR 0.152.
 */
package org.apache.qpid.server.security;

import com.google.common.util.concurrent.Futures;
import com.google.common.util.concurrent.ListenableFuture;
import java.io.File;
import java.io.IOException;
import java.net.MalformedURLException;
import java.net.URL;
import java.security.GeneralSecurityException;
import java.security.KeyStore;
import java.security.cert.Certificate;
import java.security.cert.X509Certificate;
import java.util.ArrayList;
import java.util.Collection;
import java.util.EnumMap;
import java.util.List;
import java.util.Map;
import java.util.Set;
import javax.naming.InvalidNameException;
import javax.naming.ldap.LdapName;
import javax.naming.ldap.Rdn;
import javax.net.ssl.TrustManager;
import javax.net.ssl.TrustManagerFactory;
import javax.security.auth.x500.X500Principal;
import org.apache.qpid.server.configuration.IllegalConfigurationException;
import org.apache.qpid.server.logging.EventLogger;
import org.apache.qpid.server.logging.messages.TrustStoreMessages;
import org.apache.qpid.server.model.AbstractConfiguredObject;
import org.apache.qpid.server.model.AuthenticationProvider;
import org.apache.qpid.server.model.Broker;
import org.apache.qpid.server.model.ConfiguredObject;
import org.apache.qpid.server.model.IntegrityViolationException;
import org.apache.qpid.server.model.ManagedAttributeField;
import org.apache.qpid.server.model.ManagedObject;
import org.apache.qpid.server.model.ManagedObjectFactoryConstructor;
import org.apache.qpid.server.model.Port;
import org.apache.qpid.server.model.State;
import org.apache.qpid.server.model.StateTransition;
import org.apache.qpid.server.model.TrustStore;
import org.apache.qpid.server.model.VirtualHostNode;
import org.apache.qpid.server.security.NonJavaTrustStore;
import org.apache.qpid.server.util.urlstreamhandler.data.Handler;
import org.apache.qpid.transport.network.security.ssl.SSLUtil;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

@ManagedObject(category=false)
public class NonJavaTrustStoreImpl
extends AbstractConfiguredObject<NonJavaTrustStoreImpl>
implements NonJavaTrustStore<NonJavaTrustStoreImpl> {
    private static final Logger LOGGER = LoggerFactory.getLogger(NonJavaTrustStoreImpl.class);
    private final Broker<?> _broker;
    private final EventLogger _eventLogger;
    @ManagedAttributeField(afterSet="updateTrustManagers")
    private String _certificatesUrl;
    @ManagedAttributeField
    private boolean _exposedAsMessageSource;
    @ManagedAttributeField
    private List<VirtualHostNode<?>> _includedVirtualHostNodeMessageSources;
    @ManagedAttributeField
    private List<VirtualHostNode<?>> _excludedVirtualHostNodeMessageSources;
    private volatile TrustManager[] _trustManagers = new TrustManager[0];
    private X509Certificate[] _certificates;

    @ManagedObjectFactoryConstructor
    public NonJavaTrustStoreImpl(Map<String, Object> attributes, Broker<?> broker) {
        super(NonJavaTrustStoreImpl.parentsMap(broker), attributes);
        this._broker = broker;
        this._eventLogger = this._broker.getEventLogger();
        this._eventLogger.message(TrustStoreMessages.CREATE(this.getName()));
    }

    @Override
    public String getCertificatesUrl() {
        return this._certificatesUrl;
    }

    @Override
    public List<Map<NonJavaTrustStore.CertificateDetails, Object>> getCertificateDetails() {
        ArrayList<Map<NonJavaTrustStore.CertificateDetails, Object>> certificateDetails = new ArrayList<Map<NonJavaTrustStore.CertificateDetails, Object>>();
        if (this._certificates != null) {
            for (X509Certificate certificate : this._certificates) {
                EnumMap<NonJavaTrustStore.CertificateDetails, Object> details = new EnumMap<NonJavaTrustStore.CertificateDetails, Object>(NonJavaTrustStore.CertificateDetails.class);
                details.put(NonJavaTrustStore.CertificateDetails.SUBJECT_NAME, this.getNameFromCertificate(certificate));
                details.put(NonJavaTrustStore.CertificateDetails.ISSUER_NAME, certificate.getIssuerX500Principal().getName());
                details.put(NonJavaTrustStore.CertificateDetails.VALID_START, certificate.getNotBefore());
                details.put(NonJavaTrustStore.CertificateDetails.VALID_END, certificate.getNotAfter());
                certificateDetails.add(details);
            }
        }
        return certificateDetails;
    }

    private String getNameFromCertificate(X509Certificate certificate) {
        X500Principal subjectX500Principal = certificate.getSubjectX500Principal();
        String name = this.getCommonNameFromPrincipal(subjectX500Principal);
        return name;
    }

    private String getCommonNameFromPrincipal(X500Principal subjectX500Principal) {
        String name;
        String dn = subjectX500Principal.getName();
        try {
            LdapName ldapDN = new LdapName(dn);
            name = dn;
            for (Rdn rdn : ldapDN.getRdns()) {
                if (!rdn.getType().equalsIgnoreCase("CN")) continue;
                name = String.valueOf(rdn.getValue());
                break;
            }
        }
        catch (InvalidNameException e) {
            LOGGER.error("Error getting subject name from certificate");
            name = null;
        }
        return name;
    }

    @Override
    public TrustManager[] getTrustManagers() throws GeneralSecurityException {
        if (this._trustManagers == null || this._trustManagers.length == 0) {
            throw new IllegalStateException("Truststore " + this + " defines no trust managers");
        }
        return this._trustManagers;
    }

    @Override
    public Certificate[] getCertificates() throws GeneralSecurityException {
        try {
            return SSLUtil.readCertificates((URL)this.getUrlFromString(this.getCertificatesUrl()));
        }
        catch (IOException e) {
            throw new GeneralSecurityException(e);
        }
    }

    @Override
    public void onValidate() {
        super.onValidate();
        this.validateTrustStoreAttributes(this);
    }

    @StateTransition(currentState={State.ACTIVE, State.ERRORED}, desiredState=State.DELETED)
    protected ListenableFuture<Void> doDelete() {
        String storeName = this.getName();
        ArrayList ports = new ArrayList(this._broker.getPorts());
        for (Port port : ports) {
            Collection<TrustStore> collection = port.getTrustStores();
            if (collection == null) continue;
            for (TrustStore store : collection) {
                if (!storeName.equals(store.getAttribute("name"))) continue;
                throw new IntegrityViolationException("Trust store '" + storeName + "' can't be deleted as it is in use by a port: " + port.getName());
            }
        }
        ArrayList authenticationProviders = new ArrayList(this._broker.getAuthenticationProviders());
        for (AuthenticationProvider authenticationProvider : authenticationProviders) {
            if (!authenticationProvider.getAttributeNames().contains("trustStore")) continue;
            Object attributeType = authenticationProvider.getAttribute("type");
            Object attributeValue = authenticationProvider.getAttribute("trustStore");
            if (!"SimpleLDAP".equals(attributeType) || !storeName.equals(attributeValue)) continue;
            throw new IntegrityViolationException("Trust store '" + storeName + "' can't be deleted as it is in use by an authentication manager: " + authenticationProvider.getName());
        }
        this.deleted();
        this.setState(State.DELETED);
        this._eventLogger.message(TrustStoreMessages.DELETE(this.getName()));
        return Futures.immediateFuture(null);
    }

    @StateTransition(currentState={State.UNINITIALIZED, State.ERRORED}, desiredState=State.ACTIVE)
    protected ListenableFuture<Void> doActivate() {
        this.setState(State.ACTIVE);
        return Futures.immediateFuture(null);
    }

    @Override
    protected void validateChange(ConfiguredObject<?> proxyForValidation, Set<String> changedAttributes) {
        super.validateChange(proxyForValidation, changedAttributes);
        NonJavaTrustStore changedStore = (NonJavaTrustStore)proxyForValidation;
        if (changedAttributes.contains("name") && !this.getName().equals(changedStore.getName())) {
            throw new IllegalConfigurationException("Changing the key store name is not allowed");
        }
        this.validateTrustStoreAttributes(changedStore);
    }

    private void validateTrustStoreAttributes(NonJavaTrustStore<?> keyStore) {
        try {
            SSLUtil.readCertificates((URL)this.getUrlFromString(keyStore.getCertificatesUrl()));
        }
        catch (IOException | GeneralSecurityException e) {
            throw new IllegalArgumentException("Cannot validate certificate(s):" + e, e);
        }
    }

    private void updateTrustManagers() {
        try {
            if (this._certificatesUrl != null) {
                X509Certificate[] certs = SSLUtil.readCertificates((URL)this.getUrlFromString(this._certificatesUrl));
                KeyStore inMemoryKeyStore = KeyStore.getInstance(KeyStore.getDefaultType());
                inMemoryKeyStore.load(null, null);
                int i = 1;
                for (X509Certificate cert : certs) {
                    inMemoryKeyStore.setCertificateEntry(String.valueOf(i++), cert);
                }
                TrustManagerFactory tmf = TrustManagerFactory.getInstance(TrustManagerFactory.getDefaultAlgorithm());
                tmf.init(inMemoryKeyStore);
                this._trustManagers = tmf.getTrustManagers();
                this._certificates = certs;
            }
        }
        catch (IOException | GeneralSecurityException e) {
            throw new IllegalConfigurationException("Cannot load certificate(s) :" + e, e);
        }
    }

    private URL getUrlFromString(String urlString) throws MalformedURLException {
        URL url;
        try {
            url = new URL(urlString);
        }
        catch (MalformedURLException e) {
            File file = new File(urlString);
            url = file.toURI().toURL();
        }
        return url;
    }

    @Override
    public boolean isExposedAsMessageSource() {
        return this._exposedAsMessageSource;
    }

    @Override
    public List<VirtualHostNode<?>> getIncludedVirtualHostNodeMessageSources() {
        return this._includedVirtualHostNodeMessageSources;
    }

    @Override
    public List<VirtualHostNode<?>> getExcludedVirtualHostNodeMessageSources() {
        return this._excludedVirtualHostNodeMessageSources;
    }

    static {
        Handler.register();
    }
}

