/*
 * Decompiled with CFR 0.152.
 */
package org.apache.qpid.server.security;

import com.google.common.util.concurrent.Futures;
import com.google.common.util.concurrent.ListenableFuture;
import java.security.cert.Certificate;
import java.util.List;
import java.util.Map;
import org.apache.qpid.server.configuration.updater.Task;
import org.apache.qpid.server.model.Broker;
import org.apache.qpid.server.security.CertificateDetails;
import org.apache.qpid.server.security.ManagedPeerCertificateTrustStoreImpl;
import org.apache.qpid.server.security.access.Operation;
import org.apache.qpid.server.util.FixedKeyMapCreator;

final class ManagedPeerCertificateTrustStoreImplWithAccessChecking
extends ManagedPeerCertificateTrustStoreImpl {
    private static final FixedKeyMapCreator ADD_CERTIFICATE_MAP_CREATOR = new FixedKeyMapCreator("certificate");
    private static final FixedKeyMapCreator REMOVE_CERTIFICATES_MAP_CREATOR = new FixedKeyMapCreator("certificates");

    ManagedPeerCertificateTrustStoreImplWithAccessChecking(Map<String, Object> attributes, Broker<?> broker) {
        super(attributes, broker);
    }

    @Override
    public void addCertificate(final Certificate certificate) {
        this.authorise(Operation.METHOD("addCertificate"), ADD_CERTIFICATE_MAP_CREATOR.createMap(certificate));
        this.doSync(this.doOnConfigThread(new Task<ListenableFuture<Void>, RuntimeException>(){
            private String _args;

            @Override
            public ListenableFuture<Void> execute() {
                ManagedPeerCertificateTrustStoreImplWithAccessChecking.super.addCertificate(certificate);
                return Futures.immediateFuture(null);
            }

            @Override
            public String getObject() {
                return ManagedPeerCertificateTrustStoreImplWithAccessChecking.this.toString();
            }

            @Override
            public String getAction() {
                return "addCertificate";
            }

            @Override
            public String getArguments() {
                if (this._args == null) {
                    this._args = "certificate=" + certificate;
                }
                return this._args;
            }
        }));
    }

    @Override
    public void removeCertificates(final List<CertificateDetails> certificates) {
        this.authorise(Operation.METHOD("removeCertificates"), REMOVE_CERTIFICATES_MAP_CREATOR.createMap(certificates));
        this.doSync(this.doOnConfigThread(new Task<ListenableFuture<Void>, RuntimeException>(){
            private String _args;

            @Override
            public ListenableFuture<Void> execute() {
                ManagedPeerCertificateTrustStoreImplWithAccessChecking.super.removeCertificates(certificates);
                return Futures.immediateFuture(null);
            }

            @Override
            public String getObject() {
                return ManagedPeerCertificateTrustStoreImplWithAccessChecking.this.toString();
            }

            @Override
            public String getAction() {
                return "removeCertificates";
            }

            @Override
            public String getArguments() {
                if (this._args == null) {
                    this._args = "certificates=" + certificates;
                }
                return this._args;
            }
        }));
    }
}

