/*
 * Decompiled with CFR 0.152.
 */
package org.apache.qpid.server.security;

import com.google.common.util.concurrent.Futures;
import com.google.common.util.concurrent.ListenableFuture;
import java.io.IOException;
import java.math.BigInteger;
import java.security.GeneralSecurityException;
import java.security.KeyStore;
import java.security.cert.Certificate;
import java.security.cert.CertificateParsingException;
import java.security.cert.X509Certificate;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Collections;
import java.util.Date;
import java.util.HashMap;
import java.util.HashSet;
import java.util.Iterator;
import java.util.LinkedHashSet;
import java.util.List;
import java.util.Map;
import java.util.Set;
import javax.net.ssl.TrustManager;
import javax.net.ssl.TrustManagerFactory;
import javax.net.ssl.X509TrustManager;
import org.apache.qpid.server.configuration.IllegalConfigurationException;
import org.apache.qpid.server.logging.EventLogger;
import org.apache.qpid.server.logging.messages.TrustStoreMessages;
import org.apache.qpid.server.model.AbstractConfiguredObject;
import org.apache.qpid.server.model.AuthenticationProvider;
import org.apache.qpid.server.model.Broker;
import org.apache.qpid.server.model.ConfiguredObject;
import org.apache.qpid.server.model.IntegrityViolationException;
import org.apache.qpid.server.model.ManagedAttributeField;
import org.apache.qpid.server.model.ManagedAttributeValue;
import org.apache.qpid.server.model.ManagedObject;
import org.apache.qpid.server.model.ManagedObjectFactoryConstructor;
import org.apache.qpid.server.model.Port;
import org.apache.qpid.server.model.State;
import org.apache.qpid.server.model.StateTransition;
import org.apache.qpid.server.model.TrustStore;
import org.apache.qpid.server.model.VirtualHostNode;
import org.apache.qpid.server.security.CertificateDetails;
import org.apache.qpid.server.security.ManagedPeerCertificateTrustStore;
import org.apache.qpid.transport.network.security.ssl.QpidMultipleTrustManager;
import org.apache.qpid.transport.network.security.ssl.QpidPeersOnlyTrustManager;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

@ManagedObject(category=false)
public class ManagedPeerCertificateTrustStoreImpl
extends AbstractConfiguredObject<ManagedPeerCertificateTrustStoreImpl>
implements ManagedPeerCertificateTrustStore<ManagedPeerCertificateTrustStoreImpl> {
    private static final Logger LOGGER = LoggerFactory.getLogger(ManagedPeerCertificateTrustStoreImpl.class);
    private final Broker<?> _broker;
    private final EventLogger _eventLogger;
    @ManagedAttributeField
    private boolean _exposedAsMessageSource;
    @ManagedAttributeField
    private List<VirtualHostNode<?>> _includedVirtualHostNodeMessageSources;
    @ManagedAttributeField
    private List<VirtualHostNode<?>> _excludedVirtualHostNodeMessageSources;
    private volatile TrustManager[] _trustManagers = new TrustManager[0];
    @ManagedAttributeField(afterSet="updateTrustManagers")
    private final List<Certificate> _storedCertificates = new ArrayList<Certificate>();

    @ManagedObjectFactoryConstructor
    public ManagedPeerCertificateTrustStoreImpl(Map<String, Object> attributes, Broker<?> broker) {
        super(ManagedPeerCertificateTrustStoreImpl.parentsMap(broker), attributes);
        this._broker = broker;
        this._eventLogger = this._broker.getEventLogger();
        this._eventLogger.message(TrustStoreMessages.CREATE(this.getName()));
    }

    @Override
    public TrustManager[] getTrustManagers() {
        if (this._trustManagers == null || this._trustManagers.length == 0) {
            throw new IllegalStateException("Truststore " + this + " defines no trust managers");
        }
        return this._trustManagers;
    }

    @Override
    public Certificate[] getCertificates() {
        return this._storedCertificates.toArray(new Certificate[this._storedCertificates.size()]);
    }

    @StateTransition(currentState={State.ACTIVE, State.ERRORED}, desiredState=State.DELETED)
    protected ListenableFuture<Void> doDelete() {
        String storeName = this.getName();
        ArrayList ports = new ArrayList(this._broker.getPorts());
        for (Port port : ports) {
            Collection<TrustStore> collection = port.getTrustStores();
            if (collection == null) continue;
            for (TrustStore store : collection) {
                if (!storeName.equals(store.getAttribute("name"))) continue;
                throw new IntegrityViolationException("Trust store '" + storeName + "' can't be deleted as it is in use by a port: " + port.getName());
            }
        }
        ArrayList authenticationProviders = new ArrayList(this._broker.getAuthenticationProviders());
        for (AuthenticationProvider authenticationProvider : authenticationProviders) {
            if (!authenticationProvider.getAttributeNames().contains("trustStore")) continue;
            Object attributeType = authenticationProvider.getAttribute("type");
            Object attributeValue = authenticationProvider.getAttribute("trustStore");
            if (!"SimpleLDAP".equals(attributeType) || !storeName.equals(attributeValue)) continue;
            throw new IntegrityViolationException("Trust store '" + storeName + "' can't be deleted as it is in use by an authentication manager: " + authenticationProvider.getName());
        }
        this.deleted();
        this.setState(State.DELETED);
        this._eventLogger.message(TrustStoreMessages.DELETE(this.getName()));
        return Futures.immediateFuture(null);
    }

    @StateTransition(currentState={State.UNINITIALIZED, State.ERRORED}, desiredState=State.ACTIVE)
    protected ListenableFuture<Void> doActivate() {
        this.setState(State.ACTIVE);
        return Futures.immediateFuture(null);
    }

    @Override
    protected void validateChange(ConfiguredObject<?> proxyForValidation, Set<String> changedAttributes) {
        super.validateChange(proxyForValidation, changedAttributes);
        ManagedPeerCertificateTrustStore changedStore = (ManagedPeerCertificateTrustStore)proxyForValidation;
        if (changedAttributes.contains("name") && !this.getName().equals(changedStore.getName())) {
            throw new IllegalConfigurationException("Changing the key store name is not allowed");
        }
    }

    private void updateTrustManagers() {
        try {
            TrustManager[] delegateManagers;
            KeyStore inMemoryKeyStore = KeyStore.getInstance(KeyStore.getDefaultType());
            inMemoryKeyStore.load(null, null);
            int i = 1;
            for (Certificate cert : this._storedCertificates) {
                inMemoryKeyStore.setCertificateEntry(String.valueOf(i++), cert);
            }
            TrustManagerFactory tmf = TrustManagerFactory.getInstance(TrustManagerFactory.getDefaultAlgorithm());
            tmf.init(inMemoryKeyStore);
            ArrayList<TrustManager> trustManagersCol = new ArrayList<TrustManager>();
            QpidMultipleTrustManager mulTrustManager = new QpidMultipleTrustManager();
            for (TrustManager tm : delegateManagers = tmf.getTrustManagers()) {
                if (tm instanceof X509TrustManager) {
                    mulTrustManager.addTrustManager((X509TrustManager)new QpidPeersOnlyTrustManager(inMemoryKeyStore, (X509TrustManager)tm));
                    continue;
                }
                trustManagersCol.add(tm);
            }
            if (!mulTrustManager.isEmpty()) {
                trustManagersCol.add((TrustManager)mulTrustManager);
            }
            this._trustManagers = trustManagersCol.isEmpty() ? null : trustManagersCol.toArray(new TrustManager[trustManagersCol.size()]);
        }
        catch (IOException | GeneralSecurityException e) {
            throw new IllegalConfigurationException("Cannot load certificate(s) :" + e, e);
        }
    }

    @Override
    public boolean isExposedAsMessageSource() {
        return this._exposedAsMessageSource;
    }

    @Override
    public List<VirtualHostNode<?>> getIncludedVirtualHostNodeMessageSources() {
        return this._includedVirtualHostNodeMessageSources;
    }

    @Override
    public List<VirtualHostNode<?>> getExcludedVirtualHostNodeMessageSources() {
        return this._excludedVirtualHostNodeMessageSources;
    }

    @Override
    public List<Certificate> getStoredCertificates() {
        return this._storedCertificates;
    }

    @Override
    public void addCertificate(Certificate cert) {
        LinkedHashSet<Certificate> certificates = new LinkedHashSet<Certificate>(this._storedCertificates);
        if (certificates.add(cert)) {
            this.setAttributes(Collections.singletonMap("storedCertificates", certificates));
        }
    }

    @Override
    public List<CertificateDetails> getCertificateDetails() {
        ArrayList<CertificateDetails> details = new ArrayList<CertificateDetails>();
        for (Certificate cert : this._storedCertificates) {
            if (!(cert instanceof X509Certificate)) continue;
            details.add(new CertificateDetailsImpl((X509Certificate)cert));
        }
        return details;
    }

    @Override
    public void removeCertificates(List<CertificateDetails> certs) {
        HashMap certsToRemove = new HashMap();
        for (CertificateDetails cert : certs) {
            if (!certsToRemove.containsKey(cert.getIssuerName())) {
                certsToRemove.put(cert.getIssuerName(), new HashSet());
            }
            ((Set)certsToRemove.get(cert.getIssuerName())).add(new BigInteger(cert.getSerialNumber()));
        }
        boolean updated = false;
        LinkedHashSet<Certificate> currentCerts = new LinkedHashSet<Certificate>(this._storedCertificates);
        Iterator iter = currentCerts.iterator();
        while (iter.hasNext()) {
            X509Certificate x509Certificate;
            String issuerName;
            Certificate cert = (Certificate)iter.next();
            if (!(cert instanceof X509Certificate) || !certsToRemove.containsKey(issuerName = (x509Certificate = (X509Certificate)cert).getIssuerX500Principal().getName()) || !((Set)certsToRemove.get(issuerName)).contains(x509Certificate.getSerialNumber())) continue;
            iter.remove();
            updated = true;
        }
        if (updated) {
            this.setAttributes(Collections.singletonMap("storedCertificates", currentCerts));
        }
    }

    public static class CertificateDetailsImpl
    implements CertificateDetails,
    ManagedAttributeValue {
        private final X509Certificate _x509cert;

        public CertificateDetailsImpl(X509Certificate x509cert) {
            this._x509cert = x509cert;
        }

        @Override
        public String getSerialNumber() {
            return this._x509cert.getSerialNumber().toString();
        }

        @Override
        public int getVersion() {
            return this._x509cert.getVersion();
        }

        @Override
        public String getSignatureAlgorithm() {
            return this._x509cert.getSigAlgName();
        }

        @Override
        public String getIssuerName() {
            return this._x509cert.getIssuerX500Principal().getName();
        }

        @Override
        public String getSubjectName() {
            return this._x509cert.getSubjectX500Principal().getName();
        }

        @Override
        public List<String> getSubjectAltNames() {
            try {
                ArrayList<String> altNames = new ArrayList<String>();
                Collection<List<?>> altNameObjects = this._x509cert.getSubjectAlternativeNames();
                if (altNameObjects != null) {
                    for (List<?> entry : altNameObjects) {
                        int type = (Integer)entry.get(0);
                        if (type != 1 && type != 2) continue;
                        altNames.add(entry.get(1).toString().trim());
                    }
                }
                return altNames;
            }
            catch (CertificateParsingException e) {
                return Collections.emptyList();
            }
        }

        @Override
        public Date getValidFrom() {
            return this._x509cert.getNotBefore();
        }

        @Override
        public Date getValidUntil() {
            return this._x509cert.getNotAfter();
        }
    }
}

