/*
 * Decompiled with CFR 0.152.
 */
package org.apache.qpid.server.security;

import java.security.cert.Certificate;
import java.util.List;
import org.apache.qpid.server.model.DerivedAttribute;
import org.apache.qpid.server.model.ManagedAttribute;
import org.apache.qpid.server.model.ManagedObject;
import org.apache.qpid.server.model.ManagedOperation;
import org.apache.qpid.server.model.Param;
import org.apache.qpid.server.model.TrustStore;
import org.apache.qpid.server.security.CertificateDetails;

@ManagedObject(category=false, type="ManagedCertificateStore", description="Stores multiple PEM or DER encoded certificates in the broker configuration which the Trust Store will trust for secure connections (e.g., HTTPS or AMQPS)")
public interface ManagedPeerCertificateTrustStore<X extends ManagedPeerCertificateTrustStore<X>>
extends TrustStore<X> {
    public static final String TYPE_NAME = "ManagedCertificateStore";

    @Override
    @ManagedAttribute(defaultValue="true")
    public boolean isExposedAsMessageSource();

    @ManagedAttribute(oversize=true, defaultValue="[]", description="List of base64 encoded representations of the ASN.1 DER encoded certificates")
    public List<Certificate> getStoredCertificates();

    @ManagedOperation(description="Add a given certificate to the Trust Store", changesConfiguredObjectState=true)
    public void addCertificate(@Param(name="certificate", description="PEM or base64 encoded DER certificate to be added to the Trust Store") Certificate var1);

    @DerivedAttribute(description="List of details about the certificates like validity dates, SANs, issuer and subject names, etc.")
    public List<CertificateDetails> getCertificateDetails();

    @ManagedOperation(description="Remove given certificates from the Trust Store.", changesConfiguredObjectState=true)
    public void removeCertificates(@Param(name="certificates", description="List of certificate details to be removed. The details should take the form given by the certificateDetails attribute") List<CertificateDetails> var1);
}

