/*
 * Decompiled with CFR 0.152.
 */
package org.apache.qpid.server.security;

import com.google.common.util.concurrent.Futures;
import com.google.common.util.concurrent.ListenableFuture;
import java.io.File;
import java.io.IOException;
import java.net.MalformedURLException;
import java.net.URL;
import java.security.GeneralSecurityException;
import java.security.KeyStore;
import java.security.NoSuchAlgorithmException;
import java.security.UnrecoverableKeyException;
import java.security.cert.Certificate;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Enumeration;
import java.util.List;
import java.util.Map;
import java.util.Set;
import javax.net.ssl.TrustManager;
import javax.net.ssl.TrustManagerFactory;
import javax.net.ssl.X509TrustManager;
import org.apache.qpid.server.configuration.IllegalConfigurationException;
import org.apache.qpid.server.logging.EventLogger;
import org.apache.qpid.server.logging.messages.TrustStoreMessages;
import org.apache.qpid.server.model.AbstractConfiguredObject;
import org.apache.qpid.server.model.AuthenticationProvider;
import org.apache.qpid.server.model.Broker;
import org.apache.qpid.server.model.ConfiguredObject;
import org.apache.qpid.server.model.IntegrityViolationException;
import org.apache.qpid.server.model.ManagedAttributeField;
import org.apache.qpid.server.model.ManagedObjectFactoryConstructor;
import org.apache.qpid.server.model.Port;
import org.apache.qpid.server.model.State;
import org.apache.qpid.server.model.StateTransition;
import org.apache.qpid.server.model.TrustStore;
import org.apache.qpid.server.model.VirtualHostNode;
import org.apache.qpid.server.security.FileTrustStore;
import org.apache.qpid.server.security.auth.manager.SimpleLDAPAuthenticationManager;
import org.apache.qpid.server.util.urlstreamhandler.data.Handler;
import org.apache.qpid.transport.network.security.ssl.QpidMultipleTrustManager;
import org.apache.qpid.transport.network.security.ssl.QpidPeersOnlyTrustManager;
import org.apache.qpid.transport.network.security.ssl.SSLUtil;

public class FileTrustStoreImpl
extends AbstractConfiguredObject<FileTrustStoreImpl>
implements FileTrustStore<FileTrustStoreImpl> {
    private final Broker<?> _broker;
    private final EventLogger _eventLogger;
    @ManagedAttributeField
    private String _trustStoreType;
    @ManagedAttributeField
    private String _trustManagerFactoryAlgorithm;
    @ManagedAttributeField(afterSet="postSetStoreUrl")
    private String _storeUrl;
    private String _path;
    @ManagedAttributeField
    private boolean _peersOnly;
    @ManagedAttributeField
    private String _password;
    @ManagedAttributeField
    private boolean _exposedAsMessageSource;
    @ManagedAttributeField
    private List<VirtualHostNode<?>> _includedVirtualHostNodeMessageSources;
    @ManagedAttributeField
    private List<VirtualHostNode<?>> _excludedVirtualHostNodeMessageSources;

    @ManagedObjectFactoryConstructor
    public FileTrustStoreImpl(Map<String, Object> attributes, Broker<?> broker) {
        super(FileTrustStoreImpl.parentsMap(broker), attributes);
        this._broker = broker;
        this._eventLogger = this._broker.getEventLogger();
        this._eventLogger.message(TrustStoreMessages.CREATE(this.getName()));
    }

    @Override
    public void onValidate() {
        super.onValidate();
        FileTrustStoreImpl.validateTrustStore(this);
        if (!this.isDurable()) {
            throw new IllegalArgumentException(this.getClass().getSimpleName() + " must be durable");
        }
    }

    @StateTransition(currentState={State.ACTIVE, State.ERRORED}, desiredState=State.DELETED)
    protected ListenableFuture<Void> doDelete() {
        String storeName = this.getName();
        ArrayList ports = new ArrayList(this._broker.getPorts());
        for (Port port : ports) {
            Collection<TrustStore> collection = port.getTrustStores();
            if (collection == null) continue;
            for (TrustStore store : collection) {
                if (!storeName.equals(store.getAttribute("name"))) continue;
                throw new IntegrityViolationException("Trust store '" + storeName + "' can't be deleted as it is in use by a port: " + port.getName());
            }
        }
        ArrayList authenticationProviders = new ArrayList(this._broker.getAuthenticationProviders());
        for (AuthenticationProvider authenticationProvider : authenticationProviders) {
            SimpleLDAPAuthenticationManager simpleLdap;
            if (!(authenticationProvider instanceof SimpleLDAPAuthenticationManager) || (simpleLdap = (SimpleLDAPAuthenticationManager)authenticationProvider).getTrustStore() != this) continue;
            throw new IntegrityViolationException("Trust store '" + storeName + "' can't be deleted as it is in use by an authentication manager: " + authenticationProvider.getName());
        }
        this.deleted();
        this.setState(State.DELETED);
        this._eventLogger.message(TrustStoreMessages.DELETE(this.getName()));
        return Futures.immediateFuture(null);
    }

    @StateTransition(currentState={State.UNINITIALIZED, State.ERRORED}, desiredState=State.ACTIVE)
    protected ListenableFuture<Void> doActivate() {
        this.setState(State.ACTIVE);
        return Futures.immediateFuture(null);
    }

    @Override
    protected void validateChange(ConfiguredObject<?> proxyForValidation, Set<String> changedAttributes) {
        super.validateChange(proxyForValidation, changedAttributes);
        FileTrustStore updated = (FileTrustStore)proxyForValidation;
        if (changedAttributes.contains("desiredState") && updated.getDesiredState() == State.DELETED) {
            return;
        }
        if (changedAttributes.contains("name") && !this.getName().equals(updated.getName())) {
            throw new IllegalConfigurationException("Changing the trust store name is not allowed");
        }
        FileTrustStoreImpl.validateTrustStore(updated);
    }

    private static void validateTrustStore(FileTrustStore trustStore) {
        try {
            URL trustStoreUrl = FileTrustStoreImpl.getUrlFromString(trustStore.getStoreUrl());
            SSLUtil.getInitializedKeyStore((URL)trustStoreUrl, (String)trustStore.getPassword(), (String)trustStore.getTrustStoreType());
        }
        catch (Exception e) {
            String message = e instanceof IOException && e.getCause() != null && e.getCause() instanceof UnrecoverableKeyException ? "Check trust store password. Cannot instantiate trust store from '" + trustStore.getStoreUrl() + "'." : "Cannot instantiate trust store from '" + trustStore.getStoreUrl() + "'.";
            throw new IllegalConfigurationException(message, e);
        }
        try {
            TrustManagerFactory.getInstance(trustStore.getTrustManagerFactoryAlgorithm());
        }
        catch (NoSuchAlgorithmException e) {
            throw new IllegalConfigurationException("Unknown trustManagerFactoryAlgorithm: " + trustStore.getTrustManagerFactoryAlgorithm());
        }
    }

    @Override
    public String getStoreUrl() {
        return this._storeUrl;
    }

    @Override
    public String getPath() {
        return this._path;
    }

    @Override
    public String getTrustManagerFactoryAlgorithm() {
        return this._trustManagerFactoryAlgorithm;
    }

    @Override
    public String getTrustStoreType() {
        return this._trustStoreType;
    }

    @Override
    public boolean isPeersOnly() {
        return this._peersOnly;
    }

    @Override
    public String getPassword() {
        return this._password;
    }

    @Override
    public void setPassword(String password) {
        this._password = password;
    }

    @Override
    public TrustManager[] getTrustManagers() throws GeneralSecurityException {
        String trustStorePassword = this.getPassword();
        String trustStoreType = this._trustStoreType;
        String trustManagerFactoryAlgorithm = this._trustManagerFactoryAlgorithm;
        try {
            TrustManager[] delegateManagers;
            URL trustStoreUrl = FileTrustStoreImpl.getUrlFromString(this._storeUrl);
            KeyStore ts = SSLUtil.getInitializedKeyStore((URL)trustStoreUrl, (String)trustStorePassword, (String)trustStoreType);
            TrustManagerFactory tmf = TrustManagerFactory.getInstance(trustManagerFactoryAlgorithm);
            tmf.init(ts);
            ArrayList<TrustManager> trustManagersCol = new ArrayList<TrustManager>();
            QpidMultipleTrustManager mulTrustManager = new QpidMultipleTrustManager();
            for (TrustManager tm : delegateManagers = tmf.getTrustManagers()) {
                if (tm instanceof X509TrustManager) {
                    if (this._peersOnly) {
                        mulTrustManager.addTrustManager((X509TrustManager)new QpidPeersOnlyTrustManager(ts, (X509TrustManager)tm));
                        continue;
                    }
                    mulTrustManager.addTrustManager((X509TrustManager)tm);
                    continue;
                }
                trustManagersCol.add(tm);
            }
            if (!mulTrustManager.isEmpty()) {
                trustManagersCol.add((TrustManager)mulTrustManager);
            }
            if (trustManagersCol.isEmpty()) {
                throw new IllegalStateException("Truststore " + this + " defines no trust managers");
            }
            return trustManagersCol.toArray(new TrustManager[trustManagersCol.size()]);
        }
        catch (IOException e) {
            throw new GeneralSecurityException(e);
        }
    }

    @Override
    public Certificate[] getCertificates() throws GeneralSecurityException {
        String trustStorePassword = this.getPassword();
        String trustStoreType = this._trustStoreType;
        try {
            URL trustStoreUrl = FileTrustStoreImpl.getUrlFromString(this._storeUrl);
            KeyStore ts = SSLUtil.getInitializedKeyStore((URL)trustStoreUrl, (String)trustStorePassword, (String)trustStoreType);
            ArrayList<Certificate> certificates = new ArrayList<Certificate>();
            Enumeration<String> aliases = ts.aliases();
            while (aliases.hasMoreElements()) {
                certificates.add(ts.getCertificate(aliases.nextElement()));
            }
            return certificates.toArray(new Certificate[certificates.size()]);
        }
        catch (IOException e) {
            throw new GeneralSecurityException(e);
        }
    }

    private static URL getUrlFromString(String urlString) throws MalformedURLException {
        URL url;
        try {
            url = new URL(urlString);
        }
        catch (MalformedURLException e) {
            File file = new File(urlString);
            url = file.toURI().toURL();
        }
        return url;
    }

    private void postSetStoreUrl() {
        this._path = this._storeUrl != null && !this._storeUrl.startsWith("data:") ? this._storeUrl : null;
    }

    @Override
    public boolean isExposedAsMessageSource() {
        return this._exposedAsMessageSource;
    }

    @Override
    public List<VirtualHostNode<?>> getIncludedVirtualHostNodeMessageSources() {
        return this._includedVirtualHostNodeMessageSources;
    }

    @Override
    public List<VirtualHostNode<?>> getExcludedVirtualHostNodeMessageSources() {
        return this._excludedVirtualHostNodeMessageSources;
    }

    static {
        Handler.register();
    }
}

