/*
 * Decompiled with CFR 0.152.
 */
package org.apache.qpid.server.security;

import java.security.KeyStore;
import javax.net.ssl.KeyManagerFactory;
import org.apache.qpid.server.model.DerivedAttribute;
import org.apache.qpid.server.model.ManagedAttribute;
import org.apache.qpid.server.model.ManagedContextDefault;
import org.apache.qpid.server.model.ManagedObject;
import org.apache.qpid.server.model.TrustStore;

@ManagedObject(category=false, type="FileTrustStore")
public interface FileTrustStore<X extends FileTrustStore<X>>
extends TrustStore<X> {
    public static final String TRUST_MANAGER_FACTORY_ALGORITHM = "trustManagerFactoryAlgorithm";
    public static final String PEERS_ONLY = "peersOnly";
    public static final String TRUST_STORE_TYPE = "trustStoreType";
    public static final String PASSWORD = "password";
    public static final String STORE_URL = "storeUrl";
    @ManagedContextDefault(name="trustStoreFile.trustStoreType")
    public static final String DEFAULT_TRUSTSTORE_TYPE = KeyStore.getDefaultType();
    @ManagedContextDefault(name="trustStoreFile.trustManagerFactoryAlgorithm")
    public static final String DEFAULT_TRUST_MANAGER_FACTORY_ALGORITHM = KeyManagerFactory.getDefaultAlgorithm();

    @Override
    @ManagedAttribute(defaultValue="${this:storeUrl}")
    public String getDescription();

    @ManagedAttribute(mandatory=true, oversize=true, oversizedAltText="Value is too long to display")
    public String getStoreUrl();

    @DerivedAttribute
    public String getPath();

    @ManagedAttribute(defaultValue="${trustStoreFile.trustManagerFactoryAlgorithm}")
    public String getTrustManagerFactoryAlgorithm();

    @ManagedAttribute(defaultValue="${trustStoreFile.trustStoreType}")
    public String getTrustStoreType();

    @ManagedAttribute(defaultValue="false")
    public boolean isPeersOnly();

    @ManagedAttribute(secure=true, mandatory=true)
    public String getPassword();

    public void setPassword(String var1);
}

