/*
 * Decompiled with CFR 0.152.
 */
package org.apache.qpid.server.security;

import com.google.common.util.concurrent.Futures;
import com.google.common.util.concurrent.ListenableFuture;
import java.io.File;
import java.io.IOException;
import java.net.MalformedURLException;
import java.net.URL;
import java.security.GeneralSecurityException;
import java.security.KeyStore;
import java.security.KeyStoreException;
import java.security.NoSuchAlgorithmException;
import java.security.UnrecoverableKeyException;
import java.security.cert.Certificate;
import java.util.Collections;
import java.util.Date;
import java.util.Map;
import java.util.Set;
import javax.net.ssl.KeyManager;
import javax.net.ssl.KeyManagerFactory;
import javax.net.ssl.X509KeyManager;
import org.apache.qpid.server.configuration.IllegalConfigurationException;
import org.apache.qpid.server.model.Broker;
import org.apache.qpid.server.model.ConfiguredObject;
import org.apache.qpid.server.model.ManagedAttributeField;
import org.apache.qpid.server.model.ManagedObject;
import org.apache.qpid.server.model.ManagedObjectFactoryConstructor;
import org.apache.qpid.server.model.State;
import org.apache.qpid.server.model.StateTransition;
import org.apache.qpid.server.security.AbstractKeyStore;
import org.apache.qpid.server.security.FileKeyStore;
import org.apache.qpid.server.util.ServerScopedRuntimeException;
import org.apache.qpid.server.util.urlstreamhandler.data.Handler;
import org.apache.qpid.transport.network.security.ssl.QpidClientX509KeyManager;
import org.apache.qpid.transport.network.security.ssl.SSLUtil;

@ManagedObject(category=false)
public class FileKeyStoreImpl
extends AbstractKeyStore<FileKeyStoreImpl>
implements FileKeyStore<FileKeyStoreImpl> {
    @ManagedAttributeField
    private String _type;
    @ManagedAttributeField
    private String _keyStoreType;
    @ManagedAttributeField
    private String _certificateAlias;
    @ManagedAttributeField
    private String _keyManagerFactoryAlgorithm;
    @ManagedAttributeField(afterSet="postSetStoreUrl")
    private String _storeUrl;
    private String _path;
    @ManagedAttributeField
    private String _password;

    @ManagedObjectFactoryConstructor
    public FileKeyStoreImpl(Map<String, Object> attributes, Broker<?> broker) {
        super(attributes, broker);
    }

    @Override
    public void onValidate() {
        super.onValidate();
        this.validateKeyStoreAttributes(this);
    }

    @StateTransition(currentState={State.ACTIVE, State.ERRORED}, desiredState=State.DELETED)
    protected ListenableFuture<Void> doDelete() {
        return this.deleteIfNotInUse();
    }

    @StateTransition(currentState={State.UNINITIALIZED, State.ERRORED}, desiredState=State.ACTIVE)
    protected ListenableFuture<Void> doActivate() {
        this.initializeExpiryChecking();
        this.setState(State.ACTIVE);
        return Futures.immediateFuture(null);
    }

    @Override
    protected void validateChange(ConfiguredObject<?> proxyForValidation, Set<String> changedAttributes) {
        super.validateChange(proxyForValidation, changedAttributes);
        FileKeyStore changedStore = (FileKeyStore)proxyForValidation;
        if (changedAttributes.contains("desiredState") && changedStore.getDesiredState() == State.DELETED) {
            return;
        }
        if (changedAttributes.contains("name") && !this.getName().equals(changedStore.getName())) {
            throw new IllegalConfigurationException("Changing the key store name is not allowed");
        }
        this.validateKeyStoreAttributes(changedStore);
    }

    private void validateKeyStoreAttributes(FileKeyStore<?> fileKeyStore) {
        KeyStore keyStore;
        try {
            URL url = FileKeyStoreImpl.getUrlFromString(fileKeyStore.getStoreUrl());
            String password = fileKeyStore.getPassword();
            String keyStoreType = fileKeyStore.getKeyStoreType();
            keyStore = SSLUtil.getInitializedKeyStore((URL)url, (String)password, (String)keyStoreType);
        }
        catch (Exception e) {
            String message = e instanceof IOException && e.getCause() != null && e.getCause() instanceof UnrecoverableKeyException ? "Check key store password. Cannot instantiate key store from '" + fileKeyStore.getStoreUrl() + "'." : "Cannot instantiate key store from '" + fileKeyStore.getStoreUrl() + "'.";
            throw new IllegalConfigurationException(message, e);
        }
        if (fileKeyStore.getCertificateAlias() != null) {
            Certificate cert;
            try {
                cert = keyStore.getCertificate(fileKeyStore.getCertificateAlias());
            }
            catch (KeyStoreException e) {
                throw new ServerScopedRuntimeException("Key store has not been initialized", e);
            }
            if (cert == null) {
                throw new IllegalConfigurationException("Cannot find a certificate with alias '" + fileKeyStore.getCertificateAlias() + "' in key store : " + fileKeyStore.getStoreUrl());
            }
        }
        try {
            KeyManagerFactory.getInstance(fileKeyStore.getKeyManagerFactoryAlgorithm());
        }
        catch (NoSuchAlgorithmException e) {
            throw new IllegalConfigurationException("Unknown keyManagerFactoryAlgorithm: " + fileKeyStore.getKeyManagerFactoryAlgorithm());
        }
        if (!fileKeyStore.isDurable()) {
            throw new IllegalArgumentException(this.getClass().getSimpleName() + " must be durable");
        }
        this.checkCertificateExpiry();
    }

    @Override
    public String getStoreUrl() {
        return this._storeUrl;
    }

    @Override
    public String getPath() {
        return this._path;
    }

    @Override
    public String getCertificateAlias() {
        return this._certificateAlias;
    }

    @Override
    public String getKeyManagerFactoryAlgorithm() {
        return this._keyManagerFactoryAlgorithm;
    }

    @Override
    public String getKeyStoreType() {
        return this._keyStoreType;
    }

    @Override
    public String getPassword() {
        return this._password;
    }

    public void setPassword(String password) {
        this._password = password;
    }

    @Override
    public KeyManager[] getKeyManagers() throws GeneralSecurityException {
        try {
            URL url = FileKeyStoreImpl.getUrlFromString(this._storeUrl);
            if (this._certificateAlias != null) {
                return new KeyManager[]{new QpidClientX509KeyManager(this._certificateAlias, url, this._keyStoreType, this.getPassword(), this._keyManagerFactoryAlgorithm)};
            }
            KeyStore ks = SSLUtil.getInitializedKeyStore((URL)url, (String)this.getPassword(), (String)this._keyStoreType);
            char[] keyStoreCharPassword = this.getPassword() == null ? null : this.getPassword().toCharArray();
            KeyManagerFactory kmf = KeyManagerFactory.getInstance(this._keyManagerFactoryAlgorithm);
            kmf.init(ks, keyStoreCharPassword);
            return kmf.getKeyManagers();
        }
        catch (IOException e) {
            throw new GeneralSecurityException(e);
        }
    }

    private static URL getUrlFromString(String urlString) throws MalformedURLException {
        URL url;
        try {
            url = new URL(urlString);
        }
        catch (MalformedURLException e) {
            File file = new File(urlString);
            url = file.toURI().toURL();
        }
        return url;
    }

    private void postSetStoreUrl() {
        this._path = this._storeUrl != null && !this._storeUrl.startsWith("data:") ? this._storeUrl : null;
    }

    @Override
    protected void checkCertificateExpiry() {
        int expiryWarning = this.getCertificateExpiryWarnPeriod();
        if (expiryWarning > 0) {
            long currentTime = System.currentTimeMillis();
            Date expiryTestDate = new Date(currentTime + 86400000L * (long)expiryWarning);
            try {
                URL url = FileKeyStoreImpl.getUrlFromString(this._storeUrl);
                KeyStore ks = SSLUtil.getInitializedKeyStore((URL)url, (String)this.getPassword(), (String)this._keyStoreType);
                char[] keyStoreCharPassword = this.getPassword() == null ? null : this.getPassword().toCharArray();
                KeyManagerFactory kmf = KeyManagerFactory.getInstance(this._keyManagerFactoryAlgorithm);
                kmf.init(ks, keyStoreCharPassword);
                for (KeyManager km : kmf.getKeyManagers()) {
                    if (!(km instanceof X509KeyManager)) continue;
                    X509KeyManager x509KeyManager = (X509KeyManager)km;
                    for (String alias : Collections.list(ks.aliases())) {
                        this.checkCertificatesExpiry(currentTime, expiryTestDate, x509KeyManager.getCertificateChain(alias));
                    }
                }
            }
            catch (IOException | GeneralSecurityException exception) {
                // empty catch block
            }
        }
    }

    static {
        Handler.register();
    }
}

