/*
 * Decompiled with CFR 0.152.
 */
package org.apache.qpid.server.security;

import java.security.KeyStore;
import javax.net.ssl.KeyManagerFactory;
import org.apache.qpid.server.model.DerivedAttribute;
import org.apache.qpid.server.model.ManagedAttribute;
import org.apache.qpid.server.model.ManagedContextDefault;
import org.apache.qpid.server.model.ManagedObject;

@ManagedObject(category=false, type="FileKeyStore")
public interface FileKeyStore<X extends FileKeyStore<X>>
extends org.apache.qpid.server.model.KeyStore<X> {
    public static final String KEY_MANAGER_FACTORY_ALGORITHM = "keyManagerFactoryAlgorithm";
    public static final String CERTIFICATE_ALIAS = "certificateAlias";
    public static final String KEY_STORE_TYPE = "keyStoreType";
    public static final String PASSWORD = "password";
    public static final String STORE_URL = "storeUrl";
    @ManagedContextDefault(name="keyStoreFile.keyStoreType")
    public static final String DEFAULT_KEYSTORE_TYPE = KeyStore.getDefaultType();
    @ManagedContextDefault(name="keyStoreFile.keyManagerFactoryAlgorithm")
    public static final String DEFAULT_KEY_MANAGER_FACTORY_ALGORITHM = KeyManagerFactory.getDefaultAlgorithm();

    @Override
    @ManagedAttribute(defaultValue="${this:path}")
    public String getDescription();

    @ManagedAttribute(mandatory=true, secure=true, oversize=true, oversizedAltText="Value is too long to display", secureValueFilter="^data\\:.*")
    public String getStoreUrl();

    @DerivedAttribute
    public String getPath();

    @ManagedAttribute
    public String getCertificateAlias();

    @ManagedAttribute(defaultValue="${keyStoreFile.keyManagerFactoryAlgorithm}")
    public String getKeyManagerFactoryAlgorithm();

    @ManagedAttribute(defaultValue="${keyStoreFile.keyStoreType}")
    public String getKeyStoreType();

    @ManagedAttribute(secure=true, mandatory=true)
    public String getPassword();
}

