/*
 * Decompiled with CFR 0.152.
 */
package org.apache.qpid.server.security;

import java.util.Collections;
import java.util.HashSet;
import java.util.Set;
import org.apache.qpid.server.model.ConfiguredObject;
import org.apache.qpid.server.plugin.ConfiguredObjectRegistration;
import org.apache.qpid.server.plugin.PluggableService;
import org.apache.qpid.server.security.AllowAllAccessControlProvider;
import org.apache.qpid.server.security.AutoGeneratedSelfSignedKeyStore;
import org.apache.qpid.server.security.FileKeyStore;
import org.apache.qpid.server.security.FileKeyStoreImpl;
import org.apache.qpid.server.security.FileTrustStore;
import org.apache.qpid.server.security.ManagedPeerCertificateTrustStore;
import org.apache.qpid.server.security.ManagedPeerCertificateTrustStoreImpl;
import org.apache.qpid.server.security.NonJavaKeyStore;
import org.apache.qpid.server.security.NonJavaKeyStoreImpl;
import org.apache.qpid.server.security.NonJavaTrustStore;
import org.apache.qpid.server.security.NonJavaTrustStoreImpl;
import org.apache.qpid.server.security.SiteSpecificTrustStore;
import org.apache.qpid.server.security.SiteSpecificTrustStoreImpl;

@PluggableService
public class ConfiguredObjectRegistrationImpl
implements ConfiguredObjectRegistration {
    private final Set<Class<? extends ConfiguredObject>> _implementations;

    public ConfiguredObjectRegistrationImpl() {
        HashSet<Class<ManagedPeerCertificateTrustStore>> implementations = new HashSet<Class<ManagedPeerCertificateTrustStore>>();
        implementations.add(SiteSpecificTrustStoreImpl.class);
        implementations.add(FileKeyStoreImpl.class);
        if (!Boolean.getBoolean("qpid.type.disabled:truststore.SiteSpecificTrustStore")) {
            implementations.add(SiteSpecificTrustStore.class);
        }
        if (!Boolean.getBoolean("qpid.type.disabled:keystore.AutoGeneratedSelfSigned")) {
            implementations.add(AutoGeneratedSelfSignedKeyStore.class);
        }
        if (!Boolean.getBoolean("qpid.type.disabled:keystore.NonJavaKeyStore")) {
            implementations.add(NonJavaKeyStore.class);
        }
        if (!Boolean.getBoolean("qpid.type.disabled:truststore.NonJavaTrustStore")) {
            implementations.add(NonJavaTrustStore.class);
        }
        if (!Boolean.getBoolean("qpid.type.disabled:accesscontrolprovider.AllowAll")) {
            implementations.add(AllowAllAccessControlProvider.class);
        }
        if (!Boolean.getBoolean("qpid.type.disabled:truststore.FileTrustStore")) {
            implementations.add(FileTrustStore.class);
        }
        if (!Boolean.getBoolean("qpid.type.disabled:keystore.FileKeyStore")) {
            implementations.add(FileKeyStore.class);
        }
        implementations.add(NonJavaTrustStoreImpl.class);
        implementations.add(NonJavaKeyStoreImpl.class);
        implementations.add(ManagedPeerCertificateTrustStoreImpl.class);
        if (!Boolean.getBoolean("qpid.type.disabled:truststore.ManagedCertificateStore")) {
            implementations.add(ManagedPeerCertificateTrustStore.class);
        }
        this._implementations = Collections.unmodifiableSet(implementations);
    }

    @Override
    public String getType() {
        return "org.apache.qpid.server.security";
    }

    public Set<Class<? extends ConfiguredObject>> getConfiguredObjectClasses() {
        return this._implementations;
    }
}

