/*
 * Decompiled with CFR 0.152.
 */
package org.apache.qpid.server.security;

import java.security.AccessController;
import java.util.Collections;
import java.util.List;
import java.util.Map;
import java.util.concurrent.CopyOnWriteArrayList;
import java.util.concurrent.atomic.AtomicReference;
import javax.security.auth.Subject;
import org.apache.qpid.server.model.PermissionedObject;
import org.apache.qpid.server.security.AccessControl;
import org.apache.qpid.server.security.CompoundSecurityToken;
import org.apache.qpid.server.security.Result;
import org.apache.qpid.server.security.SecurityToken;
import org.apache.qpid.server.security.access.Operation;

public class CompoundAccessControl
implements AccessControl<CompoundSecurityToken> {
    private final AtomicReference<List<AccessControl<?>>> _underlyingControls = new AtomicReference();
    private final Result _defaultResult;

    public CompoundAccessControl(List<AccessControl<?>> underlying, Result defaultResult) {
        this.setAccessControls(underlying);
        this._defaultResult = defaultResult;
    }

    public void setAccessControls(List<AccessControl<?>> underlying) {
        this._underlyingControls.set(new CopyOnWriteArrayList(underlying));
    }

    @Override
    public Result getDefault() {
        List<AccessControl<?>> underlying = this._underlyingControls.get();
        for (AccessControl<?> control : underlying) {
            Result result = control.getDefault();
            if (!result.isFinal()) continue;
            return result;
        }
        return this._defaultResult;
    }

    @Override
    public CompoundSecurityToken newToken() {
        return new CompoundSecurityToken(this._underlyingControls.get(), Subject.getSubject(AccessController.getContext()));
    }

    @Override
    public CompoundSecurityToken newToken(Subject subject) {
        return new CompoundSecurityToken(this._underlyingControls.get(), subject);
    }

    @Override
    public Result authorise(CompoundSecurityToken token, Operation operation, PermissionedObject configuredObject) {
        return this.authorise(token, operation, configuredObject, Collections.emptyMap());
    }

    @Override
    public Result authorise(CompoundSecurityToken token, Operation operation, PermissionedObject configuredObject, Map<String, Object> arguments) {
        List<AccessControl<?>> underlying = this._underlyingControls.get();
        Map<AccessControl<?>, SecurityToken> compoundToken = token == null ? null : token.getCompoundToken(underlying);
        for (AccessControl<?> control : underlying) {
            SecurityToken underlyingToken;
            Result result = control.authorise(underlyingToken = compoundToken == null ? null : compoundToken.get(control), operation, configuredObject, arguments);
            if (!result.isFinal()) continue;
            return result;
        }
        return Result.DEFER;
    }
}

