/*
 * Decompiled with CFR 0.152.
 */
package org.apache.qpid.server.security;

import com.google.common.util.concurrent.Futures;
import com.google.common.util.concurrent.ListenableFuture;
import java.io.ByteArrayInputStream;
import java.io.IOException;
import java.io.OutputStream;
import java.io.OutputStreamWriter;
import java.io.Writer;
import java.lang.reflect.Constructor;
import java.lang.reflect.InvocationTargetException;
import java.lang.reflect.Method;
import java.net.InetAddress;
import java.net.InterfaceAddress;
import java.net.NetworkInterface;
import java.nio.ByteBuffer;
import java.nio.charset.StandardCharsets;
import java.security.GeneralSecurityException;
import java.security.KeyStore;
import java.security.KeyStoreException;
import java.security.NoSuchAlgorithmException;
import java.security.PrivateKey;
import java.security.SecureRandom;
import java.security.cert.Certificate;
import java.security.cert.CertificateEncodingException;
import java.security.cert.CertificateException;
import java.security.cert.CertificateFactory;
import java.security.cert.X509Certificate;
import java.security.spec.InvalidKeySpecException;
import java.util.ArrayList;
import java.util.Calendar;
import java.util.Collections;
import java.util.Date;
import java.util.HashSet;
import java.util.Map;
import javax.net.ssl.KeyManager;
import javax.net.ssl.KeyManagerFactory;
import javax.xml.bind.DatatypeConverter;
import org.apache.qpid.server.configuration.IllegalConfigurationException;
import org.apache.qpid.server.logging.EventLogger;
import org.apache.qpid.server.logging.messages.KeyStoreMessages;
import org.apache.qpid.server.model.AbstractConfiguredObject;
import org.apache.qpid.server.model.Broker;
import org.apache.qpid.server.model.Content;
import org.apache.qpid.server.model.CustomRestHeaders;
import org.apache.qpid.server.model.IntegrityViolationException;
import org.apache.qpid.server.model.ManagedAttributeField;
import org.apache.qpid.server.model.ManagedObjectFactoryConstructor;
import org.apache.qpid.server.model.Port;
import org.apache.qpid.server.model.RestContentHeader;
import org.apache.qpid.server.model.State;
import org.apache.qpid.server.model.StateTransition;
import org.apache.qpid.server.security.AutoGeneratedSelfSignedKeyStore;
import org.apache.qpid.transport.network.security.ssl.SSLUtil;
import org.apache.qpid.util.Strings;

public class AutoGeneratedSelfSignedKeyStoreImpl
extends AbstractConfiguredObject<AutoGeneratedSelfSignedKeyStoreImpl>
implements AutoGeneratedSelfSignedKeyStore<AutoGeneratedSelfSignedKeyStoreImpl> {
    private static final SecureRandom RANDOM = new SecureRandom();
    private static Constructor<?> CONSTRUCTOR;
    private static Method GENERATE_METHOD;
    private static Method GET_PRIVATE_KEY_METHOD;
    private static Method GET_SELF_CERTIFICATE_METHOD;
    private static Constructor<?> X500_NAME_CONSTRUCTOR;
    private static Constructor<?> DNS_NAME_CONSTRUCTOR;
    private static Constructor<?> IP_ADDR_NAME_CONSTRUCTOR;
    private static Constructor<?> GENERAL_NAMES_CONSTRUCTOR;
    private static Constructor<?> GENERAL_NAME_CONSTRUCTOR;
    private static Method ADD_NAME_TO_NAMES_METHOD;
    private static Constructor<?> ALT_NAMES_CONSTRUCTOR;
    private static Constructor<?> CERTIFICATE_EXTENSIONS_CONSTRUCTOR;
    private static Method SET_EXTENSION_METHOD;
    private static Method EXTENSION_GET_NAME_METHOD;
    private final Broker<?> _broker;
    private final EventLogger _eventLogger;
    @ManagedAttributeField
    private String _keyAlgorithm;
    @ManagedAttributeField
    private String _signatureAlgorithm;
    @ManagedAttributeField
    private int _keyLength;
    @ManagedAttributeField
    private int _durationInMonths;
    private PrivateKey _privateKey;
    private X509Certificate _certificate;
    private KeyManager[] _keyManagers;
    private boolean _generated;
    private boolean _created;

    @ManagedObjectFactoryConstructor(conditionallyAvailable=true)
    public AutoGeneratedSelfSignedKeyStoreImpl(Map<String, Object> attributes, Broker<?> broker) {
        super(AutoGeneratedSelfSignedKeyStoreImpl.parentsMap(broker), attributes);
        this._broker = broker;
        this._eventLogger = this._broker.getEventLogger();
        this._eventLogger.message(KeyStoreMessages.CREATE(this.getName()));
    }

    @Override
    public KeyManager[] getKeyManagers() throws GeneralSecurityException {
        return this._keyManagers;
    }

    @Override
    public String getKeyAlgorithm() {
        return this._keyAlgorithm;
    }

    @Override
    public String getSignatureAlgorithm() {
        return this._signatureAlgorithm;
    }

    @Override
    public int getKeyLength() {
        return this._keyLength;
    }

    @Override
    public int getDurationInMonths() {
        return this._durationInMonths;
    }

    @Override
    public String getEncodedCertificate() {
        try {
            return DatatypeConverter.printBase64Binary((byte[])this._certificate.getEncoded());
        }
        catch (CertificateEncodingException e) {
            throw new IllegalConfigurationException("Cannot encode certificate", e);
        }
    }

    @Override
    public String getEncodedPrivateKey() {
        return DatatypeConverter.printBase64Binary((byte[])this._privateKey.getEncoded());
    }

    @Override
    protected void postResolve() {
        super.postResolve();
        if (this.getActualAttributes().containsKey("encodedPrivateKey") && this.getActualAttributes().containsKey("encodedCertificate")) {
            this.loadPrivateKeyAndCertificate();
        } else {
            this.generatePrivateKeyAndCertificate();
        }
        this.generateKeyManagers();
    }

    private void loadPrivateKeyAndCertificate() {
        byte[] privateKeyEncoded = Strings.decodeBase64((String)((String)this.getActualAttributes().get("encodedPrivateKey")));
        byte[] certificateEncoded = Strings.decodeBase64((String)((String)this.getActualAttributes().get("encodedCertificate")));
        try (ByteArrayInputStream input = new ByteArrayInputStream(certificateEncoded);){
            CertificateFactory cf = CertificateFactory.getInstance("X.509");
            this._certificate = (X509Certificate)cf.generateCertificate(input);
        }
        catch (IOException | CertificateException e) {
            throw new IllegalConfigurationException("Could not decode certificate", e);
        }
        try {
            this._privateKey = SSLUtil.readPrivateKey((byte[])privateKeyEncoded, (String)this._keyAlgorithm);
        }
        catch (NoSuchAlgorithmException | InvalidKeySpecException e) {
            throw new IllegalConfigurationException("Could not decode private key", e);
        }
    }

    @Override
    protected void onCreate() {
        super.onCreate();
        this._created = true;
    }

    @StateTransition(currentState={State.UNINITIALIZED, State.STOPPED, State.ERRORED}, desiredState=State.ACTIVE)
    protected ListenableFuture<Void> activate() {
        if (!this._created) {
            this.saveDerivedAttributesIfNecessary();
        }
        this.setState(State.ACTIVE);
        return Futures.immediateFuture(null);
    }

    private void saveDerivedAttributesIfNecessary() {
        if (this._generated) {
            String encodedCertificate = this.getEncodedCertificate();
            this.attributeSet("encodedCertificate", encodedCertificate, encodedCertificate);
            String encodedPrivateKey = this.getEncodedPrivateKey();
            this.attributeSet("encodedPrivateKey", encodedPrivateKey, encodedPrivateKey);
            this._generated = false;
        }
    }

    @StateTransition(currentState={State.UNINITIALIZED, State.ACTIVE, State.ERRORED}, desiredState=State.DELETED)
    protected ListenableFuture<Void> doDelete() {
        String storeName = this.getName();
        ArrayList ports = new ArrayList(this._broker.getPorts());
        for (Port port : ports) {
            if (port.getKeyStore() != this) continue;
            throw new IntegrityViolationException("Key store '" + storeName + "' can't be deleted as it is in use by a port:" + port.getName());
        }
        this.deleted();
        this.setState(State.DELETED);
        this._eventLogger.message(KeyStoreMessages.DELETE(this.getName()));
        return Futures.immediateFuture(null);
    }

    private void generatePrivateKeyAndCertificate() {
        try {
            Object certAndKeyGen = CONSTRUCTOR.newInstance(this._keyAlgorithm, this._signatureAlgorithm);
            GENERATE_METHOD.invoke(certAndKeyGen, this._keyLength);
            this._privateKey = (PrivateKey)GET_PRIVATE_KEY_METHOD.invoke(certAndKeyGen, new Object[0]);
            Object generalNames = GENERAL_NAMES_CONSTRUCTOR.newInstance(new Object[0]);
            HashSet<InetAddress> addresses = new HashSet<InetAddress>();
            for (NetworkInterface networkInterface : Collections.list(NetworkInterface.getNetworkInterfaces())) {
                for (InterfaceAddress inetAddress : networkInterface.getInterfaceAddresses()) {
                    addresses.add(inetAddress.getAddress());
                }
            }
            HashSet<String> dnsNames = new HashSet<String>();
            for (InetAddress address : addresses) {
                String canonicalHostName;
                String hostName = address.getHostName();
                if (hostName != null) {
                    dnsNames.add(hostName);
                }
                if ((canonicalHostName = address.getCanonicalHostName()) == null) continue;
                dnsNames.add(canonicalHostName);
            }
            for (String dnsName : dnsNames) {
                if (!dnsName.matches("[\\w&&[^\\d]][\\w\\d.-]*")) continue;
                ADD_NAME_TO_NAMES_METHOD.invoke(generalNames, GENERAL_NAME_CONSTRUCTOR.newInstance(DNS_NAME_CONSTRUCTOR.newInstance(dnsName)));
            }
            for (InetAddress inetAddress : addresses) {
                ADD_NAME_TO_NAMES_METHOD.invoke(generalNames, GENERAL_NAME_CONSTRUCTOR.newInstance(IP_ADDR_NAME_CONSTRUCTOR.newInstance(inetAddress.getHostAddress())));
            }
            Object altNamesExtension = ALT_NAMES_CONSTRUCTOR.newInstance(generalNames);
            Object certificateExtensions = CERTIFICATE_EXTENSIONS_CONSTRUCTOR.newInstance(new Object[0]);
            SET_EXTENSION_METHOD.invoke(certificateExtensions, EXTENSION_GET_NAME_METHOD.invoke(altNamesExtension, new Object[0]), altNamesExtension);
            long startTime = System.currentTimeMillis();
            Calendar calendar = Calendar.getInstance();
            calendar.setTimeInMillis(startTime);
            calendar.add(2, this._durationInMonths);
            long duration = (calendar.getTimeInMillis() - startTime) / 1000L;
            this._certificate = (X509Certificate)GET_SELF_CERTIFICATE_METHOD.invoke(certAndKeyGen, X500_NAME_CONSTRUCTOR.newInstance("CN=Qpid"), new Date(startTime), duration, certificateExtensions);
            this._generated = true;
        }
        catch (IOException | IllegalAccessException | InstantiationException | InvocationTargetException e) {
            throw new IllegalConfigurationException("Unable to construct keystore", e);
        }
    }

    private void generateKeyManagers() {
        try {
            Certificate[] certs = new X509Certificate[]{this._certificate};
            KeyStore inMemoryKeyStore = KeyStore.getInstance(KeyStore.getDefaultType());
            byte[] bytes = new byte[64];
            char[] chars = new char[64];
            RANDOM.nextBytes(bytes);
            StandardCharsets.US_ASCII.decode(ByteBuffer.wrap(bytes)).get(chars);
            inMemoryKeyStore.load(null, chars);
            inMemoryKeyStore.setKeyEntry("1", this._privateKey, chars, certs);
            KeyManagerFactory kmf = KeyManagerFactory.getInstance(KeyManagerFactory.getDefaultAlgorithm());
            kmf.init(inMemoryKeyStore, chars);
            this._keyManagers = kmf.getKeyManagers();
        }
        catch (IOException | GeneralSecurityException e) {
            throw new IllegalConfigurationException("Cannot load private key or certificate(s): " + e, e);
        }
    }

    static boolean isAvailable() {
        try {
            Class<?> certAndKeyGenClass;
            try {
                certAndKeyGenClass = Class.forName("sun.security.x509.CertAndKeyGen");
            }
            catch (ClassNotFoundException e) {
                certAndKeyGenClass = Class.forName("sun.security.tools.keytool.CertAndKeyGen");
            }
            Class<?> x500NameClass = Class.forName("sun.security.x509.X500Name");
            Class<?> certificateExtensionsClass = Class.forName("sun.security.x509.CertificateExtensions");
            Class<?> generalNamesClass = Class.forName("sun.security.x509.GeneralNames");
            Class<?> generalNameClass = Class.forName("sun.security.x509.GeneralName");
            Class<?> extensionClass = Class.forName("sun.security.x509.SubjectAlternativeNameExtension");
            CONSTRUCTOR = certAndKeyGenClass.getConstructor(String.class, String.class);
            GENERATE_METHOD = certAndKeyGenClass.getMethod("generate", Integer.TYPE);
            GET_PRIVATE_KEY_METHOD = certAndKeyGenClass.getMethod("getPrivateKey", new Class[0]);
            GET_SELF_CERTIFICATE_METHOD = certAndKeyGenClass.getMethod("getSelfCertificate", x500NameClass, Date.class, Long.TYPE, certificateExtensionsClass);
            X500_NAME_CONSTRUCTOR = x500NameClass.getConstructor(String.class);
            DNS_NAME_CONSTRUCTOR = Class.forName("sun.security.x509.DNSName").getConstructor(String.class);
            IP_ADDR_NAME_CONSTRUCTOR = Class.forName("sun.security.x509.IPAddressName").getConstructor(String.class);
            GENERAL_NAMES_CONSTRUCTOR = generalNamesClass.getConstructor(new Class[0]);
            GENERAL_NAME_CONSTRUCTOR = generalNameClass.getConstructor(Class.forName("sun.security.x509.GeneralNameInterface"));
            ADD_NAME_TO_NAMES_METHOD = generalNamesClass.getMethod("add", generalNameClass);
            ALT_NAMES_CONSTRUCTOR = extensionClass.getConstructor(generalNamesClass);
            CERTIFICATE_EXTENSIONS_CONSTRUCTOR = certificateExtensionsClass.getConstructor(new Class[0]);
            SET_EXTENSION_METHOD = certificateExtensionsClass.getMethod("set", String.class, Object.class);
            EXTENSION_GET_NAME_METHOD = extensionClass.getMethod("getName", new Class[0]);
            return true;
        }
        catch (ClassNotFoundException | LinkageError | NoSuchMethodException e) {
            return false;
        }
    }

    @Override
    public void regenerateCertificate() {
        this.generatePrivateKeyAndCertificate();
        this.saveDerivedAttributesIfNecessary();
    }

    @Override
    public Content getClientTrustStore(String password) {
        try {
            KeyStore inMemoryKeyStore = KeyStore.getInstance(KeyStore.getDefaultType());
            inMemoryKeyStore.load(null, null);
            inMemoryKeyStore.setCertificateEntry(this.getName(), this._certificate);
            return new TrustStoreContent(inMemoryKeyStore, this.getName(), password == null ? new char[]{} : password.toCharArray());
        }
        catch (IOException | KeyStoreException | NoSuchAlgorithmException | CertificateException e) {
            throw new IllegalArgumentException(e);
        }
    }

    @Override
    public Content getCertificate() {
        try {
            return new CertificateContent(this._certificate, this.getName());
        }
        catch (CertificateEncodingException e) {
            throw new IllegalArgumentException("Cannot decode encode the certificate");
        }
    }

    private static class CertificateContent
    implements Content,
    CustomRestHeaders {
        private final String _disposition;
        private final String _certString;

        public CertificateContent(X509Certificate certificate, String name) throws CertificateEncodingException {
            this._disposition = "attachment; filename=\"" + name + ".pem\"";
            StringBuffer certStringBuffer = new StringBuffer("-----BEGIN CERTIFICATE-----\n");
            String cert = DatatypeConverter.printBase64Binary((byte[])certificate.getEncoded());
            int offset = 0;
            while (cert.length() - offset > 64) {
                certStringBuffer.append(cert.substring(offset, offset + 64));
                offset += 64;
                certStringBuffer.append("\n");
            }
            certStringBuffer.append(cert.substring(offset));
            certStringBuffer.append("\n-----END CERTIFICATE-----\n");
            this._certString = certStringBuffer.toString();
        }

        @Override
        public void write(OutputStream outputStream) throws IOException {
            OutputStreamWriter w = new OutputStreamWriter(outputStream);
            w.write(this._certString);
            ((Writer)w).flush();
        }

        @Override
        public void release() {
        }

        @RestContentHeader(value="Content-Type")
        public String getContentType() {
            return "text/plain";
        }

        @RestContentHeader(value="Content-Disposition")
        public String getContentDisposition() {
            return this._disposition;
        }
    }

    private static class TrustStoreContent
    implements Content,
    CustomRestHeaders {
        private final KeyStore _keyStore;
        private final char[] _password;
        private final String _disposition;

        public TrustStoreContent(KeyStore inMemoryKeyStore, String name, char[] password) {
            this._keyStore = inMemoryKeyStore;
            this._password = password;
            this._disposition = "attachment; filename=\"" + name + ".jks\"";
        }

        @Override
        public void write(OutputStream outputStream) throws IOException {
            try {
                this._keyStore.store(outputStream, this._password);
            }
            catch (KeyStoreException | NoSuchAlgorithmException | CertificateException e) {
                throw new IllegalArgumentException(e);
            }
        }

        @Override
        public void release() {
        }

        @RestContentHeader(value="Content-Type")
        public String getContentType() {
            return "application/octet-stream";
        }

        @RestContentHeader(value="Content-Disposition")
        public String getContentDisposition() {
            return this._disposition;
        }
    }
}

