/*
 * Decompiled with CFR 0.152.
 */
package org.apache.qpid.server.queue;

import org.apache.qpid.transport.network.Ticker;

public abstract class SuspendedConsumerLoggingTicker
implements Ticker {
    private volatile long _nextTick;
    private volatile long _startTime;
    private final long _repeatPeriod;

    public SuspendedConsumerLoggingTicker(long repeatPeriod) {
        this._repeatPeriod = repeatPeriod;
    }

    public void setStartTime(long currentTime) {
        this._startTime = currentTime;
        this._nextTick = currentTime + this._repeatPeriod;
    }

    public int getTimeToNextTick(long currentTime) {
        return (int)(this._nextTick - currentTime);
    }

    public int tick(long currentTime) {
        int nextTick = this.getTimeToNextTick(currentTime);
        if (nextTick <= 0) {
            this.log(currentTime - this._startTime);
            this._nextTick += this._repeatPeriod;
            nextTick = this.getTimeToNextTick(currentTime);
        }
        return nextTick;
    }

    protected abstract void log(long var1);
}

