/*
 * Decompiled with CFR 0.152.
 */
package org.apache.qpid.server.queue;

import org.apache.qpid.server.message.MessageInstance;
import org.apache.qpid.server.message.ServerMessage;
import org.apache.qpid.server.queue.QueueEntry;
import org.apache.qpid.server.queue.QueueEntryIterator;
import org.apache.qpid.server.queue.QueueEntryList;
import org.apache.qpid.server.queue.SortedQueueEntry;
import org.apache.qpid.server.queue.SortedQueueImpl;
import org.apache.qpid.server.store.MessageEnqueueRecord;

public class SortedQueueEntryList
implements QueueEntryList {
    private final SortedQueueEntry _head;
    private SortedQueueEntry _root;
    private long _entryId = Long.MIN_VALUE;
    private final Object _lock = new Object();
    private final SortedQueueImpl _queue;
    private final String _propertyName;

    public SortedQueueEntryList(SortedQueueImpl queue) {
        this._queue = queue;
        this._head = new SortedQueueEntry(this);
        this._propertyName = queue.getSortKey();
    }

    public SortedQueueImpl getQueue() {
        return this._queue;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public SortedQueueEntry add(ServerMessage message, MessageEnqueueRecord enqueueRecord) {
        Object object = this._lock;
        synchronized (object) {
            String key = null;
            Object val = message.getMessageHeader().getHeader(this._propertyName);
            if (val != null) {
                key = val.toString();
            }
            SortedQueueEntry entry = new SortedQueueEntry(this, message, ++this._entryId, enqueueRecord);
            entry.setKey(key);
            this.insert(entry);
            return entry;
        }
    }

    private void insert(SortedQueueEntry entry) {
        SortedQueueEntry node = this._root;
        if (node == null) {
            this._root = entry;
            this._head.setNext(entry);
            entry.setPrev(this._head);
            return;
        }
        SortedQueueEntry parent = null;
        while (node != null) {
            parent = node;
            if (entry.compareTo(node) < 0) {
                node = node.getLeft();
                continue;
            }
            node = node.getRight();
        }
        entry.setParent(parent);
        if (entry.compareTo(parent) < 0) {
            parent.setLeft(entry);
            SortedQueueEntry prev = parent.getPrev();
            entry.setNext(parent);
            prev.setNext(entry);
            entry.setPrev(prev);
            parent.setPrev(entry);
        } else {
            parent.setRight(entry);
            SortedQueueEntry next = parent.getNextValidEntry();
            entry.setNext(next);
            parent.setNext(entry);
            if (next != null) {
                next.setPrev(entry);
            }
            entry.setPrev(parent);
        }
        entry.setColour(SortedQueueEntry.Colour.RED);
        this.insertFixup(entry);
    }

    private void insertFixup(SortedQueueEntry entry) {
        while (this.isParentColour(entry, SortedQueueEntry.Colour.RED)) {
            SortedQueueEntry y;
            SortedQueueEntry grandparent = this.nodeGrandparent(entry);
            if (this.nodeParent(entry) == this.leftChild(grandparent)) {
                y = this.rightChild(grandparent);
                if (this.isNodeColour(y, SortedQueueEntry.Colour.RED)) {
                    this.setColour(this.nodeParent(entry), SortedQueueEntry.Colour.BLACK);
                    this.setColour(y, SortedQueueEntry.Colour.BLACK);
                    this.setColour(grandparent, SortedQueueEntry.Colour.RED);
                    entry = grandparent;
                    continue;
                }
                if (entry == this.rightChild(this.nodeParent(entry))) {
                    entry = this.nodeParent(entry);
                    this.leftRotate(entry);
                }
                this.setColour(this.nodeParent(entry), SortedQueueEntry.Colour.BLACK);
                this.setColour(this.nodeGrandparent(entry), SortedQueueEntry.Colour.RED);
                this.rightRotate(this.nodeGrandparent(entry));
                continue;
            }
            y = this.leftChild(grandparent);
            if (this.isNodeColour(y, SortedQueueEntry.Colour.RED)) {
                this.setColour(this.nodeParent(entry), SortedQueueEntry.Colour.BLACK);
                this.setColour(y, SortedQueueEntry.Colour.BLACK);
                this.setColour(grandparent, SortedQueueEntry.Colour.RED);
                entry = grandparent;
                continue;
            }
            if (entry == this.leftChild(this.nodeParent(entry))) {
                entry = this.nodeParent(entry);
                this.rightRotate(entry);
            }
            this.setColour(this.nodeParent(entry), SortedQueueEntry.Colour.BLACK);
            this.setColour(this.nodeGrandparent(entry), SortedQueueEntry.Colour.RED);
            this.leftRotate(this.nodeGrandparent(entry));
        }
        this._root.setColour(SortedQueueEntry.Colour.BLACK);
    }

    private void leftRotate(SortedQueueEntry entry) {
        if (entry != null) {
            SortedQueueEntry rightChild = this.rightChild(entry);
            entry.setRight(rightChild.getLeft());
            if (entry.getRight() != null) {
                entry.getRight().setParent(entry);
            }
            rightChild.setParent(entry.getParent());
            if (entry.getParent() == null) {
                this._root = rightChild;
            } else if (entry == entry.getParent().getLeft()) {
                entry.getParent().setLeft(rightChild);
            } else {
                entry.getParent().setRight(rightChild);
            }
            rightChild.setLeft(entry);
            entry.setParent(rightChild);
        }
    }

    private void rightRotate(SortedQueueEntry entry) {
        if (entry != null) {
            SortedQueueEntry leftChild = this.leftChild(entry);
            entry.setLeft(leftChild.getRight());
            if (entry.getLeft() != null) {
                leftChild.getRight().setParent(entry);
            }
            leftChild.setParent(entry.getParent());
            if (leftChild.getParent() == null) {
                this._root = leftChild;
            } else if (entry == entry.getParent().getRight()) {
                entry.getParent().setRight(leftChild);
            } else {
                entry.getParent().setLeft(leftChild);
            }
            leftChild.setRight(entry);
            entry.setParent(leftChild);
        }
    }

    private void setColour(SortedQueueEntry node, SortedQueueEntry.Colour colour) {
        if (node != null) {
            node.setColour(colour);
        }
    }

    private SortedQueueEntry leftChild(SortedQueueEntry node) {
        return node == null ? null : node.getLeft();
    }

    private SortedQueueEntry rightChild(SortedQueueEntry node) {
        return node == null ? null : node.getRight();
    }

    private SortedQueueEntry nodeParent(SortedQueueEntry node) {
        return node == null ? null : node.getParent();
    }

    private SortedQueueEntry nodeGrandparent(SortedQueueEntry node) {
        return this.nodeParent(this.nodeParent(node));
    }

    private boolean isParentColour(SortedQueueEntry node, SortedQueueEntry.Colour colour) {
        return node != null && this.isNodeColour(node.getParent(), colour);
    }

    protected boolean isNodeColour(SortedQueueEntry node, SortedQueueEntry.Colour colour) {
        return (node == null ? SortedQueueEntry.Colour.BLACK : node.getColour()) == colour;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public SortedQueueEntry next(QueueEntry entry) {
        SortedQueueEntry node = (SortedQueueEntry)entry;
        Object object = this._lock;
        synchronized (object) {
            if (node.isDeleted() && this._head != node) {
                SortedQueueEntry current = this._head;
                while (current != null) {
                    SortedQueueEntry next = current.getNextValidEntry();
                    if (current.compareTo(node) > 0 && !current.isDeleted()) break;
                    current = next;
                }
                return current;
            }
            return node.getNextValidEntry();
        }
    }

    @Override
    public QueueEntryIterator iterator() {
        return new QueueEntryIteratorImpl(this._head);
    }

    @Override
    public SortedQueueEntry getHead() {
        return this._head;
    }

    @Override
    public SortedQueueEntry getTail() {
        SortedQueueEntry next;
        SortedQueueEntry current = this._head;
        while ((next = this.next(current)) != null) {
            current = next;
        }
        return current;
    }

    @Override
    public QueueEntry getOldestEntry() {
        MessageInstance oldestEntry = null;
        QueueEntryIterator iter = this.iterator();
        while (iter.advance()) {
            ServerMessage msg;
            QueueEntry node = iter.getNode();
            if (node == null || node.isDeleted() || (msg = node.getMessage()) == null || oldestEntry != null && oldestEntry.getMessage().getMessageNumber() <= msg.getMessageNumber()) continue;
            oldestEntry = node;
        }
        return oldestEntry;
    }

    protected SortedQueueEntry getRoot() {
        return this._root;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void entryDeleted(QueueEntry e) {
        SortedQueueEntry entry = (SortedQueueEntry)e;
        Object object = this._lock;
        synchronized (object) {
            SortedQueueEntry chosenChild;
            SortedQueueEntry next;
            SortedQueueEntry prev;
            if (this.leftChild(entry) != null && this.rightChild(entry) != null) {
                this.swapWithSuccessor(entry);
            }
            if ((prev = entry.getPrev()) != null) {
                prev.setNext(entry.getNextValidEntry());
            }
            if ((next = entry.getNextValidEntry()) != null) {
                next.setPrev(prev);
            }
            if ((chosenChild = this.leftChild(entry) != null ? this.leftChild(entry) : this.rightChild(entry)) != null) {
                chosenChild.setParent(entry.getParent());
                if (chosenChild.getParent() == null) {
                    this._root = chosenChild;
                } else if (entry == entry.getParent().getLeft()) {
                    entry.getParent().setLeft(chosenChild);
                } else {
                    entry.getParent().setRight(chosenChild);
                }
                entry.setLeft(null);
                entry.setRight(null);
                entry.setParent(null);
                if (entry.getColour() == SortedQueueEntry.Colour.BLACK) {
                    this.deleteFixup(chosenChild);
                }
            } else if (entry.getParent() == null) {
                this._root = null;
            } else {
                if (entry.getColour() == SortedQueueEntry.Colour.BLACK) {
                    this.deleteFixup(entry);
                }
                if (entry.getParent() != null) {
                    if (entry.getParent().getLeft() == entry) {
                        entry.getParent().setLeft(null);
                    } else if (entry.getParent().getRight() == entry) {
                        entry.getParent().setRight(null);
                    }
                    entry.setParent(null);
                }
            }
        }
    }

    @Override
    public int getPriorities() {
        return 0;
    }

    private void swapWithSuccessor(SortedQueueEntry entry) {
        SortedQueueEntry next = entry.getNextValidEntry();
        SortedQueueEntry nextParent = next.getParent();
        SortedQueueEntry nextLeft = next.getLeft();
        SortedQueueEntry nextRight = next.getRight();
        SortedQueueEntry.Colour nextColour = next.getColour();
        if (next == entry.getRight()) {
            next.setParent(entry.getParent());
            if (next.getParent() == null) {
                this._root = next;
            } else if (next.getParent().getLeft() == entry) {
                next.getParent().setLeft(next);
            } else {
                next.getParent().setRight(next);
            }
            next.setRight(entry);
            entry.setParent(next);
            next.setLeft(entry.getLeft());
            if (next.getLeft() != null) {
                next.getLeft().setParent(next);
            }
            next.setColour(entry.getColour());
            entry.setColour(nextColour);
            entry.setLeft(nextLeft);
            if (nextLeft != null) {
                nextLeft.setParent(entry);
            }
            entry.setRight(nextRight);
            if (nextRight != null) {
                nextRight.setParent(entry);
            }
        } else {
            next.setParent(entry.getParent());
            if (next.getParent() == null) {
                this._root = next;
            } else if (next.getParent().getLeft() == entry) {
                next.getParent().setLeft(next);
            } else {
                next.getParent().setRight(next);
            }
            next.setLeft(entry.getLeft());
            if (next.getLeft() != null) {
                next.getLeft().setParent(next);
            }
            next.setRight(entry.getRight());
            if (next.getRight() != null) {
                next.getRight().setParent(next);
            }
            next.setColour(entry.getColour());
            entry.setParent(nextParent);
            if (nextParent.getLeft() == next) {
                nextParent.setLeft(entry);
            } else {
                nextParent.setRight(entry);
            }
            entry.setLeft(nextLeft);
            if (nextLeft != null) {
                nextLeft.setParent(entry);
            }
            entry.setRight(nextRight);
            if (nextRight != null) {
                nextRight.setParent(entry);
            }
            entry.setColour(nextColour);
        }
    }

    private void deleteFixup(SortedQueueEntry entry) {
        int i = 0;
        while (entry != null && entry != this._root && this.isNodeColour(entry, SortedQueueEntry.Colour.BLACK)) {
            if (++i > 1000) {
                return;
            }
            if (entry == this.leftChild(this.nodeParent(entry))) {
                SortedQueueEntry rightSibling = this.rightChild(this.nodeParent(entry));
                if (this.isNodeColour(rightSibling, SortedQueueEntry.Colour.RED)) {
                    this.setColour(rightSibling, SortedQueueEntry.Colour.BLACK);
                    this.nodeParent(entry).setColour(SortedQueueEntry.Colour.RED);
                    this.leftRotate(this.nodeParent(entry));
                    rightSibling = this.rightChild(this.nodeParent(entry));
                }
                if (this.isNodeColour(this.leftChild(rightSibling), SortedQueueEntry.Colour.BLACK) && this.isNodeColour(this.rightChild(rightSibling), SortedQueueEntry.Colour.BLACK)) {
                    this.setColour(rightSibling, SortedQueueEntry.Colour.RED);
                    entry = this.nodeParent(entry);
                    continue;
                }
                if (this.isNodeColour(this.rightChild(rightSibling), SortedQueueEntry.Colour.BLACK)) {
                    this.setColour(this.leftChild(rightSibling), SortedQueueEntry.Colour.BLACK);
                    rightSibling.setColour(SortedQueueEntry.Colour.RED);
                    this.rightRotate(rightSibling);
                    rightSibling = this.rightChild(this.nodeParent(entry));
                }
                this.setColour(rightSibling, this.getColour(this.nodeParent(entry)));
                this.setColour(this.nodeParent(entry), SortedQueueEntry.Colour.BLACK);
                this.setColour(this.rightChild(rightSibling), SortedQueueEntry.Colour.BLACK);
                this.leftRotate(this.nodeParent(entry));
                entry = this._root;
                continue;
            }
            SortedQueueEntry leftSibling = this.leftChild(this.nodeParent(entry));
            if (this.isNodeColour(leftSibling, SortedQueueEntry.Colour.RED)) {
                this.setColour(leftSibling, SortedQueueEntry.Colour.BLACK);
                this.nodeParent(entry).setColour(SortedQueueEntry.Colour.RED);
                this.rightRotate(this.nodeParent(entry));
                leftSibling = this.leftChild(this.nodeParent(entry));
            }
            if (this.isNodeColour(this.leftChild(leftSibling), SortedQueueEntry.Colour.BLACK) && this.isNodeColour(this.rightChild(leftSibling), SortedQueueEntry.Colour.BLACK)) {
                this.setColour(leftSibling, SortedQueueEntry.Colour.RED);
                entry = this.nodeParent(entry);
                continue;
            }
            if (this.isNodeColour(this.leftChild(leftSibling), SortedQueueEntry.Colour.BLACK)) {
                this.setColour(this.rightChild(leftSibling), SortedQueueEntry.Colour.BLACK);
                leftSibling.setColour(SortedQueueEntry.Colour.RED);
                this.leftRotate(leftSibling);
                leftSibling = this.leftChild(this.nodeParent(entry));
            }
            this.setColour(leftSibling, this.getColour(this.nodeParent(entry)));
            this.setColour(this.nodeParent(entry), SortedQueueEntry.Colour.BLACK);
            this.setColour(this.leftChild(leftSibling), SortedQueueEntry.Colour.BLACK);
            this.rightRotate(this.nodeParent(entry));
            entry = this._root;
        }
        this.setColour(entry, SortedQueueEntry.Colour.BLACK);
    }

    private SortedQueueEntry.Colour getColour(SortedQueueEntry x) {
        return x == null ? null : x.getColour();
    }

    public class QueueEntryIteratorImpl
    implements QueueEntryIterator {
        private SortedQueueEntry _lastNode;

        public QueueEntryIteratorImpl(SortedQueueEntry startNode) {
            this._lastNode = startNode;
        }

        @Override
        public boolean atTail() {
            return SortedQueueEntryList.this.next(this._lastNode) == null;
        }

        @Override
        public SortedQueueEntry getNode() {
            return this._lastNode;
        }

        @Override
        public boolean advance() {
            if (!this.atTail()) {
                SortedQueueEntry nextNode = SortedQueueEntryList.this.next(this._lastNode);
                while (nextNode.isDeleted() && SortedQueueEntryList.this.next(nextNode) != null) {
                    nextNode = SortedQueueEntryList.this.next(nextNode);
                }
                this._lastNode = nextNode;
                return true;
            }
            return false;
        }
    }
}

