/*
 * Decompiled with CFR 0.152.
 */
package org.apache.qpid.server.queue;

import java.security.AccessControlContext;
import java.util.concurrent.atomic.AtomicBoolean;
import java.util.concurrent.atomic.AtomicInteger;
import java.util.concurrent.atomic.AtomicLong;
import org.apache.qpid.server.queue.AbstractQueue;
import org.apache.qpid.server.util.ConnectionScopedRuntimeException;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class QueueRunner
implements Runnable {
    private static final Logger _logger = LoggerFactory.getLogger(QueueRunner.class);
    private final AbstractQueue _queue;
    private static int IDLE = 0;
    private static int SCHEDULED = 1;
    private static int RUNNING = 2;
    private final AtomicInteger _scheduled = new AtomicInteger(IDLE);
    private final AtomicBoolean _stateChange = new AtomicBoolean();
    private final AtomicLong _lastRunAgain = new AtomicLong();
    private final AtomicLong _lastRunTime = new AtomicLong();
    private final AccessControlContext _context;
    private final String _taskName;

    public QueueRunner(AbstractQueue queue, AccessControlContext context) {
        this._queue = queue;
        this._context = context;
        this._taskName = "Queue Runner[" + this._queue.getName() + "]";
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void run() {
        if (this._scheduled.compareAndSet(SCHEDULED, RUNNING)) {
            long runAgain = Long.MIN_VALUE;
            this._stateChange.set(false);
            try {
                runAgain = this._queue.processQueue(this);
            }
            catch (ConnectionScopedRuntimeException e) {
                String errorMessage = "Problem during asynchronous delivery by " + this.toString();
                if (_logger.isDebugEnabled()) {
                    _logger.debug(errorMessage, (Throwable)e);
                } else {
                    _logger.info(errorMessage + ' ' + e.getMessage());
                }
            }
            finally {
                this._scheduled.compareAndSet(RUNNING, IDLE);
                long stateChangeCount = this._queue.getStateChangeCount();
                this._lastRunAgain.set(runAgain);
                this._lastRunTime.set(System.nanoTime());
                if ((runAgain == 0L || runAgain != stateChangeCount || this._stateChange.compareAndSet(true, false)) && this._scheduled.compareAndSet(IDLE, SCHEDULED)) {
                    this._queue.execute(this._taskName, this, this._context);
                }
            }
        }
    }

    public String toString() {
        return "QueueRunner-" + this._queue.getLogSubject().toLogString();
    }

    public void execute() {
        this._stateChange.set(true);
        if (this._scheduled.compareAndSet(IDLE, SCHEDULED)) {
            this._queue.execute(this._taskName, this, this._context);
        }
    }

    public boolean isIdle() {
        return this._scheduled.get() == IDLE;
    }
}

