/*
 * Decompiled with CFR 0.152.
 */
package org.apache.qpid.server.queue;

import java.util.concurrent.atomic.AtomicInteger;
import java.util.concurrent.atomic.AtomicReference;
import org.apache.qpid.server.queue.ConsumerNode;
import org.apache.qpid.server.queue.ConsumerNodeIterator;
import org.apache.qpid.server.queue.QueueConsumer;

class QueueConsumerList {
    private final ConsumerNode _head = new ConsumerNode();
    private final AtomicReference<ConsumerNode> _tail = new AtomicReference<ConsumerNode>(this._head);
    private final AtomicReference<ConsumerNode> _subNodeMarker = new AtomicReference<ConsumerNode>(this._head);
    private final AtomicInteger _size = new AtomicInteger();

    QueueConsumerList() {
    }

    private void insert(ConsumerNode node, boolean count) {
        while (true) {
            ConsumerNode tail = this._tail.get();
            ConsumerNode next = tail.nextNode();
            if (tail != this._tail.get()) continue;
            if (next == null) {
                if (!tail.setNext(node)) continue;
                this._tail.compareAndSet(tail, node);
                if (count) {
                    this._size.incrementAndGet();
                }
                return;
            }
            this._tail.compareAndSet(tail, next);
        }
    }

    public void add(QueueConsumer<?> sub) {
        ConsumerNode node = new ConsumerNode(sub);
        this.insert(node, true);
    }

    public boolean remove(QueueConsumer<?> sub) {
        ConsumerNode prevNode = this._head;
        for (ConsumerNode node = this._head.nextNode(); node != null; node = node.findNext()) {
            if (sub.equals(node.getConsumer()) && node.delete()) {
                this._size.decrementAndGet();
                ConsumerNode tail = this._tail.get();
                if (node == tail) {
                    this.insert(new ConsumerNode(), false);
                }
                prevNode.findNext();
                this.nodeMarkerCleanup(node);
                return true;
            }
            prevNode = node;
        }
        return false;
    }

    private void nodeMarkerCleanup(ConsumerNode node) {
        ConsumerNode markedNode = this._subNodeMarker.get();
        if (node == markedNode) {
            ConsumerNode dummy = new ConsumerNode();
            dummy.setNext(markedNode.nextNode());
            this._subNodeMarker.compareAndSet(markedNode, dummy);
        } else if (markedNode != null && markedNode != this._head && markedNode.isDeleted()) {
            markedNode.findNext();
        }
    }

    public boolean updateMarkedNode(ConsumerNode expected, ConsumerNode nextNode) {
        return this._subNodeMarker.compareAndSet(expected, nextNode);
    }

    public ConsumerNode getMarkedNode() {
        return this._subNodeMarker.get();
    }

    public ConsumerNodeIterator iterator() {
        return new ConsumerNodeIterator(this._head);
    }

    public ConsumerNode getHead() {
        return this._head;
    }

    public int size() {
        return this._size.get();
    }
}

