/*
 * Decompiled with CFR 0.152.
 */
package org.apache.qpid.server.queue;

import java.text.MessageFormat;
import java.util.EnumMap;
import java.util.EnumSet;
import java.util.HashMap;
import java.util.Iterator;
import java.util.Map;
import java.util.UUID;
import java.util.concurrent.atomic.AtomicBoolean;
import java.util.concurrent.atomic.AtomicLong;
import java.util.concurrent.atomic.AtomicReference;
import org.apache.qpid.filter.SelectorParsingException;
import org.apache.qpid.server.consumer.ConsumerImpl;
import org.apache.qpid.server.consumer.ConsumerTarget;
import org.apache.qpid.server.filter.FilterManager;
import org.apache.qpid.server.filter.Filterable;
import org.apache.qpid.server.filter.JMSSelectorFilter;
import org.apache.qpid.server.filter.MessageFilter;
import org.apache.qpid.server.logging.EventLogger;
import org.apache.qpid.server.logging.LogSubject;
import org.apache.qpid.server.logging.messages.SubscriptionMessages;
import org.apache.qpid.server.logging.subjects.QueueLogSubject;
import org.apache.qpid.server.message.MessageInstance;
import org.apache.qpid.server.message.MessageReference;
import org.apache.qpid.server.message.MessageSource;
import org.apache.qpid.server.message.ServerMessage;
import org.apache.qpid.server.model.AbstractConfiguredObject;
import org.apache.qpid.server.model.LifetimePolicy;
import org.apache.qpid.server.model.ManagedAttributeField;
import org.apache.qpid.server.model.Queue;
import org.apache.qpid.server.model.State;
import org.apache.qpid.server.protocol.AMQSessionModel;
import org.apache.qpid.server.protocol.MessageConverterRegistry;
import org.apache.qpid.server.queue.AbstractQueue;
import org.apache.qpid.server.queue.QueueConsumer;
import org.apache.qpid.server.queue.QueueContext;
import org.apache.qpid.server.queue.QueueEntry;
import org.apache.qpid.server.queue.SuspendedConsumerLoggingTicker;
import org.apache.qpid.server.security.access.Operation;
import org.apache.qpid.server.transport.AMQPConnection;
import org.apache.qpid.server.util.StateChangeListener;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

class QueueConsumerImpl
extends AbstractConfiguredObject<QueueConsumerImpl>
implements QueueConsumer<QueueConsumerImpl>,
LogSubject {
    private static final Logger LOGGER = LoggerFactory.getLogger(QueueConsumerImpl.class);
    private final AtomicBoolean _targetClosed = new AtomicBoolean(false);
    private final AtomicBoolean _closed = new AtomicBoolean(false);
    private final long _consumerNumber;
    private final long _createTime = System.currentTimeMillis();
    private final MessageInstance.StealableConsumerAcquiredState<QueueConsumerImpl> _owningState = new MessageInstance.StealableConsumerAcquiredState<QueueConsumerImpl>(this);
    private final WaitingOnCreditMessageListener _waitingOnCreditMessageListener = new WaitingOnCreditMessageListener();
    private final boolean _acquires;
    private final boolean _seesRequeues;
    private final boolean _isTransient;
    private final AtomicLong _deliveredCount = new AtomicLong(0L);
    private final AtomicLong _deliveredBytes = new AtomicLong(0L);
    private final FilterManager _filters;
    private final Class<? extends ServerMessage> _messageClass;
    private final Object _sessionReference;
    private final AbstractQueue _queue;
    private final SuspendedConsumerLoggingTicker _suspendedConsumerLoggingTicker;
    static final EnumMap<ConsumerTarget.State, State> STATE_MAP = new EnumMap(ConsumerTarget.State.class);
    private final ConsumerTarget _target;
    private final StateChangeListener<ConsumerTarget, ConsumerTarget.State> _listener;
    private volatile QueueContext _queueContext;
    private volatile StateChangeListener<? super QueueConsumerImpl, State> _stateListener = new StateChangeListener<QueueConsumerImpl, State>(){

        @Override
        public void stateChanged(QueueConsumerImpl sub, State oldState, State newState) {
        }
    };
    @ManagedAttributeField
    private boolean _exclusive;
    @ManagedAttributeField
    private boolean _noLocal;
    @ManagedAttributeField
    private String _distributionMode;
    @ManagedAttributeField
    private String _settlementMode;
    @ManagedAttributeField
    private String _selector;
    @ManagedAttributeField
    private int _priority;

    QueueConsumerImpl(AbstractQueue<?> queue, ConsumerTarget target, String consumerName, FilterManager filters, Class<? extends ServerMessage> messageClass, EnumSet<ConsumerImpl.Option> optionSet, Integer priority) {
        super(QueueConsumerImpl.parentsMap(queue, target.getSessionModel().getModelObject()), QueueConsumerImpl.createAttributeMap(consumerName, filters, optionSet, priority));
        this._messageClass = messageClass;
        this._sessionReference = target.getSessionModel().getConnectionReference();
        this._consumerNumber = CONSUMER_NUMBER_GENERATOR.getAndIncrement();
        this._filters = filters;
        this._acquires = optionSet.contains((Object)ConsumerImpl.Option.ACQUIRES);
        this._seesRequeues = optionSet.contains((Object)ConsumerImpl.Option.SEES_REQUEUES);
        this._isTransient = optionSet.contains((Object)ConsumerImpl.Option.TRANSIENT);
        this._target = target;
        this._queue = queue;
        this.authorise(Operation.CREATE);
        this.open();
        this.setupLogging();
        this._listener = new StateChangeListener<ConsumerTarget, ConsumerTarget.State>(){

            @Override
            public void stateChanged(ConsumerTarget object, ConsumerTarget.State oldState, ConsumerTarget.State newState) {
                QueueConsumerImpl.this.targetStateChanged(oldState, newState);
            }
        };
        this._target.addStateListener(this._listener);
        this._suspendedConsumerLoggingTicker = target.isMultiQueue() ? null : new SuspendedConsumerLoggingTicker(queue.getContextValue(Long.class, "consumer.suspendNotificationPeriod")){

            @Override
            protected void log(long period) {
                QueueConsumerImpl.this.getEventLogger().message(QueueConsumerImpl.this.getLogSubject(), SubscriptionMessages.STATE(period));
            }
        };
    }

    private static Map<String, Object> createAttributeMap(String name, FilterManager filters, EnumSet<ConsumerImpl.Option> optionSet, Integer priority) {
        HashMap<String, Object> attributes = new HashMap<String, Object>();
        attributes.put("id", UUID.randomUUID());
        attributes.put("name", name);
        attributes.put("exclusive", optionSet.contains((Object)ConsumerImpl.Option.EXCLUSIVE));
        attributes.put("noLocal", optionSet.contains((Object)ConsumerImpl.Option.NO_LOCAL));
        attributes.put("distributionMode", optionSet.contains((Object)ConsumerImpl.Option.ACQUIRES) ? "MOVE" : "COPY");
        attributes.put("durable", optionSet.contains((Object)ConsumerImpl.Option.DURABLE));
        attributes.put("lifetimePolicy", (Object)LifetimePolicy.DELETE_ON_SESSION_END);
        if (priority != null) {
            attributes.put("priority", priority);
        }
        if (filters != null) {
            Iterator<MessageFilter> iter = filters.filters();
            while (iter.hasNext()) {
                MessageFilter filter = iter.next();
                if (!(filter instanceof JMSSelectorFilter)) continue;
                attributes.put("selector", ((JMSSelectorFilter)filter).getSelector());
                break;
            }
        }
        return attributes;
    }

    private void targetStateChanged(ConsumerTarget.State oldState, ConsumerTarget.State newState) {
        StateChangeListener<? super QueueConsumerImpl, State> stateListener;
        if (oldState != newState) {
            if (newState == ConsumerTarget.State.CLOSED && this._targetClosed.compareAndSet(false, true)) {
                this.getEventLogger().message(this.getLogSubject(), SubscriptionMessages.CLOSE());
            }
            if (this._suspendedConsumerLoggingTicker != null) {
                if (newState == ConsumerTarget.State.SUSPENDED) {
                    this._suspendedConsumerLoggingTicker.setStartTime(System.currentTimeMillis());
                    this.getSessionModel().addTicker(this._suspendedConsumerLoggingTicker);
                } else {
                    this.getSessionModel().removeTicker(this._suspendedConsumerLoggingTicker);
                }
            }
        }
        if (newState == ConsumerTarget.State.CLOSED && oldState != newState && !this._closed.get()) {
            this.closeAsync();
        }
        if ((stateListener = this.getStateListener()) != null) {
            stateListener.stateChanged(this, STATE_MAP.get((Object)oldState), STATE_MAP.get((Object)newState));
        }
    }

    @Override
    public ConsumerTarget getTarget() {
        return this._target;
    }

    @Override
    public void awaitCredit(QueueEntry node) {
        this._waitingOnCreditMessageListener.update(node);
    }

    @Override
    public boolean hasCredit() {
        return this._target.hasCredit();
    }

    @Override
    public void externalStateChange() {
        if (this.isPullOnly()) {
            this.getSessionModel().getAMQPConnection().notifyWork();
        } else {
            this._queue.deliverAsync();
        }
    }

    @Override
    public boolean hasAvailableMessages() {
        return !this._queue.isEmpty() && this._queue.hasAvailableMessages(this);
    }

    @Override
    public long getUnacknowledgedBytes() {
        return this._target.getUnacknowledgedBytes();
    }

    @Override
    public long getUnacknowledgedMessages() {
        return this._target.getUnacknowledgedMessages();
    }

    @Override
    public AMQSessionModel getSessionModel() {
        return this._target.getSessionModel();
    }

    @Override
    public MessageSource getMessageSource() {
        return this._queue;
    }

    @Override
    public boolean isSuspended() {
        return this._target.isSuspended();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    protected void onClose() {
        if (this._closed.compareAndSet(false, true)) {
            this._target.getSendLock();
            try {
                this._waitingOnCreditMessageListener.remove();
                this._target.consumerRemoved(this);
                this._target.removeStateChangeListener(this._listener);
                this._queue.unregisterConsumer(this);
                if (this._suspendedConsumerLoggingTicker != null) {
                    this.getSessionModel().removeTicker(this._suspendedConsumerLoggingTicker);
                }
                this.deleted();
            }
            finally {
                this._target.releaseSendLock();
            }
        }
    }

    @Override
    public int getPriority() {
        return this._priority;
    }

    @Override
    public void flushBatched() {
        this._target.flushBatched();
    }

    @Override
    public boolean isPullOnly() {
        return this._target.isPullOnly();
    }

    @Override
    public void queueDeleted() {
        this._target.queueDeleted();
    }

    @Override
    public boolean wouldSuspend(QueueEntry msg) {
        return !this._target.allocateCredit(msg.getMessage());
    }

    @Override
    public void restoreCredit(QueueEntry queueEntry) {
        this._target.restoreCredit(queueEntry.getMessage());
    }

    @Override
    public void queueEmpty() {
        this._target.queueEmpty();
    }

    @Override
    public State getState() {
        return STATE_MAP.get((Object)this._target.getState());
    }

    @Override
    public final Queue<?> getQueue() {
        return this._queue;
    }

    private void setupLogging() {
        String filterLogString = this.getFilterLogString();
        this.getEventLogger().message(this, SubscriptionMessages.CREATE(filterLogString, this._queue.isDurable() && this._exclusive, filterLogString.length() > 0));
    }

    protected final LogSubject getLogSubject() {
        return this;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public final void flush() {
        AMQPConnection<?> connection = this._target.getSessionModel().getAMQPConnection();
        try {
            connection.alwaysAllowMessageAssignmentInThisThreadIfItIsIOThread(true);
            this._queue.flushConsumer(this);
            this._target.processPending();
        }
        finally {
            connection.alwaysAllowMessageAssignmentInThisThreadIfItIsIOThread(false);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void pullMessage() {
        AMQPConnection<?> connection = this._target.getSessionModel().getAMQPConnection();
        try {
            connection.alwaysAllowMessageAssignmentInThisThreadIfItIsIOThread(true);
            this._queue.flushConsumer(this, 1L);
        }
        finally {
            connection.alwaysAllowMessageAssignmentInThisThreadIfItIsIOThread(false);
        }
    }

    @Override
    public boolean resend(QueueEntry entry) {
        boolean messageWasResent = this.getQueue().resend(entry, this);
        if (messageWasResent) {
            this._target.processPending();
        }
        return messageWasResent;
    }

    @Override
    public final long getConsumerNumber() {
        return this._consumerNumber;
    }

    public final StateChangeListener<? super QueueConsumerImpl, State> getStateListener() {
        return this._stateListener;
    }

    public final void setStateListener(StateChangeListener<? super QueueConsumerImpl, State> listener) {
        this._stateListener = listener;
    }

    @Override
    public final QueueContext getQueueContext() {
        return this._queueContext;
    }

    final void setQueueContext(QueueContext queueContext) {
        this._queueContext = queueContext;
    }

    @Override
    public final boolean isActive() {
        return this.getState() == State.ACTIVE;
    }

    @Override
    public final boolean isClosed() {
        return this.getState() == State.DELETED;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public final boolean hasInterest(QueueEntry entry) {
        Object connectionRef;
        if (entry.isRejectedBy(this) || entry.checkHeld(System.currentTimeMillis())) {
            return false;
        }
        if (entry.getMessage().getClass() == this._messageClass ? this._noLocal && (connectionRef = entry.getMessage().getConnectionReference()) != null && connectionRef == this._sessionReference : this._messageClass != null && MessageConverterRegistry.getConverter(entry.getMessage().getClass(), this._messageClass) == null) {
            return false;
        }
        if (this._filters == null) {
            return true;
        }
        MessageReference ref = entry.newMessageReference();
        if (ref != null) {
            try {
                Filterable msg = entry.asFilterable();
                try {
                    boolean bl = this._filters.allAllow(msg);
                    return bl;
                }
                catch (SelectorParsingException e) {
                    LOGGER.info(this + " could not evaluate filter [" + this._filters + "]  against message " + msg + ". Error was : " + e.getMessage());
                    boolean bl = false;
                    ref.release();
                    return bl;
                }
            }
            finally {
                ref.release();
            }
        }
        return false;
    }

    protected String getFilterLogString() {
        StringBuilder filterLogString = new StringBuilder();
        String delimiter = ", ";
        boolean hasEntries = false;
        if (this._filters != null && this._filters.hasFilters()) {
            filterLogString.append(this._filters.toString());
            hasEntries = true;
        }
        if (!this.acquires()) {
            if (hasEntries) {
                filterLogString.append(delimiter);
            }
            filterLogString.append("Browser");
        }
        return filterLogString.toString();
    }

    @Override
    public final boolean trySendLock() {
        return this.getTarget().trySendLock();
    }

    @Override
    public final void getSendLock() {
        this.getTarget().getSendLock();
    }

    @Override
    public final void releaseSendLock() {
        this.getTarget().releaseSendLock();
    }

    public final long getCreateTime() {
        return this._createTime;
    }

    @Override
    public final MessageInstance.StealableConsumerAcquiredState<QueueConsumerImpl> getOwningState() {
        return this._owningState;
    }

    @Override
    public final boolean acquires() {
        return this._acquires;
    }

    @Override
    public final boolean seesRequeues() {
        return this._seesRequeues;
    }

    public final boolean isTransient() {
        return this._isTransient;
    }

    @Override
    public final long getBytesOut() {
        return this._deliveredBytes.longValue();
    }

    @Override
    public final long getMessagesOut() {
        return this._deliveredCount.longValue();
    }

    @Override
    public final void send(QueueEntry entry, boolean batch) {
        this._deliveredCount.incrementAndGet();
        long size = this._target.send(this, entry, batch);
        this._deliveredBytes.addAndGet(size);
    }

    @Override
    public void acquisitionRemoved(QueueEntry node) {
        this._target.acquisitionRemoved(node);
        this._queue.decrementUnackedMsgCount(node);
    }

    @Override
    public String getDistributionMode() {
        return this._distributionMode;
    }

    @Override
    public String getSettlementMode() {
        return this._settlementMode;
    }

    @Override
    public boolean isExclusive() {
        return this._exclusive;
    }

    @Override
    public boolean isNoLocal() {
        return this._noLocal;
    }

    @Override
    public String getSelector() {
        return this._selector;
    }

    @Override
    public String toLogString() {
        String logString;
        if (this._queue == null) {
            logString = "[" + MessageFormat.format("sub:{0}", this.getConsumerNumber()) + "(UNKNOWN)" + "] ";
        } else {
            String queueString = new QueueLogSubject(this._queue).toLogString();
            logString = "[" + MessageFormat.format("sub:{0}", this.getConsumerNumber()) + "(" + queueString.substring(1, queueString.length() - 3) + ")" + "] ";
        }
        return logString;
    }

    private EventLogger getEventLogger() {
        return this._queue.getEventLogger();
    }

    static {
        STATE_MAP.put(ConsumerTarget.State.ACTIVE, State.ACTIVE);
        STATE_MAP.put(ConsumerTarget.State.SUSPENDED, State.QUIESCED);
        STATE_MAP.put(ConsumerTarget.State.CLOSED, State.DELETED);
    }

    public class WaitingOnCreditMessageListener
    implements StateChangeListener<MessageInstance, MessageInstance.EntryState> {
        private final AtomicReference<MessageInstance> _entry = new AtomicReference();

        public void update(MessageInstance entry) {
            this.remove();
            this._entry.set(entry);
            entry.addStateChangeListener(this);
            if (!entry.isAvailable()) {
                if (QueueConsumerImpl.this.isPullOnly()) {
                    QueueConsumerImpl.this.getSessionModel().getAMQPConnection().notifyWork();
                } else {
                    QueueConsumerImpl.this._queue.deliverAsync();
                }
                this.remove();
            }
        }

        public void remove() {
            MessageInstance instance = this._entry.getAndSet(null);
            if (instance != null) {
                instance.removeStateChangeListener(this);
            }
        }

        @Override
        public void stateChanged(MessageInstance entry, MessageInstance.EntryState oldState, MessageInstance.EntryState newState) {
            entry.removeStateChangeListener(this);
            this._entry.compareAndSet(entry, null);
            if (QueueConsumerImpl.this.isPullOnly()) {
                QueueConsumerImpl.this.getSessionModel().getAMQPConnection().notifyWork();
            } else {
                QueueConsumerImpl.this._queue.deliverAsync();
            }
        }
    }
}

