/*
 * Decompiled with CFR 0.152.
 */
package org.apache.qpid.server.queue;

import java.util.Map;
import org.apache.qpid.server.model.VirtualHost;
import org.apache.qpid.server.queue.AbstractQueue;
import org.apache.qpid.server.queue.ConsumerNodeIterator;
import org.apache.qpid.server.queue.QueueConsumer;
import org.apache.qpid.server.queue.QueueContext;
import org.apache.qpid.server.queue.QueueEntry;

public abstract class OutOfOrderQueue<X extends OutOfOrderQueue<X>>
extends AbstractQueue<X> {
    protected OutOfOrderQueue(Map<String, Object> attributes, VirtualHost<?> virtualHost) {
        super(attributes, virtualHost);
    }

    @Override
    protected void checkConsumersNotAheadOfDelivery(QueueEntry entry) {
        ConsumerNodeIterator subIter = this.getConsumerList().iterator();
        while (subIter.advance() && !entry.isAcquired()) {
            QueueContext context;
            QueueConsumer<?> consumer = subIter.getNode().getConsumer();
            if (consumer.isClosed() || (context = consumer.getQueueContext()) == null) continue;
            QueueEntry released = context.getReleasedEntry();
            while (!(entry.isAcquired() || released != null && released.compareTo(entry) <= 0 || QueueContext._releasedUpdater.compareAndSet(context, released, entry))) {
                released = context.getReleasedEntry();
            }
        }
    }
}

