/*
 * Decompiled with CFR 0.152.
 */
package org.apache.qpid.server.queue;

import org.apache.qpid.server.message.ServerMessage;
import org.apache.qpid.server.model.Queue;
import org.apache.qpid.server.model.QueueNotificationListener;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public enum NotificationCheck {
    MESSAGE_COUNT_ALERT{

        @Override
        public boolean notifyIfNecessary(ServerMessage<?> msg, Queue<?> queue, QueueNotificationListener listener) {
            int msgCount;
            long maximumMessageCount = queue.getAlertThresholdQueueDepthMessages();
            if (maximumMessageCount != 0L && (long)(msgCount = queue.getQueueDepthMessages()) >= maximumMessageCount) {
                String notificationMsg = msgCount + ": Maximum count on queue threshold (" + maximumMessageCount + ") breached.";
                NotificationCheck.logNotification((NotificationCheck)this, queue, notificationMsg);
                listener.notifyClients(this, queue, notificationMsg);
                return true;
            }
            return false;
        }
    }
    ,
    MESSAGE_SIZE_ALERT(true, true){

        @Override
        public boolean notifyIfNecessary(ServerMessage<?> msg, Queue<?> queue, QueueNotificationListener listener) {
            long maximumMessageSize = queue.getAlertThresholdMessageSize();
            if (maximumMessageSize != 0L) {
                long messageSize;
                long l = messageSize = msg == null ? 0L : msg.getSize();
                if (messageSize >= maximumMessageSize) {
                    String notificationMsg = messageSize + "b : Maximum message size threshold (" + maximumMessageSize + ") breached. [Message ID=" + msg.getMessageNumber() + "]";
                    NotificationCheck.logNotification((NotificationCheck)this, queue, notificationMsg);
                    listener.notifyClients(this, queue, notificationMsg);
                    return true;
                }
            }
            return false;
        }
    }
    ,
    QUEUE_DEPTH_ALERT{

        @Override
        public boolean notifyIfNecessary(ServerMessage<?> msg, Queue<?> queue, QueueNotificationListener listener) {
            long queueDepth;
            long maximumQueueDepth = queue.getAlertThresholdQueueDepthBytes();
            if (maximumQueueDepth != 0L && (queueDepth = queue.getQueueDepthBytes()) >= maximumQueueDepth) {
                String notificationMsg = (queueDepth >> 10) + "Kb : Maximum queue depth threshold (" + (maximumQueueDepth >> 10) + "Kb) breached.";
                NotificationCheck.logNotification((NotificationCheck)this, queue, notificationMsg);
                listener.notifyClients(this, queue, notificationMsg);
                return true;
            }
            return false;
        }
    }
    ,
    MESSAGE_AGE_ALERT(false, false){

        @Override
        public boolean notifyIfNecessary(ServerMessage<?> msg, Queue<?> queue, QueueNotificationListener listener) {
            long maxMessageAge = queue.getAlertThresholdMessageAge();
            if (maxMessageAge != 0L) {
                long currentTime = System.currentTimeMillis();
                long thresholdTime = currentTime - maxMessageAge;
                long firstArrivalTime = queue.getOldestMessageArrivalTime();
                if (firstArrivalTime != 0L && firstArrivalTime < thresholdTime) {
                    long oldestAge = currentTime - firstArrivalTime;
                    String notificationMsg = oldestAge / 1000L + "s : Maximum age on queue threshold (" + maxMessageAge / 1000L + "s) breached.";
                    NotificationCheck.logNotification((NotificationCheck)this, queue, notificationMsg);
                    listener.notifyClients(this, queue, notificationMsg);
                    return true;
                }
            }
            return false;
        }
    };

    private static final Logger LOGGER;
    private final boolean _messageSpecific;
    private final boolean _checkOnMessageArrival;

    private NotificationCheck() {
        this(false, true);
    }

    private NotificationCheck(boolean messageSpecific, boolean checkOnMessageArrival) {
        this._messageSpecific = messageSpecific;
        this._checkOnMessageArrival = checkOnMessageArrival;
    }

    public boolean isMessageSpecific() {
        return this._messageSpecific;
    }

    public boolean isCheckOnMessageArrival() {
        return this._checkOnMessageArrival;
    }

    public abstract boolean notifyIfNecessary(ServerMessage<?> var1, Queue<?> var2, QueueNotificationListener var3);

    private static void logNotification(NotificationCheck notification, Queue<?> queue, String notificationMsg) {
        LOGGER.info(notification.name() + " On Queue " + queue.getName() + " - " + notificationMsg);
    }

    static {
        LOGGER = LoggerFactory.getLogger(NotificationCheck.class);
    }
}

