/*
 * Decompiled with CFR 0.152.
 */
package org.apache.qpid.server.queue;

import java.util.List;
import org.apache.qpid.server.filter.MessageFilter;
import org.apache.qpid.server.message.ServerMessage;
import org.apache.qpid.server.model.Queue;
import org.apache.qpid.server.model.VirtualHost;
import org.apache.qpid.server.queue.QueueEntry;
import org.apache.qpid.server.queue.QueueEntryTransaction;

public class MoveMessagesTransaction
extends QueueEntryTransaction {
    private final Queue _destinationQueue;

    public MoveMessagesTransaction(Queue sourceQueue, List<Long> messageIds, Queue destinationQueue, MessageFilter filter, int limit) {
        super(sourceQueue, messageIds, filter, limit);
        this._destinationQueue = destinationQueue;
    }

    @Override
    protected void updateEntry(QueueEntry entry, VirtualHost.Transaction txn) {
        ServerMessage msg = entry.getMessage();
        if (msg != null && !msg.isReferenced(this._destinationQueue)) {
            txn.move(entry, this._destinationQueue);
        }
    }
}

