/*
 * Decompiled with CFR 0.152.
 */
package org.apache.qpid.server.queue;

import java.util.List;
import java.util.Map;
import org.apache.qpid.server.message.MessageInfo;
import org.apache.qpid.server.model.Content;
import org.apache.qpid.server.model.Queue;
import org.apache.qpid.server.model.VirtualHost;
import org.apache.qpid.server.queue.LastValueQueueImpl;
import org.apache.qpid.server.security.access.Operation;
import org.apache.qpid.server.util.FixedKeyMapCreator;

final class LastValueQueueImplWithAccessChecking
extends LastValueQueueImpl {
    private static final FixedKeyMapCreator MOVE_MESSAGES_MAP_CREATOR = new FixedKeyMapCreator("destination", "messageIds", "selector", "limit");
    private static final FixedKeyMapCreator COPY_MESSAGES_MAP_CREATOR = new FixedKeyMapCreator("destination", "messageIds", "selector", "limit");
    private static final FixedKeyMapCreator DELETE_MESSAGES_MAP_CREATOR = new FixedKeyMapCreator("messageIds", "selector", "limit");
    private static final FixedKeyMapCreator GET_MESSAGE_CONTENT_MAP_CREATOR = new FixedKeyMapCreator("messageId", "limit", "returnJson", "decompressBeforeLimiting");
    private static final FixedKeyMapCreator GET_MESSAGE_INFO_MAP_CREATOR = new FixedKeyMapCreator("first", "last", "includeHeaders");
    private static final FixedKeyMapCreator GET_MESSAGE_INFO_BY_ID_MAP_CREATOR = new FixedKeyMapCreator("messageId", "includeHeaders");

    LastValueQueueImplWithAccessChecking(Map<String, Object> attributes, VirtualHost<?> virtualhost) {
        super(attributes, virtualhost);
    }

    @Override
    public List<Long> moveMessages(Queue<?> destination, List<Long> messageIds, String selector, int limit) {
        this.authorise(Operation.METHOD("moveMessages"), MOVE_MESSAGES_MAP_CREATOR.createMap(destination, messageIds, selector, limit));
        return super.moveMessages(destination, messageIds, selector, limit);
    }

    @Override
    public List<Long> copyMessages(Queue<?> destination, List<Long> messageIds, String selector, int limit) {
        this.authorise(Operation.METHOD("copyMessages"), COPY_MESSAGES_MAP_CREATOR.createMap(destination, messageIds, selector, limit));
        return super.copyMessages(destination, messageIds, selector, limit);
    }

    @Override
    public List<Long> deleteMessages(List<Long> messageIds, String selector, int limit) {
        this.authorise(Operation.METHOD("deleteMessages"), DELETE_MESSAGES_MAP_CREATOR.createMap(messageIds, selector, limit));
        return super.deleteMessages(messageIds, selector, limit);
    }

    @Override
    public long clearQueue() {
        this.authorise(Operation.METHOD("clearQueue"));
        return super.clearQueue();
    }

    @Override
    public Content getMessageContent(long messageId, long limit, boolean returnJson, boolean decompressBeforeLimiting) {
        this.authorise(Operation.METHOD("getMessageContent"), GET_MESSAGE_CONTENT_MAP_CREATOR.createMap(messageId, limit, returnJson, decompressBeforeLimiting));
        return super.getMessageContent(messageId, limit, returnJson, decompressBeforeLimiting);
    }

    @Override
    public List<MessageInfo> getMessageInfo(int first, int last, boolean includeHeaders) {
        this.authorise(Operation.METHOD("getMessageInfo"), GET_MESSAGE_INFO_MAP_CREATOR.createMap(first, last, includeHeaders));
        return super.getMessageInfo(first, last, includeHeaders);
    }

    @Override
    public MessageInfo getMessageInfoById(long messageId, boolean includeHeaders) {
        this.authorise(Operation.METHOD("getMessageInfoById"), GET_MESSAGE_INFO_BY_ID_MAP_CREATOR.createMap(messageId, includeHeaders));
        return super.getMessageInfoById(messageId, includeHeaders);
    }
}

