/*
 * Decompiled with CFR 0.152.
 */
package org.apache.qpid.server.queue;

import java.util.concurrent.atomic.AtomicBoolean;
import java.util.concurrent.atomic.AtomicReference;
import org.apache.qpid.server.queue.QueueConsumer;

public final class ConsumerNode {
    private final AtomicBoolean _deleted = new AtomicBoolean();
    private final AtomicReference<ConsumerNode> _next = new AtomicReference();
    private final QueueConsumer<?> _sub;

    public ConsumerNode() {
        this._sub = null;
        this._deleted.set(true);
    }

    public ConsumerNode(QueueConsumer<?> sub) {
        this._sub = sub;
    }

    public ConsumerNode findNext() {
        ConsumerNode next = this.nextNode();
        while (next != null && next.isDeleted()) {
            ConsumerNode newNext = next.nextNode();
            if (newNext != null) {
                this._next.compareAndSet(next, newNext);
                next = this.nextNode();
                continue;
            }
            next = null;
        }
        return next;
    }

    protected ConsumerNode nextNode() {
        return this._next.get();
    }

    boolean setNext(ConsumerNode node) {
        return this._next.compareAndSet(null, node);
    }

    public boolean isDeleted() {
        return this._deleted.get();
    }

    public boolean delete() {
        return this._deleted.compareAndSet(false, true);
    }

    public QueueConsumer<?> getConsumer() {
        return this._sub;
    }
}

