/*
 * Decompiled with CFR 0.152.
 */
package org.apache.qpid.server.queue;

import java.util.Collections;
import java.util.HashSet;
import java.util.Set;
import org.apache.qpid.server.model.ConfiguredObject;
import org.apache.qpid.server.plugin.ConfiguredObjectRegistration;
import org.apache.qpid.server.plugin.PluggableService;
import org.apache.qpid.server.queue.LastValueQueue;
import org.apache.qpid.server.queue.PriorityQueue;
import org.apache.qpid.server.queue.SortedQueue;
import org.apache.qpid.server.queue.StandardQueue;

@PluggableService
public class ConfiguredObjectRegistrationImpl
implements ConfiguredObjectRegistration {
    private final Set<Class<? extends ConfiguredObject>> _implementations;

    public ConfiguredObjectRegistrationImpl() {
        HashSet<Class> implementations = new HashSet<Class>();
        if (!Boolean.getBoolean("qpid.type.disabled:queue.standard")) {
            implementations.add(StandardQueue.class);
        }
        if (!Boolean.getBoolean("qpid.type.disabled:queue.priority")) {
            implementations.add(PriorityQueue.class);
        }
        if (!Boolean.getBoolean("qpid.type.disabled:queue.lvq")) {
            implementations.add(LastValueQueue.class);
        }
        if (!Boolean.getBoolean("qpid.type.disabled:queue.sorted")) {
            implementations.add(SortedQueue.class);
        }
        this._implementations = Collections.unmodifiableSet(implementations);
    }

    @Override
    public String getType() {
        return "org.apache.qpid.server.queue";
    }

    public Set<Class<? extends ConfiguredObject>> getConfiguredObjectClasses() {
        return this._implementations;
    }
}

