/*
 * Decompiled with CFR 0.152.
 */
package org.apache.qpid.server.queue;

import java.util.Iterator;
import java.util.concurrent.ConcurrentHashMap;
import java.util.concurrent.ConcurrentMap;
import org.apache.qpid.server.queue.MessageGroupManager;
import org.apache.qpid.server.queue.QueueConsumer;
import org.apache.qpid.server.queue.QueueEntry;
import org.apache.qpid.server.queue.QueueEntryVisitor;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class AssignedConsumerMessageGroupManager
implements MessageGroupManager {
    private static final Logger _logger = LoggerFactory.getLogger(AssignedConsumerMessageGroupManager.class);
    private final String _groupId;
    private final ConcurrentMap<Integer, QueueConsumer<?>> _groupMap = new ConcurrentHashMap();
    private final int _groupMask;

    public AssignedConsumerMessageGroupManager(String groupId, int maxGroups) {
        this._groupId = groupId;
        this._groupMask = AssignedConsumerMessageGroupManager.pow2(maxGroups) - 1;
    }

    private static int pow2(int i) {
        int val;
        for (val = 1; val < i; val <<= 1) {
        }
        return val;
    }

    @Override
    public boolean mightAssign(QueueEntry entry, QueueConsumer sub) {
        Object groupVal = entry.getMessage().getMessageHeader().getHeader(this._groupId);
        if (groupVal == null) {
            return true;
        }
        QueueConsumer assignedSub = (QueueConsumer)this._groupMap.get(groupVal.hashCode() & this._groupMask);
        return assignedSub == null || assignedSub == sub;
    }

    @Override
    public boolean acceptMessage(QueueConsumer<?> sub, QueueEntry entry) {
        return this.assignMessage(sub, entry) && entry.acquire(sub);
    }

    private boolean assignMessage(QueueConsumer<?> sub, QueueEntry entry) {
        Object groupVal = entry.getMessage().getMessageHeader().getHeader(this._groupId);
        if (groupVal == null) {
            return true;
        }
        Integer group = groupVal.hashCode() & this._groupMask;
        QueueConsumer<?> assignedSub = (QueueConsumer<?>)this._groupMap.get(group);
        if (assignedSub == sub) {
            return true;
        }
        if (assignedSub == null) {
            _logger.debug("Assigning group {} to sub {}", groupVal, sub);
            assignedSub = this._groupMap.putIfAbsent(group, sub);
            return assignedSub == null || assignedSub == sub;
        }
        return false;
    }

    @Override
    public QueueEntry findEarliestAssignedAvailableEntry(QueueConsumer<?> sub) {
        EntryFinder visitor = new EntryFinder(sub);
        sub.getQueue().visit(visitor);
        return visitor.getEntry();
    }

    @Override
    public void clearAssignments(QueueConsumer<?> sub) {
        Iterator subIter = this._groupMap.values().iterator();
        while (subIter.hasNext()) {
            if (subIter.next() != sub) continue;
            subIter.remove();
        }
    }

    private class EntryFinder
    implements QueueEntryVisitor {
        private QueueEntry _entry;
        private QueueConsumer<?> _sub;

        public EntryFinder(QueueConsumer<?> sub) {
            this._sub = sub;
        }

        @Override
        public boolean visit(QueueEntry entry) {
            if (!entry.isAvailable()) {
                return false;
            }
            Object groupId = entry.getMessage().getMessageHeader().getHeader(AssignedConsumerMessageGroupManager.this._groupId);
            if (groupId == null) {
                return false;
            }
            Integer group = groupId.hashCode() & AssignedConsumerMessageGroupManager.this._groupMask;
            QueueConsumer assignedSub = (QueueConsumer)AssignedConsumerMessageGroupManager.this._groupMap.get(group);
            if (assignedSub == this._sub) {
                this._entry = entry;
                return true;
            }
            return false;
        }

        public QueueEntry getEntry() {
            return this._entry;
        }
    }
}

