/*
 * Decompiled with CFR 0.152.
 */
package org.apache.qpid.server.queue;

import com.google.common.io.ByteStreams;
import com.google.common.util.concurrent.FutureCallback;
import com.google.common.util.concurrent.Futures;
import com.google.common.util.concurrent.ListenableFuture;
import com.google.common.util.concurrent.SettableFuture;
import java.io.IOException;
import java.io.InputStream;
import java.io.OutputStream;
import java.io.UnsupportedEncodingException;
import java.net.URLEncoder;
import java.nio.charset.StandardCharsets;
import java.security.AccessControlContext;
import java.security.AccessControlException;
import java.security.AccessController;
import java.security.Principal;
import java.security.PrivilegedAction;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Collections;
import java.util.EnumSet;
import java.util.HashSet;
import java.util.LinkedHashMap;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.Set;
import java.util.concurrent.Callable;
import java.util.concurrent.ConcurrentHashMap;
import java.util.concurrent.ConcurrentLinkedQueue;
import java.util.concurrent.ConcurrentMap;
import java.util.concurrent.ConcurrentSkipListSet;
import java.util.concurrent.CopyOnWriteArrayList;
import java.util.concurrent.RejectedExecutionException;
import java.util.concurrent.atomic.AtomicBoolean;
import java.util.concurrent.atomic.AtomicInteger;
import java.util.concurrent.atomic.AtomicLong;
import java.util.zip.GZIPInputStream;
import java.util.zip.GZIPOutputStream;
import javax.security.auth.Subject;
import org.apache.qpid.bytebuffer.QpidByteBuffer;
import org.apache.qpid.bytebuffer.QpidByteBufferInputStream;
import org.apache.qpid.filter.SelectorParsingException;
import org.apache.qpid.filter.selector.ParseException;
import org.apache.qpid.filter.selector.TokenMgrError;
import org.apache.qpid.server.configuration.IllegalConfigurationException;
import org.apache.qpid.server.configuration.updater.Task;
import org.apache.qpid.server.connection.SessionPrincipal;
import org.apache.qpid.server.consumer.ConsumerImpl;
import org.apache.qpid.server.consumer.ConsumerTarget;
import org.apache.qpid.server.filter.FilterManager;
import org.apache.qpid.server.filter.JMSSelectorFilter;
import org.apache.qpid.server.filter.MessageFilter;
import org.apache.qpid.server.logging.EventLogger;
import org.apache.qpid.server.logging.LogMessage;
import org.apache.qpid.server.logging.LogSubject;
import org.apache.qpid.server.logging.messages.QueueMessages;
import org.apache.qpid.server.logging.subjects.QueueLogSubject;
import org.apache.qpid.server.message.InstanceProperties;
import org.apache.qpid.server.message.MessageDeletedException;
import org.apache.qpid.server.message.MessageInfo;
import org.apache.qpid.server.message.MessageInfoImpl;
import org.apache.qpid.server.message.MessageInstance;
import org.apache.qpid.server.message.MessageReference;
import org.apache.qpid.server.message.MessageSource;
import org.apache.qpid.server.message.ServerMessage;
import org.apache.qpid.server.message.internal.InternalMessage;
import org.apache.qpid.server.model.AbstractConfiguredObject;
import org.apache.qpid.server.model.Binding;
import org.apache.qpid.server.model.Broker;
import org.apache.qpid.server.model.ConfigurationChangeListener;
import org.apache.qpid.server.model.ConfiguredObject;
import org.apache.qpid.server.model.Consumer;
import org.apache.qpid.server.model.Content;
import org.apache.qpid.server.model.CustomRestHeaders;
import org.apache.qpid.server.model.Exchange;
import org.apache.qpid.server.model.ExclusivityPolicy;
import org.apache.qpid.server.model.LifetimePolicy;
import org.apache.qpid.server.model.ManagedAttributeField;
import org.apache.qpid.server.model.NamedAddressSpace;
import org.apache.qpid.server.model.Queue;
import org.apache.qpid.server.model.QueueNotificationListener;
import org.apache.qpid.server.model.RestContentHeader;
import org.apache.qpid.server.model.State;
import org.apache.qpid.server.model.StateTransition;
import org.apache.qpid.server.model.VirtualHost;
import org.apache.qpid.server.model.preferences.GenericPrincipal;
import org.apache.qpid.server.plugin.MessageConverter;
import org.apache.qpid.server.plugin.MessageFilterFactory;
import org.apache.qpid.server.plugin.QpidServiceLoader;
import org.apache.qpid.server.protocol.AMQSessionModel;
import org.apache.qpid.server.protocol.MessageConverterRegistry;
import org.apache.qpid.server.queue.AssignedConsumerMessageGroupManager;
import org.apache.qpid.server.queue.ConsumerNode;
import org.apache.qpid.server.queue.ConsumerNodeIterator;
import org.apache.qpid.server.queue.CopyMessagesTransaction;
import org.apache.qpid.server.queue.DefinedGroupMessageGroupManager;
import org.apache.qpid.server.queue.DeleteMessagesTransaction;
import org.apache.qpid.server.queue.MessageContentJsonConverter;
import org.apache.qpid.server.queue.MessageGroupManager;
import org.apache.qpid.server.queue.MoveMessagesTransaction;
import org.apache.qpid.server.queue.NotificationCheck;
import org.apache.qpid.server.queue.QueueConsumer;
import org.apache.qpid.server.queue.QueueConsumerImpl;
import org.apache.qpid.server.queue.QueueConsumerList;
import org.apache.qpid.server.queue.QueueContext;
import org.apache.qpid.server.queue.QueueEntry;
import org.apache.qpid.server.queue.QueueEntryIterator;
import org.apache.qpid.server.queue.QueueEntryList;
import org.apache.qpid.server.queue.QueueEntryVisitor;
import org.apache.qpid.server.queue.QueueRunner;
import org.apache.qpid.server.security.SecurityToken;
import org.apache.qpid.server.security.access.Operation;
import org.apache.qpid.server.security.auth.AuthenticatedPrincipal;
import org.apache.qpid.server.store.MessageDurability;
import org.apache.qpid.server.store.MessageEnqueueRecord;
import org.apache.qpid.server.store.StorableMessageMetaData;
import org.apache.qpid.server.store.StoredMessage;
import org.apache.qpid.server.transport.AMQPConnection;
import org.apache.qpid.server.txn.AutoCommitTransaction;
import org.apache.qpid.server.txn.LocalTransaction;
import org.apache.qpid.server.txn.ServerTransaction;
import org.apache.qpid.server.util.Action;
import org.apache.qpid.server.util.ConnectionScopedRuntimeException;
import org.apache.qpid.server.util.Deletable;
import org.apache.qpid.server.util.MapValueConverter;
import org.apache.qpid.server.util.ParameterizedTypes;
import org.apache.qpid.server.util.ServerScopedRuntimeException;
import org.apache.qpid.server.util.StateChangeListener;
import org.apache.qpid.server.virtualhost.VirtualHostUnavailableException;
import org.apache.qpid.transport.TransportException;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public abstract class AbstractQueue<X extends AbstractQueue<X>>
extends AbstractConfiguredObject<X>
implements Queue<X>,
StateChangeListener<QueueConsumer<?>, State>,
MessageGroupManager.ConsumerResetHelper {
    private static final Logger _logger = LoggerFactory.getLogger(AbstractQueue.class);
    public static final String SHARED_MSG_GROUP_ARG_VALUE = "1";
    private static final QueueNotificationListener NULL_NOTIFICATION_LISTENER = new QueueNotificationListener(){

        @Override
        public void notifyClients(NotificationCheck notification, Queue queue, String notificationMsg) {
        }
    };
    private static final long INITIAL_TARGET_QUEUE_SIZE = 102400L;
    private static final String UTF8 = StandardCharsets.UTF_8.name();
    private static final Operation PUBLISH_ACTION = Operation.ACTION("publish");
    private final VirtualHost<?> _virtualHost;
    private final DeletedChildListener _deletedChildListener = new DeletedChildListener();
    private final AccessControlContext _immediateDeliveryContext;
    @ManagedAttributeField(beforeSet="preSetAlternateExchange", afterSet="postSetAlternateExchange")
    private Exchange _alternateExchange;
    private final QueueConsumerList _consumerList = new QueueConsumerList();
    private volatile QueueConsumer<?> _exclusiveSubscriber;
    private final AtomicInteger _atomicQueueCount = new AtomicInteger(0);
    private final AtomicLong _atomicQueueSize = new AtomicLong(0L);
    private final AtomicLong _targetQueueSize = new AtomicLong(102400L);
    private final AtomicInteger _activeSubscriberCount = new AtomicInteger();
    private final AtomicLong _totalMessagesReceived = new AtomicLong();
    private final AtomicLong _dequeueCount = new AtomicLong();
    private final AtomicLong _dequeueSize = new AtomicLong();
    private final AtomicLong _enqueueCount = new AtomicLong();
    private final AtomicLong _enqueueSize = new AtomicLong();
    private final AtomicLong _persistentMessageEnqueueSize = new AtomicLong();
    private final AtomicLong _persistentMessageDequeueSize = new AtomicLong();
    private final AtomicLong _persistentMessageEnqueueCount = new AtomicLong();
    private final AtomicLong _persistentMessageDequeueCount = new AtomicLong();
    private final AtomicLong _unackedMsgCount = new AtomicLong(0L);
    private final AtomicLong _unackedMsgBytes = new AtomicLong();
    private final AtomicInteger _bindingCountHigh = new AtomicInteger();
    @ManagedAttributeField(afterSet="updateAlertChecks")
    private long _alertThresholdMessageSize;
    @ManagedAttributeField(afterSet="updateAlertChecks")
    private long _alertThresholdQueueDepthMessages;
    @ManagedAttributeField(afterSet="updateAlertChecks")
    private long _alertThresholdQueueDepthBytes;
    @ManagedAttributeField(afterSet="updateAlertChecks")
    private long _alertThresholdMessageAge;
    @ManagedAttributeField
    private long _alertRepeatGap;
    @ManagedAttributeField
    private long _queueFlowControlSizeBytes;
    @ManagedAttributeField(afterSet="checkCapacity")
    private long _queueFlowResumeSizeBytes;
    @ManagedAttributeField
    private ExclusivityPolicy _exclusive;
    @ManagedAttributeField
    private MessageDurability _messageDurability;
    @ManagedAttributeField
    private Map<String, Map<String, List<String>>> _defaultFilters;
    private Object _exclusiveOwner;
    private final Set<NotificationCheck> _notificationChecks = Collections.synchronizedSet(EnumSet.noneOf(NotificationCheck.class));
    private volatile int _maxAsyncDeliveries;
    private volatile long _estimatedAverageMessageHeaderSize;
    private final AtomicLong _stateChangeCount = new AtomicLong(Long.MIN_VALUE);
    private AtomicInteger _deliveredMessages = new AtomicInteger();
    private AtomicBoolean _stopped = new AtomicBoolean(false);
    private final Set<AMQSessionModel> _blockedChannels = new ConcurrentSkipListSet<AMQSessionModel>();
    private final AtomicBoolean _deleted = new AtomicBoolean(false);
    private final SettableFuture<Integer> _deleteFuture = SettableFuture.create();
    private final List<Action<? super X>> _deleteTaskList = new CopyOnWriteArrayList<Action<? super X>>();
    private LogSubject _logSubject;
    @ManagedAttributeField
    private boolean _noLocal;
    private final AtomicBoolean _overfull = new AtomicBoolean(false);
    private final FlowToDiskChecker _flowToDiskChecker = new FlowToDiskChecker();
    private final CopyOnWriteArrayList<Binding<?>> _bindings = new CopyOnWriteArrayList();
    private Map<String, Object> _arguments;
    @ManagedAttributeField
    private int _maximumDeliveryAttempts;
    private MessageGroupManager _messageGroupManager;
    private QueueNotificationListener _notificationListener = NULL_NOTIFICATION_LISTENER;
    private final long[] _lastNotificationTimes = new long[NotificationCheck.values().length];
    @ManagedAttributeField
    private String _messageGroupKey;
    @ManagedAttributeField
    private boolean _messageGroupSharedGroups;
    @ManagedAttributeField
    private String _messageGroupDefaultGroup;
    @ManagedAttributeField
    private int _maximumDistinctGroups;
    @ManagedAttributeField
    private long _minimumMessageTtl;
    @ManagedAttributeField
    private long _maximumMessageTtl;
    @ManagedAttributeField
    private boolean _ensureNondestructiveConsumers;
    @ManagedAttributeField
    private volatile boolean _holdOnPublishEnabled;
    private static final int RECOVERING = 1;
    private static final int COMPLETING_RECOVERY = 2;
    private static final int RECOVERED = 3;
    private final AtomicInteger _recovering = new AtomicInteger(1);
    private final AtomicInteger _enqueuingWhileRecovering = new AtomicInteger(0);
    private final ConcurrentLinkedQueue<EnqueueRequest> _postRecoveryQueue = new ConcurrentLinkedQueue();
    private final QueueRunner _queueRunner;
    private boolean _closing;
    private final ConcurrentMap<String, Callable<MessageFilter>> _defaultFiltersMap = new ConcurrentHashMap<String, Callable<MessageFilter>>();
    private final List<HoldMethod> _holdMethods = new CopyOnWriteArrayList<HoldMethod>();
    private Map<String, String> _mimeTypeToFileExtension = Collections.emptyMap();
    private volatile boolean _hasPullOnlyConsumers;
    private long _flowToDiskThreshold;
    private static final String[] NON_NEGATIVE_NUMBERS = new String[]{"alertRepeatGap", "alertThresholdMessageAge", "alertThresholdMessageSize", "alertThresholdQueueDepthMessages", "alertThresholdQueueDepthBytes", "queueFlowControlSizeBytes", "queueFlowResumeSizeBytes", "maximumDeliveryAttempts"};

    protected AbstractQueue(Map<String, Object> attributes, VirtualHost<?> virtualHost) {
        super(AbstractQueue.parentsMap(virtualHost), attributes);
        this._virtualHost = virtualHost;
        this._immediateDeliveryContext = this.getSystemTaskControllerContext("Immediate Delivery", virtualHost.getPrincipal());
        this._queueRunner = new QueueRunner(this, this.getSystemTaskControllerContext("Queue Delivery", virtualHost.getPrincipal()));
    }

    @Override
    protected void onCreate() {
        super.onCreate();
        if (this.isDurable() && (this.getLifetimePolicy() == LifetimePolicy.DELETE_ON_CONNECTION_CLOSE || this.getLifetimePolicy() == LifetimePolicy.DELETE_ON_SESSION_END)) {
            Subject.doAs(this.getSubjectWithAddedSystemRights(), new PrivilegedAction<Object>(){

                @Override
                public Object run() {
                    AbstractQueue.this.setAttributes(Collections.singletonMap("durable", false));
                    return null;
                }
            });
        }
        if (!this.isDurable() && this.getMessageDurability() != MessageDurability.NEVER) {
            Subject.doAs(this.getSubjectWithAddedSystemRights(), new PrivilegedAction<Object>(){

                @Override
                public Object run() {
                    AbstractQueue.this.setAttributes(Collections.singletonMap("messageDurability", MessageDurability.NEVER));
                    return null;
                }
            });
        }
        this._recovering.set(3);
    }

    @Override
    public void onValidate() {
        super.onValidate();
        if (this._queueFlowResumeSizeBytes > this._queueFlowControlSizeBytes) {
            throw new IllegalConfigurationException("Flow resume size can't be greater than flow control size");
        }
    }

    /*
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    @Override
    protected void onOpen() {
        AMQSessionModel sessionModel;
        block22: {
            String owner;
            Map<String, Object> attributes;
            block21: {
                Set sessionPrincipals;
                super.onOpen();
                attributes = this.getActualAttributes();
                LinkedHashMap<String, Object> arguments = new LinkedHashMap<String, Object>(attributes);
                arguments.put("exclusive", (Object)this._exclusive);
                arguments.put("lifetimePolicy", (Object)this.getLifetimePolicy());
                this._arguments = Collections.synchronizedMap(arguments);
                this._logSubject = new QueueLogSubject(this);
                Subject activeSubject = Subject.getSubject(AccessController.getContext());
                Set<Object> set = sessionPrincipals = activeSubject == null ? Collections.emptySet() : activeSubject.getPrincipals(SessionPrincipal.class);
                if (sessionPrincipals.isEmpty()) {
                    sessionModel = null;
                } else {
                    SessionPrincipal sessionPrincipal = (SessionPrincipal)sessionPrincipals.iterator().next();
                    sessionModel = sessionPrincipal.getSession();
                }
                if (sessionModel == null) break block21;
                switch (this._exclusive) {
                    case PRINCIPAL: {
                        this._exclusiveOwner = sessionModel.getAMQPConnection().getAuthorizedPrincipal();
                        break block22;
                    }
                    case CONTAINER: {
                        this._exclusiveOwner = sessionModel.getAMQPConnection().getRemoteContainerName();
                        break block22;
                    }
                    case CONNECTION: {
                        this._exclusiveOwner = sessionModel.getAMQPConnection();
                        this.addExclusivityConstraint(sessionModel.getAMQPConnection());
                        break block22;
                    }
                    case SESSION: {
                        this._exclusiveOwner = sessionModel;
                        this.addExclusivityConstraint(sessionModel);
                        break block22;
                    }
                    case NONE: 
                    case LINK: {
                        break block22;
                    }
                    default: {
                        throw new ServerScopedRuntimeException("Unknown exclusivity policy: " + (Object)((Object)this._exclusive) + " this is a coding error inside Qpid");
                    }
                }
            }
            if (this._exclusive == ExclusivityPolicy.PRINCIPAL) {
                owner = MapValueConverter.getStringAttribute("owner", attributes, null);
                if (owner != null) {
                    GenericPrincipal ownerPrincipal;
                    try {
                        ownerPrincipal = new GenericPrincipal(owner);
                    }
                    catch (IllegalArgumentException e) {
                        ownerPrincipal = new GenericPrincipal(owner + "@('')");
                    }
                    this._exclusiveOwner = new AuthenticatedPrincipal(ownerPrincipal);
                }
            } else if (this._exclusive == ExclusivityPolicy.CONTAINER && (owner = MapValueConverter.getStringAttribute("owner", attributes, null)) != null) {
                this._exclusiveOwner = owner;
            }
        }
        if (this.getLifetimePolicy() == LifetimePolicy.DELETE_ON_CONNECTION_CLOSE) {
            if (sessionModel == null) throw new IllegalArgumentException("Queues created with a lifetime policy of " + (Object)((Object)this.getLifetimePolicy()) + " must be created from a connection.");
            this.addLifetimeConstraint(sessionModel.getAMQPConnection());
        } else if (this.getLifetimePolicy() == LifetimePolicy.DELETE_ON_SESSION_END) {
            if (sessionModel == null) throw new IllegalArgumentException("Queues created with a lifetime policy of " + (Object)((Object)this.getLifetimePolicy()) + " must be created from a connection.");
            this.addLifetimeConstraint(sessionModel);
        }
        this.getEventLogger().message(this._logSubject, this.getCreatedLogMessage());
        this._messageGroupManager = this.getMessageGroupKey() != null ? (this.isMessageGroupSharedGroups() ? new DefinedGroupMessageGroupManager(this.getMessageGroupKey(), this.getMessageGroupDefaultGroup(), this) : new AssignedConsumerMessageGroupManager(this.getMessageGroupKey(), this.getMaximumDistinctGroups())) : null;
        this._estimatedAverageMessageHeaderSize = this.getContextValue(Long.class, "queue.estimatedMessageMemoryOverhead");
        this._maxAsyncDeliveries = this.getContextValue(Integer.class, "queue.maxAsynchronousDeliveries");
        this._mimeTypeToFileExtension = this.getContextValue(Map.class, ParameterizedTypes.MAP_OF_STRING_STRING, "qpid.mimeTypeToFileExtension");
        this._flowToDiskThreshold = this.getAncestor(Broker.class).getFlowToDiskThreshold();
        if (this._defaultFilters != null) {
            QpidServiceLoader qpidServiceLoader = new QpidServiceLoader();
            Map<String, MessageFilterFactory> messageFilterFactories = qpidServiceLoader.getInstancesByType(MessageFilterFactory.class);
            for (Map.Entry<String, Map<String, List<String>>> entry : this._defaultFilters.entrySet()) {
                String name = String.valueOf(entry.getKey());
                Map<String, List<String>> filterValue = entry.getValue();
                if (filterValue.size() != 1) throw new IllegalArgumentException("Filter value should be a map with one entry, having the type as key and the value being the filter arguments, not " + filterValue);
                String filterTypeName = String.valueOf(filterValue.keySet().iterator().next());
                final MessageFilterFactory filterFactory = messageFilterFactories.get(filterTypeName);
                if (filterFactory == null) throw new IllegalArgumentException("Unknown filter type " + filterTypeName + ", known types are: " + messageFilterFactories.keySet());
                final List<String> filterArguments = filterValue.values().iterator().next();
                filterFactory.newInstance(filterArguments);
                this._defaultFiltersMap.put(name, new Callable<MessageFilter>(){

                    @Override
                    public MessageFilter call() {
                        return filterFactory.newInstance(filterArguments);
                    }
                });
            }
        }
        if (this.isHoldOnPublishEnabled()) {
            this._holdMethods.add(new HoldMethod(){

                @Override
                public boolean isHeld(MessageReference<?> messageReference, long evaluationTime) {
                    return messageReference.getMessage().getMessageHeader().getNotValidBefore() >= evaluationTime;
                }
            });
        }
        this.updateAlertChecks();
    }

    protected LogMessage getCreatedLogMessage() {
        String ownerString = this.getOwner();
        return QueueMessages.CREATED(this.getId().toString(), ownerString, 0, ownerString != null, this.getLifetimePolicy() != LifetimePolicy.PERMANENT, this.isDurable(), !this.isDurable(), false);
    }

    private void addLifetimeConstraint(Deletable<? extends Deletable> lifetimeObject) {
        Action<Deletable> deleteQueueTask = new Action<Deletable>(){

            @Override
            public void performAction(Deletable object) {
                Subject.doAs(AbstractQueue.this.getSubjectWithAddedSystemRights(), new PrivilegedAction<Void>(){

                    @Override
                    public Void run() {
                        AbstractQueue.this.delete();
                        return null;
                    }
                });
            }
        };
        lifetimeObject.addDeleteTask((Action<? extends Deletable>)deleteQueueTask);
        this.addDeleteTask(new DeleteDeleteTask(lifetimeObject, (Action<? super Deletable>)deleteQueueTask));
    }

    private void addExclusivityConstraint(Deletable<? extends Deletable> lifetimeObject) {
        ClearOwnerAction clearOwnerAction = new ClearOwnerAction(lifetimeObject);
        DeleteDeleteTask deleteDeleteTask = new DeleteDeleteTask(lifetimeObject, clearOwnerAction);
        clearOwnerAction.setDeleteTask(deleteDeleteTask);
        lifetimeObject.addDeleteTask(clearOwnerAction);
        this.addDeleteTask(deleteDeleteTask);
    }

    public void execute(String name, Runnable runnable, AccessControlContext context) {
        block3: {
            try {
                if (this._virtualHost.getState() != State.UNAVAILABLE) {
                    this._virtualHost.executeTask(name, runnable, context);
                }
            }
            catch (RejectedExecutionException ree) {
                if (this._stopped.get()) break block3;
                _logger.error("Unexpected rejected execution", (Throwable)ree);
                throw ree;
            }
        }
    }

    @Override
    public boolean isExclusive() {
        return this._exclusive != ExclusivityPolicy.NONE;
    }

    @Override
    public Exchange<?> getAlternateExchange() {
        return this._alternateExchange;
    }

    public void setAlternateExchange(Exchange<?> exchange) {
        this._alternateExchange = exchange;
    }

    private void postSetAlternateExchange() {
        if (this._alternateExchange != null) {
            this._alternateExchange.addReference(this);
        }
    }

    private void preSetAlternateExchange() {
        if (this._alternateExchange != null) {
            this._alternateExchange.removeReference(this);
        }
    }

    @Override
    public Map<String, Map<String, List<String>>> getDefaultFilters() {
        return this._defaultFilters;
    }

    @Override
    public final MessageDurability getMessageDurability() {
        return this._messageDurability;
    }

    @Override
    public long getMinimumMessageTtl() {
        return this._minimumMessageTtl;
    }

    @Override
    public long getMaximumMessageTtl() {
        return this._maximumMessageTtl;
    }

    @Override
    public boolean isEnsureNondestructiveConsumers() {
        return this._ensureNondestructiveConsumers;
    }

    @Override
    public boolean isHoldOnPublishEnabled() {
        return this._holdOnPublishEnabled;
    }

    @Override
    public Collection<String> getAvailableAttributes() {
        return new ArrayList<String>(this._arguments.keySet());
    }

    @Override
    public String getOwner() {
        if (this._exclusiveOwner != null) {
            switch (this._exclusive) {
                case CONTAINER: {
                    return (String)this._exclusiveOwner;
                }
                case PRINCIPAL: {
                    return ((Principal)this._exclusiveOwner).getName();
                }
            }
        }
        return null;
    }

    @Override
    public VirtualHost<?> getVirtualHost() {
        return this._virtualHost;
    }

    @Override
    public QueueConsumerImpl addConsumer(final ConsumerTarget target, final FilterManager filters, final Class<? extends ServerMessage> messageClass, final String consumerName, final EnumSet<ConsumerImpl.Option> optionSet, final Integer priority) throws MessageSource.ExistingExclusiveConsumer, MessageSource.ExistingConsumerPreventsExclusive, MessageSource.ConsumerAccessRefused {
        try {
            return this.getTaskExecutor().run(new Task<QueueConsumerImpl, Exception>(){

                @Override
                public QueueConsumerImpl execute() throws Exception {
                    return AbstractQueue.this.addConsumerInternal(target, filters, messageClass, consumerName, optionSet, priority);
                }

                @Override
                public String getObject() {
                    return AbstractQueue.this.toString();
                }

                @Override
                public String getAction() {
                    return "add consumer";
                }

                @Override
                public String getArguments() {
                    return "target=" + target + ", consumerName=" + consumerName + ", optionSet=" + optionSet;
                }
            });
        }
        catch (RuntimeException | MessageSource.ConsumerAccessRefused | MessageSource.ExistingConsumerPreventsExclusive | MessageSource.ExistingExclusiveConsumer e) {
            throw e;
        }
        catch (Exception e) {
            throw new ServerScopedRuntimeException(e);
        }
    }

    private QueueConsumerImpl addConsumerInternal(ConsumerTarget target, FilterManager filters, Class<? extends ServerMessage> messageClass, String consumerName, EnumSet<ConsumerImpl.Option> optionSet, Integer priority) throws MessageSource.ExistingExclusiveConsumer, MessageSource.ConsumerAccessRefused, MessageSource.ExistingConsumerPreventsExclusive {
        if (this.hasExclusiveConsumer()) {
            throw new MessageSource.ExistingExclusiveConsumer();
        }
        Object exclusiveOwner = this._exclusiveOwner;
        switch (this._exclusive) {
            case CONNECTION: {
                if (exclusiveOwner == null) {
                    exclusiveOwner = target.getSessionModel().getAMQPConnection();
                    this.addExclusivityConstraint(target.getSessionModel().getAMQPConnection());
                    break;
                }
                if (exclusiveOwner == target.getSessionModel().getAMQPConnection()) break;
                throw new MessageSource.ConsumerAccessRefused();
            }
            case SESSION: {
                if (exclusiveOwner == null) {
                    exclusiveOwner = target.getSessionModel();
                    this.addExclusivityConstraint(target.getSessionModel());
                    break;
                }
                if (exclusiveOwner == target.getSessionModel()) break;
                throw new MessageSource.ConsumerAccessRefused();
            }
            case LINK: {
                if (this.getConsumerCount() == 0) break;
                throw new MessageSource.ConsumerAccessRefused();
            }
            case PRINCIPAL: {
                Principal currentAuthorizedPrincipal = target.getSessionModel().getAMQPConnection().getAuthorizedPrincipal();
                if (exclusiveOwner == null) {
                    exclusiveOwner = currentAuthorizedPrincipal;
                    break;
                }
                if (Objects.equals(((Principal)exclusiveOwner).getName(), currentAuthorizedPrincipal.getName())) break;
                throw new MessageSource.ConsumerAccessRefused();
            }
            case CONTAINER: {
                if (exclusiveOwner == null) {
                    exclusiveOwner = target.getSessionModel().getAMQPConnection().getRemoteContainerName();
                    break;
                }
                if (exclusiveOwner.equals(target.getSessionModel().getAMQPConnection().getRemoteContainerName())) break;
                throw new MessageSource.ConsumerAccessRefused();
            }
            case NONE: {
                break;
            }
            default: {
                throw new ServerScopedRuntimeException("Unknown exclusivity policy " + (Object)((Object)this._exclusive));
            }
        }
        boolean exclusive = optionSet.contains((Object)ConsumerImpl.Option.EXCLUSIVE);
        boolean isTransient = optionSet.contains((Object)ConsumerImpl.Option.TRANSIENT);
        if (this._noLocal && !optionSet.contains((Object)ConsumerImpl.Option.NO_LOCAL)) {
            optionSet = EnumSet.copyOf(optionSet);
            optionSet.add(ConsumerImpl.Option.NO_LOCAL);
        }
        if (exclusive && this.getConsumerCount() != 0) {
            throw new MessageSource.ExistingConsumerPreventsExclusive();
        }
        if (!this._defaultFiltersMap.isEmpty()) {
            if (filters == null) {
                filters = new FilterManager();
            }
            for (Map.Entry filter : this._defaultFiltersMap.entrySet()) {
                MessageFilter f;
                if (filters.hasFilter((String)filter.getKey())) continue;
                try {
                    f = (MessageFilter)((Callable)filter.getValue()).call();
                }
                catch (Exception e) {
                    if (e instanceof RuntimeException) {
                        throw (RuntimeException)e;
                    }
                    throw new ServerScopedRuntimeException(e);
                }
                filters.add((String)filter.getKey(), f);
            }
        }
        if (this._ensureNondestructiveConsumers) {
            optionSet = EnumSet.copyOf(optionSet);
            optionSet.removeAll(EnumSet.of(ConsumerImpl.Option.SEES_REQUEUES, ConsumerImpl.Option.ACQUIRES));
        }
        QueueConsumerImpl consumer = new QueueConsumerImpl(this, target, consumerName, filters, messageClass, optionSet, priority);
        this._exclusiveOwner = exclusiveOwner;
        target.consumerAdded(consumer);
        if (exclusive && !isTransient) {
            this._exclusiveSubscriber = consumer;
        }
        if (consumer.isActive()) {
            this._activeSubscriberCount.incrementAndGet();
        }
        consumer.setStateListener(this);
        QueueContext queueContext = filters == null || !filters.startAtTail() ? new QueueContext(this.getEntries().getHead()) : new QueueContext(this.getEntries().getTail());
        consumer.setQueueContext(queueContext);
        if (!this.isDeleted()) {
            if (consumer.isPullOnly()) {
                this._hasPullOnlyConsumers = true;
            }
            this._consumerList.add(consumer);
            if (this.isDeleted()) {
                consumer.queueDeleted();
            }
        }
        this.childAdded(consumer);
        consumer.addChangeListener(this._deletedChildListener);
        if (consumer.isPullOnly()) {
            consumer.getSessionModel().getAMQPConnection().notifyWork();
        } else {
            this.deliverAsync();
        }
        return consumer;
    }

    @Override
    protected ListenableFuture<Void> beforeClose() {
        this._closing = true;
        return super.beforeClose();
    }

    void unregisterConsumer(QueueConsumerImpl consumer) {
        if (consumer == null) {
            throw new NullPointerException("consumer argument is null");
        }
        boolean removed = this._consumerList.remove(consumer);
        if (removed) {
            consumer.closeAsync();
            this.setExclusiveSubscriber(null);
            consumer.setQueueContext(null);
            if (this._exclusive == ExclusivityPolicy.LINK) {
                this._exclusiveOwner = null;
            }
            if (this._messageGroupManager != null) {
                this.resetSubPointersForGroups(consumer);
            }
            if (consumer.isPullOnly()) {
                boolean hasOnlyPushConsumers = true;
                for (ConsumerNode consumerNode = this._consumerList.getHead().findNext(); consumerNode != null && hasOnlyPushConsumers; consumerNode = consumerNode.findNext()) {
                    hasOnlyPushConsumers = !consumerNode.getConsumer().isPullOnly();
                }
                boolean bl = this._hasPullOnlyConsumers = !hasOnlyPushConsumers;
            }
            if (!(consumer.isTransient() || this.getLifetimePolicy() != LifetimePolicy.DELETE_ON_NO_OUTBOUND_LINKS && this.getLifetimePolicy() != LifetimePolicy.DELETE_ON_NO_LINKS || this.getConsumerCount() != 0 || consumer.isDurable() && this._closing)) {
                _logger.debug("Auto-deleting queue: {}", (Object)this);
                Subject.doAs(this.getSubjectWithAddedSystemRights(), new PrivilegedAction<Object>(){

                    @Override
                    public Object run() {
                        AbstractQueue.this.delete();
                        return null;
                    }
                });
                consumer.queueDeleted();
            }
        }
    }

    @Override
    public Collection<QueueConsumer<?>> getConsumers() {
        ArrayList consumers = new ArrayList();
        ConsumerNodeIterator iter = this._consumerList.iterator();
        while (iter.advance()) {
            consumers.add(iter.getNode().getConsumer());
        }
        return consumers;
    }

    public void resetSubPointersForGroups(QueueConsumer<?> consumer) {
        QueueEntry entry = this._messageGroupManager.findEarliestAssignedAvailableEntry(consumer);
        this._messageGroupManager.clearAssignments(consumer);
        if (entry != null) {
            this.resetSubPointersForGroups(entry);
        }
    }

    @Override
    public void resetSubPointersForGroups(QueueEntry entry) {
        ConsumerNodeIterator subscriberIter = this._consumerList.iterator();
        while (subscriberIter.advance()) {
            QueueConsumer<?> sub = subscriberIter.getNode().getConsumer();
            if (!sub.seesRequeues()) continue;
            this.updateSubRequeueEntry(sub, entry);
        }
        this.notifyPullOnlyConsumers();
        this.deliverAsync();
    }

    @Override
    public void addBinding(Binding<?> binding) {
        int bindingCountHigh;
        this._bindings.add(binding);
        int bindingCount = this._bindings.size();
        while (bindingCount > (bindingCountHigh = this._bindingCountHigh.get()) && !this._bindingCountHigh.compareAndSet(bindingCountHigh, bindingCount)) {
        }
        this.childAdded(binding);
    }

    @Override
    public void removeBinding(Binding<?> binding) {
        this._bindings.remove(binding);
        this.childRemoved(binding);
    }

    @Override
    public Collection<Binding<?>> getBindings() {
        return Collections.unmodifiableList(this._bindings);
    }

    @Override
    public int getBindingCount() {
        return this.getBindings().size();
    }

    @Override
    public LogSubject getLogSubject() {
        return this._logSubject;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public final void enqueue(ServerMessage message, Action<? super MessageInstance> action, MessageEnqueueRecord enqueueRecord) {
        this.incrementQueueCount();
        this.incrementQueueSize(message);
        this._totalMessagesReceived.incrementAndGet();
        if (this._recovering.get() != 3) {
            boolean addedToRecoveryQueue;
            this._enqueuingWhileRecovering.incrementAndGet();
            try {
                addedToRecoveryQueue = this._recovering.get() == 1;
                if (addedToRecoveryQueue) {
                    this._postRecoveryQueue.add(new EnqueueRequest(message, action, enqueueRecord));
                }
            }
            finally {
                this._enqueuingWhileRecovering.decrementAndGet();
            }
            if (!addedToRecoveryQueue) {
                while (this._recovering.get() != 3) {
                    Thread.yield();
                }
                this.doEnqueue(message, action, enqueueRecord);
            }
        } else {
            this.doEnqueue(message, action, enqueueRecord);
        }
        long estimatedQueueSize = this._atomicQueueSize.get() + (long)this._atomicQueueCount.get() * this._estimatedAverageMessageHeaderSize;
        this._flowToDiskChecker.flowToDiskIfNecessary(message.getStoredMessage(), estimatedQueueSize, this._targetQueueSize.get());
    }

    @Override
    public final void recover(ServerMessage message, MessageEnqueueRecord enqueueRecord) {
        this.incrementQueueCount();
        this.incrementQueueSize(message);
        this._totalMessagesReceived.incrementAndGet();
        this.doEnqueue(message, null, enqueueRecord);
    }

    @Override
    public final void completeRecovery() {
        if (this._recovering.compareAndSet(1, 2)) {
            while (this._enqueuingWhileRecovering.get() != 0) {
                Thread.yield();
            }
            this.enqueueFromPostRecoveryQueue();
            this._recovering.set(3);
        }
    }

    private void enqueueFromPostRecoveryQueue() {
        while (!this._postRecoveryQueue.isEmpty()) {
            EnqueueRequest request = this._postRecoveryQueue.poll();
            MessageReference<?> messageReference = request.getMessage();
            this.doEnqueue((ServerMessage)messageReference.getMessage(), request.getAction(), request.getEnqueueRecord());
            messageReference.release();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    protected void doEnqueue(ServerMessage message, Action<? super MessageInstance> action, MessageEnqueueRecord enqueueRecord) {
        QueueConsumer<?> exclusiveSub = this._exclusiveSubscriber;
        final QueueEntry entry = this.getEntries().add(message, enqueueRecord);
        this.updateExpiration(entry);
        try {
            if (action != null || exclusiveSub == null && this._queueRunner.isIdle()) {
                AccessController.doPrivileged(new PrivilegedAction<Void>(){

                    @Override
                    public Void run() {
                        AbstractQueue.this.tryDeliverStraightThrough(entry);
                        return null;
                    }
                }, this._immediateDeliveryContext);
            }
            if (entry.isAvailable()) {
                this.checkConsumersNotAheadOfDelivery(entry);
                this.notifyPullOnlyConsumers();
                this.deliverAsync();
            }
            this.checkForNotificationOnNewMessage(entry.getMessage());
        }
        finally {
            if (action != null) {
                action.performAction(entry);
            }
        }
    }

    private void updateExpiration(QueueEntry entry) {
        long calculatedExpiration;
        long expiration = entry.getMessage().getExpiration();
        long arrivalTime = entry.getMessage().getArrivalTime();
        if (this._minimumMessageTtl != 0L) {
            if (arrivalTime == 0L) {
                arrivalTime = System.currentTimeMillis();
            }
            if (expiration != 0L && (calculatedExpiration = arrivalTime + this._minimumMessageTtl) > expiration) {
                entry.setExpiration(calculatedExpiration);
                expiration = calculatedExpiration;
            }
        }
        if (this._maximumMessageTtl != 0L) {
            if (arrivalTime == 0L) {
                arrivalTime = System.currentTimeMillis();
            }
            calculatedExpiration = arrivalTime + this._maximumMessageTtl;
            if (expiration == 0L || expiration > calculatedExpiration) {
                entry.setExpiration(calculatedExpiration);
            }
        }
    }

    private void tryDeliverStraightThrough(QueueEntry entry) {
        try {
            ConsumerNode node = this._consumerList.getMarkedNode();
            ConsumerNode nextNode = node.findNext();
            if (nextNode == null) {
                nextNode = this._consumerList.getHead().findNext();
            }
            while (nextNode != null && !this._consumerList.updateMarkedNode(node, nextNode)) {
                node = this._consumerList.getMarkedNode();
                nextNode = node.findNext();
                if (nextNode != null) continue;
                nextNode = this._consumerList.getHead().findNext();
            }
            int loops = 2;
            while (entry.isAvailable() && loops != 0) {
                if (nextNode == null) {
                    --loops;
                    nextNode = this._consumerList.getHead();
                } else {
                    QueueConsumer<?> sub = nextNode.getConsumer();
                    if (sub.getPriority() == Integer.MAX_VALUE) {
                        this.deliverToConsumer(sub, entry);
                    }
                }
                nextNode = nextNode.findNext();
            }
        }
        catch (ConnectionScopedRuntimeException | TransportException e) {
            String errorMessage = "Suppressing " + e.getClass().getSimpleName() + " during straight through delivery, as this" + " can only indicate an issue with a consumer.";
            if (_logger.isDebugEnabled()) {
                _logger.debug(errorMessage, e);
            }
            _logger.info(errorMessage + ' ' + e.getMessage());
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void deliverToConsumer(QueueConsumer<?> sub, QueueEntry entry) {
        block10: {
            if (sub.trySendLock()) {
                try {
                    if (this.getNextAvailableEntry(sub) != entry || sub.isSuspended() || !sub.hasInterest(entry) || !this.mightAssign(sub, entry) || sub.wouldSuspend(entry)) break block10;
                    MessageReference messageReference = null;
                    try {
                        if (sub.acquires() && !this.assign(sub, entry) || !sub.acquires() && (messageReference = entry.newMessageReference()) == null) {
                            sub.restoreCredit(entry);
                        } else {
                            this.deliverMessage(sub, entry, false, true);
                        }
                    }
                    finally {
                        if (messageReference != null) {
                            messageReference.release();
                        }
                    }
                }
                finally {
                    sub.releaseSendLock();
                }
            }
        }
    }

    private boolean assign(QueueConsumer<?> sub, QueueEntry entry) {
        if (this._messageGroupManager == null) {
            return entry.acquire(sub);
        }
        return this._messageGroupManager.acceptMessage(sub, entry);
    }

    private boolean mightAssign(QueueConsumer sub, QueueEntry entry) {
        return this._messageGroupManager == null || !sub.acquires() || this._messageGroupManager.mightAssign(entry, sub);
    }

    protected void checkConsumersNotAheadOfDelivery(QueueEntry entry) {
    }

    private void incrementQueueSize(ServerMessage message) {
        long size = message.getSize();
        this.getAtomicQueueSize().addAndGet(size);
        this._enqueueCount.incrementAndGet();
        this._enqueueSize.addAndGet(size);
        if (message.isPersistent() && this.isDurable()) {
            this._persistentMessageEnqueueSize.addAndGet(size);
            this._persistentMessageEnqueueCount.incrementAndGet();
        }
    }

    @Override
    public void setTargetSize(long targetSize) {
        if (this._targetQueueSize.compareAndSet(this._targetQueueSize.get(), targetSize)) {
            _logger.debug("Queue '{}' target size : {}", (Object)this.getName(), (Object)targetSize);
        }
    }

    @Override
    public long getTotalDequeuedMessages() {
        return this._dequeueCount.get();
    }

    @Override
    public long getTotalEnqueuedMessages() {
        return this._enqueueCount.get();
    }

    private void incrementQueueCount() {
        this.getAtomicQueueCount().incrementAndGet();
    }

    private void deliverMessage(QueueConsumer<?> sub, QueueEntry entry, boolean batch, boolean updateLastSeen) {
        if (updateLastSeen) {
            this.setLastSeenEntry(sub, entry);
        }
        this._deliveredMessages.incrementAndGet();
        sub.send(entry, batch);
    }

    private void setLastSeenEntry(QueueConsumer<?> sub, QueueEntry entry) {
        QueueContext subContext = sub.getQueueContext();
        if (subContext != null) {
            QueueEntry releasedEntry = subContext.getReleasedEntry();
            QueueContext._lastSeenUpdater.set(subContext, entry);
            if (releasedEntry == entry) {
                QueueContext._releasedUpdater.compareAndSet(subContext, releasedEntry, null);
            }
        }
    }

    private void updateSubRequeueEntry(QueueConsumer<?> sub, QueueEntry entry) {
        block1: {
            QueueEntry oldEntry;
            QueueContext subContext = sub.getQueueContext();
            if (subContext == null) break block1;
            while (!((oldEntry = subContext.getReleasedEntry()) != null && oldEntry.compareTo(entry) <= 0 || QueueContext._releasedUpdater.compareAndSet(subContext, oldEntry, entry))) {
            }
        }
    }

    @Override
    public void requeue(QueueEntry entry) {
        ConsumerNodeIterator subscriberIter = this._consumerList.iterator();
        while (subscriberIter.advance() && entry.isAvailable()) {
            QueueConsumer<?> sub = subscriberIter.getNode().getConsumer();
            if (!sub.seesRequeues()) continue;
            this.updateSubRequeueEntry(sub, entry);
        }
        this.notifyPullOnlyConsumers();
        this.deliverAsync();
    }

    @Override
    public void dequeue(QueueEntry entry) {
        this.decrementQueueCount();
        this.decrementQueueSize(entry);
        if (entry.acquiredByConsumer()) {
            this._deliveredMessages.decrementAndGet();
        }
        this.checkCapacity();
    }

    private void decrementQueueSize(QueueEntry entry) {
        ServerMessage message = entry.getMessage();
        long size = message.getSize();
        this.getAtomicQueueSize().addAndGet(-size);
        this._dequeueSize.addAndGet(size);
        if (message.isPersistent() && this.isDurable()) {
            this._persistentMessageDequeueSize.addAndGet(size);
            this._persistentMessageDequeueCount.incrementAndGet();
        }
    }

    void decrementQueueCount() {
        this.getAtomicQueueCount().decrementAndGet();
        this._dequeueCount.incrementAndGet();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public boolean resend(QueueEntry entry, QueueConsumer<?> consumer) {
        consumer.getSendLock();
        try {
            if (!consumer.isClosed()) {
                this.deliverMessage(consumer, entry, false, false);
                boolean bl = true;
                return bl;
            }
            boolean bl = false;
            return bl;
        }
        finally {
            consumer.releaseSendLock();
        }
    }

    @Override
    public int getConsumerCount() {
        return this._consumerList.size();
    }

    @Override
    public int getConsumerCountWithCredit() {
        return this._activeSubscriberCount.get();
    }

    @Override
    public boolean isUnused() {
        return this.getConsumerCount() == 0;
    }

    @Override
    public boolean isEmpty() {
        return this.getQueueDepthMessages() == 0;
    }

    @Override
    public int getQueueDepthMessages() {
        return this.getAtomicQueueCount().get();
    }

    @Override
    public long getQueueDepthBytes() {
        return this.getAtomicQueueSize().get();
    }

    public int getUndeliveredMessageCount() {
        int count = this.getQueueDepthMessages() - this._deliveredMessages.get();
        if (count < 0) {
            return 0;
        }
        return count;
    }

    public long getReceivedMessageCount() {
        return this._totalMessagesReceived.get();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public long getOldestMessageArrivalTime() {
        long oldestMessageArrivalTime = -1L;
        while (oldestMessageArrivalTime == -1L) {
            QueueEntry entry = this.getEntries().getOldestEntry();
            if (entry != null) {
                ServerMessage message = entry.getMessage();
                if (message == null) continue;
                try {
                    MessageReference reference = message.newReference();
                    try {
                        oldestMessageArrivalTime = reference.getMessage().getArrivalTime();
                    }
                    finally {
                        reference.release();
                    }
                }
                catch (MessageDeletedException messageDeletedException) {}
                continue;
            }
            oldestMessageArrivalTime = 0L;
        }
        return oldestMessageArrivalTime;
    }

    @Override
    public long getOldestMessageAge() {
        long oldestMessageArrivalTime = this.getOldestMessageArrivalTime();
        return oldestMessageArrivalTime == 0L ? 0L : System.currentTimeMillis() - oldestMessageArrivalTime;
    }

    @Override
    public boolean isDeleted() {
        return this._deleted.get();
    }

    @Override
    public List<QueueEntry> getMessagesOnTheQueue() {
        ArrayList<QueueEntry> entryList = new ArrayList<QueueEntry>();
        QueueEntryIterator queueListIterator = this.getEntries().iterator();
        while (queueListIterator.advance()) {
            QueueEntry node = queueListIterator.getNode();
            if (node == null || node.isDeleted()) continue;
            entryList.add(node);
        }
        return entryList;
    }

    @Override
    public void stateChanged(QueueConsumer<?> sub, State oldState, State newState) {
        if (oldState == State.ACTIVE && newState != State.ACTIVE) {
            this._activeSubscriberCount.decrementAndGet();
        } else if (newState == State.ACTIVE) {
            if (oldState != State.ACTIVE) {
                this._activeSubscriberCount.incrementAndGet();
                if (sub.isPullOnly()) {
                    sub.getSessionModel().getAMQPConnection().notifyWork();
                }
            }
            if (!sub.isPullOnly()) {
                this.deliverAsync();
            }
        }
    }

    @Override
    public int compareTo(X o) {
        return this.getName().compareTo(((AbstractConfiguredObject)o).getName());
    }

    public AtomicInteger getAtomicQueueCount() {
        return this._atomicQueueCount;
    }

    public AtomicLong getAtomicQueueSize() {
        return this._atomicQueueSize;
    }

    private boolean hasExclusiveConsumer() {
        return this._exclusiveSubscriber != null;
    }

    private void setExclusiveSubscriber(QueueConsumer<?> exclusiveSubscriber) {
        this._exclusiveSubscriber = exclusiveSubscriber;
    }

    long getStateChangeCount() {
        return this._stateChangeCount.get();
    }

    abstract QueueEntryList getEntries();

    protected QueueConsumerList getConsumerList() {
        return this._consumerList;
    }

    public EventLogger getEventLogger() {
        return this._virtualHost.getEventLogger();
    }

    public List<QueueEntry> getMessagesOnTheQueue(final long fromMessageId, final long toMessageId) {
        return this.getMessagesOnTheQueue(new QueueEntryFilter(){

            @Override
            public boolean accept(QueueEntry entry) {
                long messageId = entry.getMessage().getMessageNumber();
                return messageId >= fromMessageId && messageId <= toMessageId;
            }

            @Override
            public boolean filterComplete() {
                return false;
            }
        });
    }

    @Override
    public QueueEntry getMessageOnTheQueue(final long messageId) {
        List<QueueEntry> entries = this.getMessagesOnTheQueue(new QueueEntryFilter(){
            private boolean _complete;

            @Override
            public boolean accept(QueueEntry entry) {
                this._complete = entry.getMessage().getMessageNumber() == messageId;
                return this._complete;
            }

            @Override
            public boolean filterComplete() {
                return this._complete;
            }
        });
        return entries.isEmpty() ? null : entries.get(0);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public List<QueueEntry> getMessagesOnTheQueue(QueueEntryFilter filter) {
        ArrayList<QueueEntry> entryList = new ArrayList<QueueEntry>();
        QueueEntryIterator queueListIterator = this.getEntries().iterator();
        while (queueListIterator.advance() && !filter.filterComplete()) {
            QueueEntry node = queueListIterator.getNode();
            MessageReference reference = node.newMessageReference();
            if (reference == null) continue;
            try {
                if (node.isDeleted() || !filter.accept(node)) continue;
                entryList.add(node);
            }
            finally {
                reference.release();
            }
        }
        return entryList;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void visit(QueueEntryVisitor visitor) {
        QueueEntryIterator queueListIterator = this.getEntries().iterator();
        while (queueListIterator.advance()) {
            QueueEntry node = queueListIterator.getNode();
            MessageReference reference = node.newMessageReference();
            if (reference == null) continue;
            try {
                boolean done = !node.isDeleted() && visitor.visit(node);
                if (!done) continue;
                break;
            }
            finally {
                reference.release();
            }
        }
    }

    @Override
    public List<QueueEntry> getMessagesRangeOnTheQueue(final long fromPosition, final long toPosition) {
        return this.getMessagesOnTheQueue(new QueueEntryFilter(){
            private long position = 0L;

            @Override
            public boolean accept(QueueEntry entry) {
                ++this.position;
                return this.position >= fromPosition && this.position <= toPosition;
            }

            @Override
            public boolean filterComplete() {
                return this.position >= toPosition;
            }
        });
    }

    @Override
    public long clearQueue() {
        QueueEntryIterator queueListIterator = this.getEntries().iterator();
        long count = 0L;
        LocalTransaction txn = new LocalTransaction(this.getVirtualHost().getMessageStore());
        while (queueListIterator.advance()) {
            final QueueEntry node = queueListIterator.getNode();
            boolean acquired = node.acquireOrSteal(new Runnable(){

                @Override
                public void run() {
                    AbstractQueue.this.dequeueEntry(node);
                }
            });
            if (!acquired) continue;
            this.dequeueEntry(node, txn);
        }
        txn.commit();
        return count;
    }

    private void dequeueEntry(QueueEntry node) {
        AutoCommitTransaction txn = new AutoCommitTransaction(this.getVirtualHost().getMessageStore());
        this.dequeueEntry(node, txn);
    }

    private void dequeueEntry(final QueueEntry node, ServerTransaction txn) {
        txn.dequeue(node.getEnqueueRecord(), new ServerTransaction.Action(){

            @Override
            public void postCommit() {
                node.delete();
            }

            @Override
            public void onRollback() {
            }
        });
    }

    @Override
    public void addDeleteTask(Action<? super X> task) {
        this._deleteTaskList.add(task);
    }

    @Override
    public void removeDeleteTask(Action<? super X> task) {
        this._deleteTaskList.remove(task);
    }

    @Override
    public int deleteAndReturnCount() {
        return this.doSync(this.deleteAndReturnCountAsync());
    }

    @Override
    public ListenableFuture<Integer> deleteAndReturnCountAsync() {
        this.authorise(Operation.DELETE);
        if (this._deleted.compareAndSet(false, true)) {
            final int queueDepthMessages = this.getQueueDepthMessages();
            final ArrayList removeBindingFutures = new ArrayList(this._bindings.size());
            final ArrayList bindingCopy = new ArrayList(this._bindings);
            Subject.doAs(this.getSubjectWithAddedSystemRights(), new PrivilegedAction<Void>(){

                @Override
                public Void run() {
                    for (Binding binding : bindingCopy) {
                        removeBindingFutures.add(binding.deleteAsync());
                    }
                    return null;
                }
            });
            ListenableFuture combinedFuture = Futures.allAsList(removeBindingFutures);
            AbstractQueue.addFutureCallback(combinedFuture, new FutureCallback<List<Void>>(){

                public void onSuccess(List<Void> result) {
                    try {
                        ConsumerNodeIterator consumerNodeIterator = AbstractQueue.this._consumerList.iterator();
                        while (consumerNodeIterator.advance()) {
                            QueueConsumer<?> s = consumerNodeIterator.getNode().getConsumer();
                            if (s == null) continue;
                            s.queueDeleted();
                        }
                        List<QueueEntry> entries = AbstractQueue.this.getMessagesOnTheQueue(new AcquireAllQueueEntryFilter());
                        AbstractQueue.this.routeToAlternate(entries);
                        AbstractQueue.this.preSetAlternateExchange();
                        AbstractQueue.this._alternateExchange = null;
                        AbstractQueue.this.performQueueDeleteTasks();
                        AbstractQueue.this.deleted();
                        AbstractQueue.this.getEventLogger().message(AbstractQueue.this._logSubject, QueueMessages.DELETED(AbstractQueue.this.getId().toString()));
                        AbstractQueue.this._deleteFuture.set((Object)queueDepthMessages);
                        AbstractQueue.this.setState(State.DELETED);
                    }
                    catch (Throwable e) {
                        AbstractQueue.this._deleteFuture.setException(e);
                    }
                }

                public void onFailure(Throwable t) {
                    AbstractQueue.this._deleteFuture.setException(t);
                }
            }, this.getTaskExecutor());
        }
        return this._deleteFuture;
    }

    private void routeToAlternate(List<QueueEntry> entries) {
        LocalTransaction txn = new LocalTransaction(this.getVirtualHost().getMessageStore());
        for (QueueEntry entry : entries) {
            int requeues = entry.routeToAlternate(null, txn);
            if (requeues != 0) continue;
        }
        txn.commit();
    }

    private void performQueueDeleteTasks() {
        for (Action<X> task : this._deleteTaskList) {
            task.performAction(this);
        }
        this._deleteTaskList.clear();
    }

    @Override
    protected void onClose() {
        super.onClose();
        this._stopped.set(true);
        this._closing = false;
    }

    @Override
    public void checkCapacity(AMQSessionModel channel) {
        if (this._queueFlowControlSizeBytes != 0L && this._atomicQueueSize.get() > this._queueFlowControlSizeBytes) {
            this._overfull.set(true);
            this.getEventLogger().message(this._logSubject, QueueMessages.OVERFULL(this._atomicQueueSize.get(), this._queueFlowControlSizeBytes));
            this._blockedChannels.add(channel);
            channel.block(this);
            if (this._atomicQueueSize.get() <= this._queueFlowResumeSizeBytes) {
                this.getEventLogger().message(this._logSubject, QueueMessages.UNDERFULL(this._atomicQueueSize.get(), this._queueFlowResumeSizeBytes));
                channel.unblock(this);
                this._blockedChannels.remove(channel);
            }
        }
    }

    private void checkCapacity() {
        if (this._queueFlowControlSizeBytes != 0L && this._overfull.get() && this._atomicQueueSize.get() <= this._queueFlowResumeSizeBytes) {
            if (this._overfull.compareAndSet(true, false)) {
                this.getEventLogger().message(this._logSubject, QueueMessages.UNDERFULL(this._atomicQueueSize.get(), this._queueFlowResumeSizeBytes));
            }
            for (AMQSessionModel blockedChannel : this._blockedChannels) {
                blockedChannel.unblock(this);
                this._blockedChannels.remove(blockedChannel);
            }
        }
    }

    @Override
    public void deliverAsync() {
        this._stateChangeCount.incrementAndGet();
        this._queueRunner.execute();
    }

    void notifyPullOnlyConsumers() {
        if (this._hasPullOnlyConsumers) {
            for (ConsumerNode consumerNode = this._consumerList.getHead().findNext(); consumerNode != null; consumerNode = consumerNode.findNext()) {
                QueueConsumer<?> consumer = consumerNode.getConsumer();
                if (!consumer.isActive() || !consumer.isPullOnly() || this.getNextAvailableEntry(consumer) == null) continue;
                consumer.getSessionModel().getAMQPConnection().notifyWork();
            }
        }
    }

    void flushConsumer(QueueConsumer<?> sub) {
        this.flushConsumer(sub, Long.MAX_VALUE);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    boolean flushConsumer(QueueConsumer<?> sub, long iterations) {
        boolean atTail = false;
        boolean keepSendLockHeld = iterations <= (long)this.getMaxAsyncDeliveries();
        boolean queueEmpty = false;
        boolean deliveryAttempted = false;
        try {
            if (keepSendLockHeld) {
                sub.getSendLock();
            }
            while (!sub.isSuspended() && !atTail && iterations != 0L) {
                try {
                    if (!keepSendLockHeld) {
                        sub.getSendLock();
                    }
                    atTail = this.attemptDelivery(sub, true);
                    deliveryAttempted = true;
                    if (atTail && this.getNextAvailableEntry(sub) == null) {
                        queueEmpty = true;
                        continue;
                    }
                    if (atTail) continue;
                    --iterations;
                }
                finally {
                    if (keepSendLockHeld) continue;
                    sub.releaseSendLock();
                }
            }
            if (!deliveryAttempted) {
                this.getNextAvailableEntry(sub);
            }
        }
        finally {
            if (keepSendLockHeld) {
                sub.releaseSendLock();
            }
            if (queueEmpty) {
                sub.queueEmpty();
            }
            sub.flushBatched();
        }
        if (!this.hasExclusiveConsumer()) {
            this.advanceAllConsumers();
        }
        return atTail;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private boolean attemptDelivery(QueueConsumer<?> sub, boolean batch) {
        boolean subActive;
        boolean atTail = false;
        QueueEntry node = this.getNextAvailableEntry(sub);
        boolean bl = subActive = sub.isActive() && !sub.isSuspended();
        if (subActive && (sub.getPriority() == Integer.MAX_VALUE || this.noHigherPriorityWithCredit(sub))) {
            if (this._virtualHost.getState() != State.ACTIVE) {
                throw new ConnectionScopedRuntimeException("Delivery halted owing to virtualhost state " + (Object)((Object)this._virtualHost.getState()));
            }
            if (node != null && node.isAvailable() && sub.hasInterest(node) && this.mightAssign(sub, node)) {
                if (!sub.wouldSuspend(node)) {
                    MessageReference messageReference = null;
                    try {
                        if (sub.acquires() && !this.assign(sub, node) || !sub.acquires() && (messageReference = node.newMessageReference()) == null) {
                            sub.restoreCredit(node);
                        }
                        this.deliverMessage(sub, node, batch, true);
                    }
                    finally {
                        if (messageReference != null) {
                            messageReference.release();
                        }
                    }
                } else {
                    subActive = false;
                    sub.awaitCredit(node);
                }
            }
            atTail = node == null || this.getNextAvailableEntry(sub) == null;
        }
        return atTail || !subActive;
    }

    private boolean noHigherPriorityWithCredit(QueueConsumer<?> sub) {
        ConsumerNodeIterator iterator = this._consumerList.iterator();
        while (iterator.advance()) {
            ConsumerNode node = iterator.getNode();
            QueueConsumer<?> consumer = node.getConsumer();
            if (consumer.getPriority() <= sub.getPriority() || this.getNextAvailableEntry(consumer) == null || !consumer.hasCredit()) continue;
            return false;
        }
        return true;
    }

    protected void advanceAllConsumers() {
        ConsumerNodeIterator consumerNodeIterator = this._consumerList.iterator();
        while (consumerNodeIterator.advance()) {
            ConsumerNode subNode = consumerNodeIterator.getNode();
            QueueConsumer<?> sub = subNode.getConsumer();
            if (!sub.acquires()) continue;
            this.getNextAvailableEntry(sub);
        }
    }

    private QueueEntry getNextAvailableEntry(QueueConsumer sub) {
        QueueContext context = sub.getQueueContext();
        if (context != null) {
            QueueEntry lastSeen = context.getLastSeenEntry();
            QueueEntry releasedNode = context.getReleasedEntry();
            QueueEntry node = releasedNode != null && lastSeen.compareTo(releasedNode) >= 0 ? releasedNode : this.getEntries().next(lastSeen);
            boolean expired = false;
            while (!(node == null || node.isAvailable() && !(expired = node.expired()) && sub.hasInterest(node) && this.mightAssign(sub, node))) {
                if (expired) {
                    expired = false;
                    if (node.acquire()) {
                        this.dequeueEntry(node);
                    }
                }
                if (QueueContext._lastSeenUpdater.compareAndSet(context, lastSeen, node)) {
                    QueueContext._releasedUpdater.compareAndSet(context, releasedNode, null);
                }
                lastSeen = context.getLastSeenEntry();
                releasedNode = context.getReleasedEntry();
                node = releasedNode != null && lastSeen.compareTo(releasedNode) >= 0 ? releasedNode : this.getEntries().next(lastSeen);
            }
            return node;
        }
        return null;
    }

    @Override
    public boolean isEntryAheadOfConsumer(QueueEntry entry, QueueConsumer<?> sub) {
        QueueContext context = sub.getQueueContext();
        if (context != null) {
            QueueEntry releasedNode = context.getReleasedEntry();
            return releasedNode != null && releasedNode.compareTo(entry) < 0;
        }
        return false;
    }

    boolean hasAvailableMessages(QueueConsumer queueConsumer) {
        return this.getNextAvailableEntry(queueConsumer) != null;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public long processQueue(QueueRunner runner) {
        long stateChangeCount;
        long previousStateChangeCount = Long.MIN_VALUE;
        long rVal = Long.MIN_VALUE;
        boolean deliveryIncomplete = true;
        boolean lastLoop = false;
        int iterations = this.getMaxAsyncDeliveries();
        int numSubs = this._consumerList.size();
        int perSub = Math.max(iterations / Math.max(numSubs, 1), 1);
        while (iterations != 0 && (previousStateChangeCount != (stateChangeCount = this._stateChangeCount.get()) || deliveryIncomplete)) {
            if (previousStateChangeCount != stateChangeCount) {
                lastLoop = false;
                rVal = stateChangeCount;
            }
            previousStateChangeCount = stateChangeCount;
            boolean allConsumersDone = true;
            ConsumerNodeIterator consumerNodeIterator = this._consumerList.iterator();
            while (consumerNodeIterator.advance()) {
                QueueConsumer<?> sub = consumerNodeIterator.getNode().getConsumer();
                if (sub.isPullOnly()) continue;
                sub.getSendLock();
                try {
                    for (int i = 0; i < perSub; ++i) {
                        boolean consumerDone = this.attemptDelivery(sub, true);
                        if (consumerDone) {
                            boolean noMore;
                            sub.flushBatched();
                            boolean bl = noMore = this.getNextAvailableEntry(sub) == null;
                            if (!lastLoop || !noMore) break;
                            sub.queueEmpty();
                            break;
                        }
                        allConsumersDone = false;
                        lastLoop = false;
                        if (--iterations != 0) continue;
                        sub.flushBatched();
                        break;
                    }
                    sub.flushBatched();
                }
                finally {
                    sub.releaseSendLock();
                }
            }
            if (allConsumersDone && lastLoop) {
                deliveryIncomplete = false;
                continue;
            }
            if (allConsumersDone) {
                deliveryIncomplete = this._consumerList.size() != 0;
                lastLoop = true;
                continue;
            }
            lastLoop = false;
            deliveryIncomplete = true;
        }
        if (iterations == 0) {
            _logger.debug("Rescheduling runner: {}", (Object)runner);
            return 0L;
        }
        return rVal;
    }

    @Override
    public void checkMessageStatus() {
        QueueEntryIterator queueListIterator = this.getEntries().iterator();
        long estimatedQueueSize = this._atomicQueueSize.get() + (long)this._atomicQueueCount.get() * this._estimatedAverageMessageHeaderSize;
        HashSet<NotificationCheck> perMessageChecks = new HashSet<NotificationCheck>();
        HashSet<NotificationCheck> queueLevelChecks = new HashSet<NotificationCheck>();
        for (NotificationCheck check : this.getNotificationChecks()) {
            if (check.isMessageSpecific()) {
                perMessageChecks.add(check);
                continue;
            }
            queueLevelChecks.add(check);
        }
        QueueNotificationListener listener = this._notificationListener;
        long currentTime = System.currentTimeMillis();
        long thresholdTime = currentTime - this.getAlertRepeatGap();
        long cumulativeQueueSize = 0L;
        while (!this._stopped.get() && queueListIterator.advance()) {
            final QueueEntry node = queueListIterator.getNode();
            if (node.isDeleted()) continue;
            if (node.expired()) {
                boolean acquiredForDequeueing = node.acquireOrSteal(new Runnable(){

                    @Override
                    public void run() {
                        AbstractQueue.this.dequeueEntry(node);
                    }
                });
                if (!acquiredForDequeueing) continue;
                _logger.debug("Dequeuing expired node {}", (Object)node);
                this.dequeueEntry(node);
                continue;
            }
            node.checkHeld(currentTime);
            ServerMessage msg = node.getMessage();
            if (msg == null) continue;
            this._flowToDiskChecker.flowToDiskIfNecessary(msg.getStoredMessage(), cumulativeQueueSize += msg.getSize() + this._estimatedAverageMessageHeaderSize, this._targetQueueSize.get());
            for (NotificationCheck check : perMessageChecks) {
                this.checkForNotification(msg, listener, currentTime, thresholdTime, check);
            }
        }
        for (NotificationCheck check : queueLevelChecks) {
            this.checkForNotification(null, listener, currentTime, thresholdTime, check);
        }
    }

    @Override
    public long getPotentialMemoryFootprint() {
        return Math.max(this.getContextValue(Long.class, "queue.minimumEstimatedMemoryFootprint"), this.getQueueDepthBytes() + this.getContextValue(Long.class, "queue.estimatedMessageMemoryOverhead") * (long)this.getQueueDepthMessages());
    }

    @Override
    public long getAlertRepeatGap() {
        return this._alertRepeatGap;
    }

    @Override
    public long getAlertThresholdMessageAge() {
        return this._alertThresholdMessageAge;
    }

    @Override
    public long getAlertThresholdQueueDepthMessages() {
        return this._alertThresholdQueueDepthMessages;
    }

    private void updateAlertChecks() {
        this.updateNotificationCheck(this.getAlertThresholdQueueDepthMessages(), NotificationCheck.MESSAGE_COUNT_ALERT);
        this.updateNotificationCheck(this.getAlertThresholdQueueDepthBytes(), NotificationCheck.QUEUE_DEPTH_ALERT);
        this.updateNotificationCheck(this.getAlertThresholdMessageAge(), NotificationCheck.MESSAGE_AGE_ALERT);
        this.updateNotificationCheck(this.getAlertThresholdMessageSize(), NotificationCheck.MESSAGE_SIZE_ALERT);
    }

    private void updateNotificationCheck(long checkValue, NotificationCheck notificationCheck) {
        if (checkValue == 0L) {
            this._notificationChecks.remove((Object)notificationCheck);
        } else {
            this._notificationChecks.add(notificationCheck);
        }
    }

    @Override
    public long getAlertThresholdQueueDepthBytes() {
        return this._alertThresholdQueueDepthBytes;
    }

    @Override
    public long getAlertThresholdMessageSize() {
        return this._alertThresholdMessageSize;
    }

    @Override
    public long getQueueFlowControlSizeBytes() {
        return this._queueFlowControlSizeBytes;
    }

    @Override
    public long getQueueFlowResumeSizeBytes() {
        return this._queueFlowResumeSizeBytes;
    }

    @Override
    public Set<NotificationCheck> getNotificationChecks() {
        return this._notificationChecks;
    }

    @Override
    public List<Long> getMessagesOnTheQueue(int num) {
        return this.getMessagesOnTheQueue(num, 0);
    }

    @Override
    public List<Long> getMessagesOnTheQueue(int num, int offset) {
        int i;
        ArrayList<Long> ids = new ArrayList<Long>(num);
        QueueEntryIterator it = this.getEntries().iterator();
        for (i = 0; i < offset; ++i) {
            it.advance();
        }
        for (i = 0; i < num && !it.atTail(); ++i) {
            it.advance();
            ids.add(it.getNode().getMessage().getMessageNumber());
        }
        return ids;
    }

    @Override
    public long getTotalEnqueuedBytes() {
        return this._enqueueSize.get();
    }

    @Override
    public long getTotalDequeuedBytes() {
        return this._dequeueSize.get();
    }

    @Override
    public long getPersistentEnqueuedBytes() {
        return this._persistentMessageEnqueueSize.get();
    }

    @Override
    public long getPersistentDequeuedBytes() {
        return this._persistentMessageDequeueSize.get();
    }

    @Override
    public long getPersistentEnqueuedMessages() {
        return this._persistentMessageEnqueueCount.get();
    }

    @Override
    public long getPersistentDequeuedMessages() {
        return this._persistentMessageDequeueCount.get();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    @Override
    public boolean isHeld(QueueEntry queueEntry, long evaluationTime) {
        if (this._holdMethods.isEmpty()) return false;
        ServerMessage message = queueEntry.getMessage();
        try {
            MessageReference ref = message.newReference();
            try {
                for (HoldMethod method : this._holdMethods) {
                    if (!method.isHeld(ref, evaluationTime)) continue;
                    boolean bl = true;
                    return bl;
                }
                boolean bl = false;
                return bl;
            }
            finally {
                ref.release();
            }
        }
        catch (MessageDeletedException e) {
            return false;
        }
    }

    @Override
    public String toString() {
        return this.getName();
    }

    @Override
    public long getUnacknowledgedMessages() {
        return this._unackedMsgCount.get();
    }

    @Override
    public long getUnacknowledgedBytes() {
        return this._unackedMsgBytes.get();
    }

    @Override
    public void decrementUnackedMsgCount(QueueEntry queueEntry) {
        this._unackedMsgCount.decrementAndGet();
        this._unackedMsgBytes.addAndGet(-queueEntry.getSize());
    }

    @Override
    public void incrementUnackedMsgCount(QueueEntry entry) {
        this._unackedMsgCount.incrementAndGet();
        this._unackedMsgBytes.addAndGet(entry.getSize());
    }

    @Override
    public int getMaximumDeliveryAttempts() {
        return this._maximumDeliveryAttempts;
    }

    private void checkForNotification(ServerMessage<?> msg, QueueNotificationListener listener, long currentTime, long thresholdTime, NotificationCheck check) {
        if ((check.isMessageSpecific() || this._lastNotificationTimes[check.ordinal()] < thresholdTime) && check.notifyIfNecessary(msg, this, listener)) {
            this._lastNotificationTimes[check.ordinal()] = currentTime;
        }
    }

    private void checkForNotificationOnNewMessage(ServerMessage<?> msg) {
        Set<NotificationCheck> notificationChecks = this.getNotificationChecks();
        QueueNotificationListener listener = this._notificationListener;
        if (!notificationChecks.isEmpty()) {
            long currentTime = System.currentTimeMillis();
            long thresholdTime = currentTime - this.getAlertRepeatGap();
            for (NotificationCheck check : notificationChecks) {
                if (!check.isCheckOnMessageArrival()) continue;
                this.checkForNotification(msg, listener, currentTime, thresholdTime, check);
            }
        }
    }

    @Override
    public void setNotificationListener(QueueNotificationListener listener) {
        this._notificationListener = listener == null ? NULL_NOTIFICATION_LISTENER : listener;
    }

    @Override
    public final <M extends ServerMessage<? extends StorableMessageMetaData>> int send(final M message, String routingAddress, InstanceProperties instanceProperties, ServerTransaction txn, final Action<? super MessageInstance> postEnqueueAction) {
        if (this._virtualHost.getState() != State.ACTIVE) {
            throw new VirtualHostUnavailableException(this._virtualHost);
        }
        if (!message.isReferenced(this)) {
            txn.enqueue(this, message, new ServerTransaction.EnqueueAction(){
                MessageReference _reference;
                {
                    this._reference = message.newReference();
                }

                /*
                 * WARNING - Removed try catching itself - possible behaviour change.
                 */
                @Override
                public void postCommit(MessageEnqueueRecord ... records) {
                    try {
                        AbstractQueue.this.enqueue(message, postEnqueueAction, records[0]);
                    }
                    finally {
                        this._reference.release();
                    }
                }

                @Override
                public void onRollback() {
                    this._reference.release();
                }
            });
            return 1;
        }
        return 0;
    }

    @Override
    public boolean verifySessionAccess(AMQSessionModel<?> session) {
        boolean allowed;
        switch (this._exclusive) {
            case NONE: {
                allowed = true;
                break;
            }
            case SESSION: {
                allowed = this._exclusiveOwner == null || this._exclusiveOwner == session;
                break;
            }
            case CONNECTION: {
                allowed = this._exclusiveOwner == null || this._exclusiveOwner == session.getAMQPConnection();
                break;
            }
            case PRINCIPAL: {
                allowed = this._exclusiveOwner == null || Objects.equals(((Principal)this._exclusiveOwner).getName(), session.getAMQPConnection().getAuthorizedPrincipal().getName());
                break;
            }
            case CONTAINER: {
                allowed = this._exclusiveOwner == null || this._exclusiveOwner.equals(session.getAMQPConnection().getRemoteContainerName());
                break;
            }
            case LINK: {
                allowed = this._exclusiveSubscriber == null || this._exclusiveSubscriber.getSessionModel() == session;
                break;
            }
            default: {
                throw new ServerScopedRuntimeException("Unknown exclusivity policy " + (Object)((Object)this._exclusive));
            }
        }
        return allowed;
    }

    private void updateExclusivityPolicy(ExclusivityPolicy desiredPolicy) throws MessageSource.ExistingConsumerPreventsExclusive {
        if (desiredPolicy == null) {
            desiredPolicy = ExclusivityPolicy.NONE;
        }
        if (desiredPolicy != this._exclusive) {
            switch (desiredPolicy) {
                case NONE: {
                    this._exclusiveOwner = null;
                    break;
                }
                case PRINCIPAL: {
                    this.switchToPrincipalExclusivity();
                    break;
                }
                case CONTAINER: {
                    this.switchToContainerExclusivity();
                    break;
                }
                case CONNECTION: {
                    this.switchToConnectionExclusivity();
                    break;
                }
                case SESSION: {
                    this.switchToSessionExclusivity();
                    break;
                }
                case LINK: {
                    this.switchToLinkExclusivity();
                }
            }
            this._exclusive = desiredPolicy;
        }
    }

    private void switchToLinkExclusivity() throws MessageSource.ExistingConsumerPreventsExclusive {
        switch (this.getConsumerCount()) {
            case 1: {
                this._exclusiveSubscriber = this.getConsumerList().getHead().getConsumer();
            }
            case 0: {
                this._exclusiveOwner = null;
                break;
            }
            default: {
                throw new MessageSource.ExistingConsumerPreventsExclusive();
            }
        }
    }

    private void switchToSessionExclusivity() throws MessageSource.ExistingConsumerPreventsExclusive {
        switch (this._exclusive) {
            case PRINCIPAL: 
            case CONTAINER: 
            case CONNECTION: 
            case NONE: {
                AMQSessionModel session = null;
                for (ConsumerImpl consumerImpl : this.getConsumers()) {
                    if (session == null) {
                        session = consumerImpl.getSessionModel();
                        continue;
                    }
                    if (session.equals(consumerImpl.getSessionModel())) continue;
                    throw new MessageSource.ExistingConsumerPreventsExclusive();
                }
                this._exclusiveOwner = session;
                break;
            }
            case LINK: {
                this._exclusiveOwner = this._exclusiveSubscriber == null ? null : this._exclusiveSubscriber.getSessionModel().getAMQPConnection();
            }
        }
    }

    private void switchToConnectionExclusivity() throws MessageSource.ExistingConsumerPreventsExclusive {
        switch (this._exclusive) {
            case PRINCIPAL: 
            case CONTAINER: 
            case NONE: {
                AMQPConnection<?> con = null;
                for (ConsumerImpl consumerImpl : this.getConsumers()) {
                    if (con == null) {
                        con = consumerImpl.getSessionModel().getAMQPConnection();
                        continue;
                    }
                    if (con.equals(consumerImpl.getSessionModel().getAMQPConnection())) continue;
                    throw new MessageSource.ExistingConsumerPreventsExclusive();
                }
                this._exclusiveOwner = con;
                break;
            }
            case SESSION: {
                this._exclusiveOwner = this._exclusiveOwner == null ? null : ((AMQSessionModel)this._exclusiveOwner).getAMQPConnection();
                break;
            }
            case LINK: {
                this._exclusiveOwner = this._exclusiveSubscriber == null ? null : this._exclusiveSubscriber.getSessionModel().getAMQPConnection();
            }
        }
    }

    private void switchToContainerExclusivity() throws MessageSource.ExistingConsumerPreventsExclusive {
        switch (this._exclusive) {
            case PRINCIPAL: 
            case NONE: {
                String containerID = null;
                for (ConsumerImpl consumerImpl : this.getConsumers()) {
                    if (containerID == null) {
                        containerID = consumerImpl.getSessionModel().getAMQPConnection().getRemoteContainerName();
                        continue;
                    }
                    if (containerID.equals(consumerImpl.getSessionModel().getAMQPConnection().getRemoteContainerName())) continue;
                    throw new MessageSource.ExistingConsumerPreventsExclusive();
                }
                this._exclusiveOwner = containerID;
                break;
            }
            case CONNECTION: {
                this._exclusiveOwner = this._exclusiveOwner == null ? null : ((AMQPConnection)this._exclusiveOwner).getRemoteContainerName();
                break;
            }
            case SESSION: {
                this._exclusiveOwner = this._exclusiveOwner == null ? null : ((AMQSessionModel)this._exclusiveOwner).getAMQPConnection().getRemoteContainerName();
                break;
            }
            case LINK: {
                this._exclusiveOwner = this._exclusiveSubscriber == null ? null : this._exclusiveSubscriber.getSessionModel().getAMQPConnection().getRemoteContainerName();
            }
        }
    }

    private void switchToPrincipalExclusivity() throws MessageSource.ExistingConsumerPreventsExclusive {
        switch (this._exclusive) {
            case CONTAINER: 
            case NONE: {
                Principal principal = null;
                for (ConsumerImpl consumerImpl : this.getConsumers()) {
                    if (principal == null) {
                        principal = consumerImpl.getSessionModel().getAMQPConnection().getAuthorizedPrincipal();
                        continue;
                    }
                    if (Objects.equals(principal.getName(), consumerImpl.getSessionModel().getAMQPConnection().getAuthorizedPrincipal().getName())) continue;
                    throw new MessageSource.ExistingConsumerPreventsExclusive();
                }
                this._exclusiveOwner = principal;
                break;
            }
            case CONNECTION: {
                this._exclusiveOwner = this._exclusiveOwner == null ? null : ((AMQPConnection)this._exclusiveOwner).getAuthorizedPrincipal();
                break;
            }
            case SESSION: {
                this._exclusiveOwner = this._exclusiveOwner == null ? null : ((AMQSessionModel)this._exclusiveOwner).getAMQPConnection().getAuthorizedPrincipal();
                break;
            }
            case LINK: {
                this._exclusiveOwner = this._exclusiveSubscriber == null ? null : this._exclusiveSubscriber.getSessionModel().getAMQPConnection().getAuthorizedPrincipal();
            }
        }
    }

    @StateTransition(currentState={State.UNINITIALIZED, State.ERRORED}, desiredState=State.ACTIVE)
    private ListenableFuture<Void> activate() {
        this.setState(State.ACTIVE);
        return Futures.immediateFuture(null);
    }

    @StateTransition(currentState={State.UNINITIALIZED}, desiredState=State.DELETED)
    private ListenableFuture<Void> doDeleteBeforeInitialize() {
        this.preSetAlternateExchange();
        this.setState(State.DELETED);
        return Futures.immediateFuture(null);
    }

    @StateTransition(currentState={State.ACTIVE}, desiredState=State.DELETED)
    private ListenableFuture<Void> doDelete() {
        ListenableFuture<Integer> removeFuture = this.deleteAndReturnCountAsync();
        return this.doAfter(removeFuture, new Runnable(){

            @Override
            public void run() {
            }
        });
    }

    @Override
    public ExclusivityPolicy getExclusive() {
        return this._exclusive;
    }

    @Override
    public boolean isNoLocal() {
        return this._noLocal;
    }

    @Override
    public String getMessageGroupKey() {
        return this._messageGroupKey;
    }

    @Override
    public boolean isMessageGroupSharedGroups() {
        return this._messageGroupSharedGroups;
    }

    @Override
    public String getMessageGroupDefaultGroup() {
        return this._messageGroupDefaultGroup;
    }

    @Override
    public int getMaximumDistinctGroups() {
        return this._maximumDistinctGroups;
    }

    @Override
    public boolean isQueueFlowStopped() {
        return this._overfull.get();
    }

    @Override
    public <C extends ConfiguredObject> Collection<C> getChildren(Class<C> clazz) {
        if (clazz == Binding.class) {
            return this.getBindings();
        }
        if (clazz == Consumer.class) {
            return this.getConsumers();
        }
        return Collections.emptySet();
    }

    @Override
    protected <C extends ConfiguredObject> ListenableFuture<C> addChildAsync(Class<C> childClass, Map<String, Object> attributes, ConfiguredObject ... otherParents) {
        if (childClass == Binding.class && otherParents.length == 1 && otherParents[0] instanceof Exchange) {
            String bindingKey = (String)attributes.get("name");
            ((Exchange)otherParents[0]).addBinding(bindingKey, this, (Map)attributes.get("arguments"));
            for (Binding<?> binding : this._bindings) {
                if (binding.getExchange() != otherParents[0] || !binding.getName().equals(bindingKey)) continue;
                return Futures.immediateFuture(binding);
            }
            return null;
        }
        return super.addChildAsync(childClass, attributes, otherParents);
    }

    @Override
    public boolean changeAttribute(String name, Object desired) throws IllegalStateException, AccessControlException, IllegalArgumentException {
        if ("exclusive".equals(name)) {
            ExclusivityPolicy existingPolicy = this.getExclusive();
            if (super.changeAttribute(name, desired)) {
                try {
                    if (existingPolicy != this._exclusive) {
                        ExclusivityPolicy newPolicy = this._exclusive;
                        this._exclusive = existingPolicy;
                        this.updateExclusivityPolicy(newPolicy);
                    }
                    return true;
                }
                catch (MessageSource.ExistingConsumerPreventsExclusive existingConsumerPreventsExclusive) {
                    throw new IllegalArgumentException("Unable to set exclusivity policy to " + desired + " as an existing combinations of consumers prevents this");
                }
            }
            return false;
        }
        return super.changeAttribute(name, desired);
    }

    int getMaxAsyncDeliveries() {
        return this._maxAsyncDeliveries;
    }

    @Override
    protected void validateChange(ConfiguredObject<?> proxyForValidation, Set<String> changedAttributes) {
        super.validateChange(proxyForValidation, changedAttributes);
        Queue queue = (Queue)proxyForValidation;
        long queueFlowControlSize = queue.getQueueFlowControlSizeBytes();
        long queueFlowControlResumeSize = queue.getQueueFlowResumeSizeBytes();
        if (queueFlowControlResumeSize > queueFlowControlSize) {
            throw new IllegalConfigurationException("Flow resume size can't be greater than flow control size");
        }
        for (String attrName : NON_NEGATIVE_NUMBERS) {
            Object value;
            if (!changedAttributes.contains(attrName) || (value = queue.getAttribute(attrName)) instanceof Number && ((Number)value).longValue() >= 0L) continue;
            throw new IllegalConfigurationException("Only positive integer value can be specified for the attribute " + attrName);
        }
    }

    @Override
    public NamedAddressSpace getAddressSpace() {
        return this._virtualHost;
    }

    @Override
    public void authorisePublish(SecurityToken token, Map<String, Object> arguments) throws AccessControlException {
        this.authorise(token, PUBLISH_ACTION, arguments);
    }

    @Override
    public List<Long> moveMessages(Queue<?> destination, List<Long> messageIds, String selector, int limit) {
        MoveMessagesTransaction transaction = new MoveMessagesTransaction(this, messageIds, destination, this.parseSelector(selector), limit);
        this._virtualHost.executeTransaction(transaction);
        return transaction.getModifiedMessageIds();
    }

    @Override
    public List<Long> copyMessages(Queue<?> destination, List<Long> messageIds, String selector, int limit) {
        CopyMessagesTransaction transaction = new CopyMessagesTransaction(this, messageIds, destination, this.parseSelector(selector), limit);
        this._virtualHost.executeTransaction(transaction);
        return transaction.getModifiedMessageIds();
    }

    @Override
    public List<Long> deleteMessages(List<Long> messageIds, String selector, int limit) {
        DeleteMessagesTransaction transaction = new DeleteMessagesTransaction(this, messageIds, this.parseSelector(selector), limit);
        this._virtualHost.executeTransaction(transaction);
        return transaction.getModifiedMessageIds();
    }

    private JMSSelectorFilter parseSelector(String selector) {
        try {
            return selector == null ? null : new JMSSelectorFilter(selector);
        }
        catch (SelectorParsingException | ParseException | TokenMgrError e) {
            throw new IllegalArgumentException("Cannot parse JMS selector \"" + selector + "\"", e);
        }
    }

    @Override
    public Content getMessageContent(long messageId, long limit, boolean returnJson, boolean decompressBeforeLimiting) {
        MessageContentFinder messageFinder = new MessageContentFinder(messageId);
        this.visit(messageFinder);
        if (messageFinder.isFound()) {
            return this.createMessageContent(messageFinder.getMessageReference(), returnJson, limit, decompressBeforeLimiting);
        }
        return null;
    }

    private Content createMessageContent(MessageReference<?> messageReference, boolean returnJson, long limit, boolean decompressBeforeLimiting) {
        if (returnJson) {
            Object message = messageReference.getMessage();
            if (message instanceof InternalMessage) {
                return new JsonMessageContent(messageReference, (InternalMessage)message, limit);
            }
            MessageConverter<?, InternalMessage> messageConverter = MessageConverterRegistry.getConverter(message.getClass(), InternalMessage.class);
            if (messageConverter != null) {
                return new JsonMessageContent(messageReference, messageConverter.convert(message, this.getVirtualHost()), limit);
            }
            throw new IllegalArgumentException(String.format("Unable to convert message %d on queue '%s' to JSON", message.getMessageNumber(), this.getName()));
        }
        return new MessageContent(messageReference, limit, decompressBeforeLimiting);
    }

    @Override
    public List<MessageInfo> getMessageInfo(int first, int last, boolean includeHeaders) {
        MessageCollector messageCollector = new MessageCollector(first, last, includeHeaders);
        this.visit(messageCollector);
        return messageCollector.getMessages();
    }

    @Override
    public MessageInfo getMessageInfoById(long messageId, boolean includeHeaders) {
        MessageFinder messageFinder = new MessageFinder(messageId, includeHeaders);
        this.visit(messageFinder);
        return messageFinder.getMessageInfo();
    }

    private class FlowToDiskChecker {
        private FlowToDiskChecker() {
        }

        void flowToDiskIfNecessary(StoredMessage<?> storedMessage, long estimatedQueueSize, long targetQueueSize) {
            if ((estimatedQueueSize > targetQueueSize || QpidByteBuffer.getAllocatedDirectMemorySize() > AbstractQueue.this._flowToDiskThreshold) && storedMessage.isInMemory()) {
                storedMessage.flowToDisk();
            }
        }
    }

    private class MessageCollector
    implements QueueEntryVisitor {
        private final int _first;
        private final int _last;
        private int _position = -1;
        private final List<MessageInfo> _messages = new MessageRangeList();
        private final boolean _includeHeaders;

        private MessageCollector(int first, int last, boolean includeHeaders) {
            this._first = first;
            this._last = last;
            this._includeHeaders = includeHeaders;
        }

        @Override
        public boolean visit(QueueEntry entry) {
            ++this._position;
            if (!(this._first != -1 && this._position < this._first || this._last != -1 && this._position > this._last)) {
                this._messages.add(new MessageInfoImpl(entry, this._includeHeaders));
            }
            return this._last != -1 && this._position > this._last;
        }

        public List<MessageInfo> getMessages() {
            return this._messages;
        }

        private class MessageRangeList
        extends ArrayList<MessageInfo>
        implements CustomRestHeaders {
            private MessageRangeList() {
            }

            @RestContentHeader(value="Content-Range")
            public String getContentRange() {
                String min = this.isEmpty() ? "0" : String.valueOf(MessageCollector.this._first);
                String max = this.isEmpty() ? "0" : String.valueOf(MessageCollector.this._first + this.size() - 1);
                return "" + min + "-" + max + "/" + AbstractQueue.this.getQueueDepthMessages();
            }
        }
    }

    private class MessageContentFinder
    implements QueueEntryVisitor {
        private final long _messageNumber;
        private boolean _found;
        private MessageReference<?> _messageReference;

        private MessageContentFinder(long messageNumber) {
            this._messageNumber = messageNumber;
        }

        @Override
        public boolean visit(QueueEntry entry) {
            ServerMessage message = entry.getMessage();
            if (message != null && this._messageNumber == message.getMessageNumber()) {
                try {
                    this._messageReference = message.newReference();
                    this._found = true;
                    return true;
                }
                catch (MessageDeletedException messageDeletedException) {
                    // empty catch block
                }
            }
            return false;
        }

        MessageReference<?> getMessageReference() {
            return this._messageReference;
        }

        public boolean isFound() {
            return this._found;
        }
    }

    private class MessageFinder
    implements QueueEntryVisitor {
        private final long _messageNumber;
        private final boolean _includeHeaders;
        private MessageInfo _messageInfo;

        private MessageFinder(long messageNumber, boolean includeHeaders) {
            this._messageNumber = messageNumber;
            this._includeHeaders = includeHeaders;
        }

        @Override
        public boolean visit(QueueEntry entry) {
            ServerMessage message = entry.getMessage();
            if (message != null && this._messageNumber == message.getMessageNumber()) {
                this._messageInfo = new MessageInfoImpl(entry, this._includeHeaders);
                return true;
            }
            return false;
        }

        public MessageInfo getMessageInfo() {
            return this._messageInfo;
        }
    }

    private static class EnqueueRequest {
        private final MessageReference<?> _message;
        private final Action<? super MessageInstance> _action;
        private final MessageEnqueueRecord _enqueueRecord;

        public EnqueueRequest(ServerMessage message, Action<? super MessageInstance> action, MessageEnqueueRecord enqueueRecord) {
            this._enqueueRecord = enqueueRecord;
            this._message = message.newReference();
            this._action = action;
        }

        public MessageReference<?> getMessage() {
            return this._message;
        }

        public Action<? super MessageInstance> getAction() {
            return this._action;
        }

        public MessageEnqueueRecord getEnqueueRecord() {
            return this._enqueueRecord;
        }
    }

    private class DeletedChildListener
    implements ConfigurationChangeListener {
        private DeletedChildListener() {
        }

        public void stateChanged(ConfiguredObject object, State oldState, State newState) {
            if (newState == State.DELETED) {
                AbstractQueue.this.childRemoved(object);
            }
        }

        public void childAdded(ConfiguredObject object, ConfiguredObject child) {
        }

        public void childRemoved(ConfiguredObject object, ConfiguredObject child) {
        }

        public void attributeSet(ConfiguredObject object, String attributeName, Object oldAttributeValue, Object newAttributeValue) {
        }

        @Override
        public void bulkChangeStart(ConfiguredObject<?> object) {
        }

        @Override
        public void bulkChangeEnd(ConfiguredObject<?> object) {
        }
    }

    private class ClearOwnerAction
    implements Action<Deletable> {
        private final Deletable<? extends Deletable> _lifetimeObject;
        private DeleteDeleteTask _deleteTask;

        public ClearOwnerAction(Deletable<? extends Deletable> lifetimeObject) {
            this._lifetimeObject = lifetimeObject;
        }

        @Override
        public void performAction(Deletable object) {
            if (AbstractQueue.this._exclusiveOwner == this._lifetimeObject) {
                AbstractQueue.this._exclusiveOwner = null;
            }
            if (this._deleteTask != null) {
                AbstractQueue.this.removeDeleteTask(this._deleteTask);
            }
        }

        public void setDeleteTask(DeleteDeleteTask deleteTask) {
            this._deleteTask = deleteTask;
        }
    }

    private static class AcquireAllQueueEntryFilter
    implements QueueEntryFilter {
        private AcquireAllQueueEntryFilter() {
        }

        @Override
        public boolean accept(QueueEntry entry) {
            return entry.acquire();
        }

        @Override
        public boolean filterComplete() {
            return false;
        }
    }

    class MessageContent
    extends BaseMessageContent {
        private boolean _decompressBeforeLimiting;

        MessageContent(MessageReference<?> messageReference, long limit, boolean decompressBeforeLimiting) {
            super(messageReference, limit);
            if (decompressBeforeLimiting) {
                String contentEncoding = this.getContentEncoding();
                if ("gzip".equals(contentEncoding)) {
                    this._decompressBeforeLimiting = true;
                } else if (contentEncoding != null && !"".equals(contentEncoding) && !"identity".equals(contentEncoding)) {
                    throw new IllegalArgumentException(String.format("Requested decompression of message with unknown compression '%s'", contentEncoding));
                }
            }
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        @Override
        public void write(OutputStream outputStream) throws IOException {
            Object message = this._messageReference.getMessage();
            int length = (int)(this._limit == -1L || this._decompressBeforeLimiting ? message.getSize() : this._limit);
            Object inputStream = new QpidByteBufferInputStream(message.getContent(0, length));
            if (this._limit != -1L && this._decompressBeforeLimiting) {
                inputStream = new GZIPInputStream((InputStream)inputStream);
                inputStream = ByteStreams.limit((InputStream)inputStream, (long)this._limit);
                outputStream = new GZIPOutputStream(outputStream);
            }
            try {
                long foo = ByteStreams.copy((InputStream)inputStream, (OutputStream)outputStream);
                foo = foo + 1L - 1L;
            }
            finally {
                outputStream.close();
                ((InputStream)inputStream).close();
            }
        }
    }

    class JsonMessageContent
    extends BaseMessageContent {
        private final InternalMessage _internalMessage;

        JsonMessageContent(MessageReference<?> messageReference, InternalMessage message, long limit) {
            super(messageReference, limit);
            this._internalMessage = message;
        }

        @Override
        public void write(OutputStream outputStream) throws IOException {
            Object messageBody = this._internalMessage.getMessageBody();
            new MessageContentJsonConverter(messageBody, this.isTruncated() ? this._limit : -1L).convertAndWrite(outputStream);
        }

        @Override
        @RestContentHeader(value="Content-Encoding")
        public String getContentEncoding() {
            return "identity";
        }

        @Override
        @RestContentHeader(value="Content-Type")
        public String getContentType() {
            return "application/json";
        }
    }

    abstract class BaseMessageContent
    implements Content,
    CustomRestHeaders {
        public static final int UNLIMITED = -1;
        protected final MessageReference<?> _messageReference;
        protected final long _limit;
        private final boolean _truncated;

        BaseMessageContent(MessageReference<?> messageReference, long limit) {
            this._messageReference = messageReference;
            this._limit = limit;
            this._truncated = limit >= 0L && this._messageReference.getMessage().getSize() > limit;
        }

        @Override
        public final void release() {
            this._messageReference.release();
        }

        protected boolean isTruncated() {
            return this._truncated;
        }

        @RestContentHeader(value="X-Content-Truncated")
        public String getContentTruncated() {
            return String.valueOf(this.isTruncated());
        }

        @RestContentHeader(value="Content-Type")
        public String getContentType() {
            return this._messageReference.getMessage().getMessageHeader().getMimeType();
        }

        @RestContentHeader(value="Content-Encoding")
        public String getContentEncoding() {
            return this._messageReference.getMessage().getMessageHeader().getEncoding();
        }

        @RestContentHeader(value="Content-Disposition")
        public String getContentDisposition() {
            try {
                String queueName = AbstractQueue.this.getName();
                String asciiQueueName = queueName.replaceAll("[^\\x20-\\x7E]", "?").replace('\\', '?').replaceAll("%[0-9a-fA-F]{2}", "?");
                long messageNumber = this._messageReference.getMessage().getMessageNumber();
                String filenameExtension = (String)AbstractQueue.this._mimeTypeToFileExtension.get(this.getContentType());
                filenameExtension = filenameExtension == null ? "" : filenameExtension;
                String disposition = String.format("attachment; filename=\"%s_msg%09d%s\"; filename*=\"UTF-8''%s_msg%09d%s\"", asciiQueueName, messageNumber, filenameExtension, URLEncoder.encode(queueName, UTF8), messageNumber, filenameExtension);
                return disposition;
            }
            catch (UnsupportedEncodingException e) {
                throw new RuntimeException("JVM does not support UTF8", e);
            }
        }
    }

    private static class DeleteDeleteTask
    implements Action<Deletable> {
        private final Deletable<? extends Deletable> _lifetimeObject;
        private final Action<? super Deletable> _deleteQueueOwnerTask;

        public DeleteDeleteTask(Deletable<? extends Deletable> lifetimeObject, Action<? super Deletable> deleteQueueOwnerTask) {
            this._lifetimeObject = lifetimeObject;
            this._deleteQueueOwnerTask = deleteQueueOwnerTask;
        }

        @Override
        public void performAction(Deletable object) {
            this._lifetimeObject.removeDeleteTask(this._deleteQueueOwnerTask);
        }
    }

    public static interface QueueEntryFilter {
        public boolean accept(QueueEntry var1);

        public boolean filterComplete();
    }

    private static interface HoldMethod {
        public boolean isHeld(MessageReference<?> var1, long var2);
    }
}

