/*
 * Decompiled with CFR 0.152.
 */
package org.apache.qpid.server.protocol;

import org.apache.qpid.server.transport.ServerNetworkConnection;
import org.apache.qpid.transport.network.Ticker;

public class ConnectionClosingTicker
implements Ticker {
    private final long _timeoutTime;
    private final ServerNetworkConnection _network;

    public ConnectionClosingTicker(long timeoutTime, ServerNetworkConnection network) {
        this._timeoutTime = timeoutTime;
        this._network = network;
    }

    public int getTimeToNextTick(long currentTime) {
        if (this._network.getScheduledTime() > 0L) {
            return (int)(this._timeoutTime - this._network.getScheduledTime());
        }
        return (int)(this._timeoutTime - currentTime);
    }

    public int tick(long currentTime) {
        int nextTick = this.getTimeToNextTick(currentTime);
        if (nextTick <= 0) {
            this._network.close();
        }
        return nextTick;
    }
}

