/*
 * Decompiled with CFR 0.152.
 */
package org.apache.qpid.server.pool;

import java.util.Map;
import java.util.concurrent.BlockingQueue;
import java.util.concurrent.ConcurrentHashMap;
import java.util.concurrent.Executors;
import java.util.concurrent.ThreadFactory;
import java.util.concurrent.ThreadPoolExecutor;
import java.util.concurrent.TimeUnit;
import org.apache.qpid.bytebuffer.QpidByteBuffer;

public class QpidByteBufferDisposingThreadPoolExecutor
extends ThreadPoolExecutor {
    private final Map<Thread, QpidByteBuffer> _cachedBufferMap = new ConcurrentHashMap<Thread, QpidByteBuffer>();

    public QpidByteBufferDisposingThreadPoolExecutor(int corePoolSize, int maximumPoolSize, long keepAliveTime, TimeUnit unit, BlockingQueue<Runnable> workQueue) {
        this(corePoolSize, maximumPoolSize, keepAliveTime, unit, workQueue, Executors.defaultThreadFactory());
    }

    public QpidByteBufferDisposingThreadPoolExecutor(int corePoolSize, int maximumPoolSize, long keepAliveTime, TimeUnit unit, BlockingQueue<Runnable> workQueue, ThreadFactory factory) {
        super(corePoolSize, maximumPoolSize, keepAliveTime, unit, workQueue, factory);
    }

    @Override
    protected void afterExecute(Runnable r, Throwable t) {
        super.afterExecute(r, t);
        QpidByteBuffer cachedThreadLocalBuffer = QpidByteBuffer.getCachedThreadLocalBuffer();
        if (cachedThreadLocalBuffer != null) {
            this._cachedBufferMap.put(Thread.currentThread(), cachedThreadLocalBuffer);
        } else {
            this._cachedBufferMap.remove(Thread.currentThread());
        }
    }

    @Override
    protected void terminated() {
        super.terminated();
        for (QpidByteBuffer qpidByteBuffer : this._cachedBufferMap.values()) {
            qpidByteBuffer.dispose();
        }
        this._cachedBufferMap.clear();
    }
}

