/*
 * Decompiled with CFR 0.152.
 */
package org.apache.qpid.server.model.preferences;

import java.io.UnsupportedEncodingException;
import java.net.URLDecoder;
import java.net.URLEncoder;
import java.nio.charset.StandardCharsets;
import java.security.Principal;
import java.util.Collection;
import java.util.regex.Matcher;
import java.util.regex.Pattern;
import org.apache.qpid.server.model.ConfiguredObject;
import org.apache.qpid.server.security.QpidPrincipal;

public class GenericPrincipal
implements Principal {
    private static final Pattern PATTERN = Pattern.compile("([a-zA-Z_0-9.%~-]+)@([^('@]*)\\('([a-zA-Z_0-9.%~-]*)'\\)");
    public static final String UTF8 = StandardCharsets.UTF_8.name();
    private final String _name;
    private final String _originType;
    private final String _originName;

    public GenericPrincipal(QpidPrincipal principal) {
        this._name = principal.getName();
        ConfiguredObject<?> origin = principal.getOrigin();
        if (origin != null) {
            this._originType = origin.getType();
            this._originName = origin.getName();
        } else {
            this._originType = "UNKNOWN";
            this._originName = "";
        }
    }

    public GenericPrincipal(String name) {
        if (name == null) {
            throw new IllegalArgumentException("Principal name cannot be null");
        }
        Matcher m = PATTERN.matcher(name);
        if (!m.matches()) {
            throw new IllegalArgumentException("Principal has unexpected format");
        }
        try {
            this._name = URLDecoder.decode(m.group(1), UTF8);
            this._originType = m.group(2);
            this._originName = URLDecoder.decode(m.group(3), UTF8);
        }
        catch (UnsupportedEncodingException e) {
            throw new RuntimeException("JVM does not support UTF8", e);
        }
    }

    @Override
    public String getName() {
        return this._name;
    }

    @Override
    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (o == null || this.getClass() != o.getClass()) {
            return false;
        }
        GenericPrincipal that = (GenericPrincipal)o;
        return this._name.equals(that._name) && this._originType.equals(that._originType) && this._originName.equals(that._originName);
    }

    @Override
    public int hashCode() {
        return this._name.hashCode();
    }

    @Override
    public String toString() {
        return "GenericPrincipal{_name='" + this._name + '\'' + ", _originType='" + this._originType + '\'' + ", _originName='" + this._originName + '\'' + '}';
    }

    public String toExternalForm() {
        try {
            return String.format("%s@%s('%s')", URLEncoder.encode(this._name, UTF8), this._originType, URLEncoder.encode(this._originName, UTF8));
        }
        catch (UnsupportedEncodingException e) {
            throw new RuntimeException("JVM does not support UTF8", e);
        }
    }

    String getOriginType() {
        return this._originType;
    }

    String getOriginName() {
        return this._originName;
    }

    public static boolean principalsContain(Collection<Principal> principals, Principal principal) {
        for (Principal currentPrincipal : principals) {
            if (!GenericPrincipal.principalsEqual(principal, currentPrincipal)) continue;
            return true;
        }
        return false;
    }

    public static boolean principalsEqual(Principal p1, Principal p2) {
        if (p1 == null) {
            return p2 == null;
        }
        if (p2 == null) {
            return false;
        }
        if (p1 instanceof GenericPrincipal) {
            return GenericPrincipal.genericPrincipalEquals((GenericPrincipal)p1, p2);
        }
        if (p2 instanceof GenericPrincipal) {
            return GenericPrincipal.genericPrincipalEquals((GenericPrincipal)p2, p1);
        }
        return p1.equals(p2);
    }

    private static boolean genericPrincipalEquals(GenericPrincipal genericPrincipal, Principal otherPrincipal) {
        if (otherPrincipal instanceof QpidPrincipal) {
            otherPrincipal = new GenericPrincipal((QpidPrincipal)otherPrincipal);
        }
        if (otherPrincipal instanceof GenericPrincipal) {
            GenericPrincipal otherGenericPrincipal = (GenericPrincipal)otherPrincipal;
            return genericPrincipal.getName().equals(otherGenericPrincipal.getName()) && genericPrincipal.getOriginType().equals(otherGenericPrincipal.getOriginType()) && genericPrincipal.getOriginName().equals(otherGenericPrincipal.getOriginName());
        }
        return genericPrincipal.equals(otherPrincipal);
    }
}

