/*
 * Decompiled with CFR 0.152.
 */
package org.apache.qpid.server.model.port;

import java.util.Collection;
import java.util.Collections;
import java.util.Map;
import java.util.Set;
import org.apache.qpid.server.configuration.IllegalConfigurationException;
import org.apache.qpid.server.model.ConfiguredObject;
import org.apache.qpid.server.model.Container;
import org.apache.qpid.server.model.ManagedAttributeField;
import org.apache.qpid.server.model.ManagedObjectFactoryConstructor;
import org.apache.qpid.server.model.State;
import org.apache.qpid.server.model.VirtualHostAlias;
import org.apache.qpid.server.model.port.AbstractClientAuthCapablePortWithAuthProvider;
import org.apache.qpid.server.model.port.HttpPort;
import org.apache.qpid.server.model.port.PortManager;
import org.apache.qpid.server.util.PortUtil;

public class HttpPortImpl
extends AbstractClientAuthCapablePortWithAuthProvider<HttpPortImpl>
implements HttpPort<HttpPortImpl> {
    private PortManager _portManager;
    @ManagedAttributeField
    private String _bindingAddress;
    @ManagedAttributeField
    private int _threadPoolMaximum;
    @ManagedAttributeField
    private int _threadPoolMinimum;
    @ManagedAttributeField
    private boolean _allowConfidentialOperationsOnInsecureChannels;

    @ManagedObjectFactoryConstructor
    public HttpPortImpl(Map<String, Object> attributes, Container<?> container) {
        super(attributes, container);
    }

    @Override
    public void setPortManager(PortManager manager) {
        this._portManager = manager;
    }

    @Override
    public String getBindingAddress() {
        return this._bindingAddress;
    }

    @Override
    public int getThreadPoolMaximum() {
        return this._threadPoolMaximum;
    }

    @Override
    public int getThreadPoolMinimum() {
        return this._threadPoolMinimum;
    }

    @Override
    public boolean isAllowConfidentialOperationsOnInsecureChannels() {
        return this._allowConfidentialOperationsOnInsecureChannels;
    }

    @Override
    protected State onActivate() {
        if (this._portManager != null && this._portManager.isActivationAllowed(this)) {
            return super.onActivate();
        }
        return State.QUIESCED;
    }

    @Override
    public void onValidate() {
        super.onValidate();
        this.validateThreadPoolSettings(this);
        double additionalInternalThreads = this.getContextValue(Integer.class, "port.http.additionalInternalThreads").intValue();
        if (additionalInternalThreads < 1.0) {
            throw new IllegalConfigurationException(String.format("Number of additional internal threads %d is too small. Must be greater than zero.", additionalInternalThreads));
        }
        double maximumQueuedRequests = this.getContextValue(Integer.class, "port.http.maximumQueuedRequests").intValue();
        if (maximumQueuedRequests < 1.0) {
            throw new IllegalConfigurationException(String.format("Number of additional internal threads %d is too small. Must be greater than zero.", maximumQueuedRequests));
        }
    }

    @Override
    public void validateOnCreate() {
        super.validateOnCreate();
        String bindingAddress = this.getBindingAddress();
        if (!PortUtil.isPortAvailable(bindingAddress, this.getPort())) {
            throw new IllegalConfigurationException(String.format("Cannot bind to port %d and binding address '%s'. Port is already is use.", this.getPort(), bindingAddress == null || "".equals(bindingAddress) ? "*" : bindingAddress));
        }
    }

    @Override
    protected void validateChange(ConfiguredObject<?> proxyForValidation, Set<String> changedAttributes) {
        super.validateChange(proxyForValidation, changedAttributes);
        HttpPort changed = (HttpPort)proxyForValidation;
        if (changedAttributes.contains("threadPoolMaximum") || changedAttributes.contains("threadPoolMinimum")) {
            this.validateThreadPoolSettings(changed);
        }
    }

    private void validateThreadPoolSettings(HttpPort<?> httpPort) {
        if (httpPort.getThreadPoolMaximum() < 1) {
            throw new IllegalConfigurationException(String.format("Thread pool maximum %d is too small. Must be greater than zero.", httpPort.getThreadPoolMaximum()));
        }
        if (httpPort.getThreadPoolMinimum() < 1) {
            throw new IllegalConfigurationException(String.format("Thread pool minimum %d is too small. Must be greater than zero.", httpPort.getThreadPoolMinimum()));
        }
        if (httpPort.getThreadPoolMinimum() > httpPort.getThreadPoolMaximum()) {
            throw new IllegalConfigurationException(String.format("Thread pool minimum %d cannot be greater than thread pool maximum %d.", httpPort.getThreadPoolMinimum(), httpPort.getThreadPoolMaximum()));
        }
    }

    public static Map<String, Collection<String>> getSupportedChildTypes() {
        return Collections.singletonMap(VirtualHostAlias.class.getSimpleName(), Collections.emptyList());
    }
}

