/*
 * Decompiled with CFR 0.152.
 */
package org.apache.qpid.server.model.port;

import java.util.Set;
import org.apache.qpid.server.model.AuthenticationProvider;
import org.apache.qpid.server.model.ManagedAttribute;
import org.apache.qpid.server.model.ManagedContextDefault;
import org.apache.qpid.server.model.ManagedObject;
import org.apache.qpid.server.model.Protocol;
import org.apache.qpid.server.model.Transport;
import org.apache.qpid.server.model.TrustStore;
import org.apache.qpid.server.model.port.ClientAuthCapablePort;
import org.apache.qpid.server.model.port.PortManager;

@ManagedObject(category=false, type="HTTP", validChildTypes="org.apache.qpid.server.model.port.HttpPortImpl#getSupportedChildTypes()")
public interface HttpPort<X extends HttpPort<X>>
extends ClientAuthCapablePort<X> {
    public static final String DEFAULT_HTTP_NEED_CLIENT_AUTH = "false";
    public static final String DEFAULT_HTTP_WANT_CLIENT_AUTH = "false";
    public static final String THREAD_POOL_MINIMUM = "threadPoolMinimum";
    public static final String THREAD_POOL_MAXIMUM = "threadPoolMaximum";
    public static final String ALLOW_CONFIDENTIAL_OPERATIONS_ON_INSECURE_CHANNELS = "allowConfidentialOperationsOnInsecureChannels";
    public static final String PORT_HTTP_THREAD_POOL_MAXIMUM = "port.http.threadPool.maximum";
    @ManagedContextDefault(name="port.http.threadPool.maximum")
    public static final long DEFAULT_PORT_HTTP_THREAD_POOL_MAXIMUM = 24L;
    public static final String PORT_HTTP_THREAD_POOL_MINIMUM = "port.http.threadPool.minimum";
    @ManagedContextDefault(name="port.http.threadPool.minimum")
    public static final long DEFAULT_PORT_HTTP_THREAD_POOL_MINIMUM = 8L;
    public static final String PORT_HTTP_ADDITIONAL_INTERNAL_THREADS = "port.http.additionalInternalThreads";
    @ManagedContextDefault(name="port.http.additionalInternalThreads")
    public static final long DEFAULT_PORT_HTTP_ADDITIONAL_INTERNAL_THREADS = 5L;
    public static final String PORT_HTTP_MAXIMUM_QUEUED_REQUESTS = "port.http.maximumQueuedRequests";
    @ManagedContextDefault(name="port.http.maximumQueuedRequests")
    public static final long DEFAULT_PORT_HTTP_MAXIMUM_QUEUED_REQUESTS = 1000L;

    @ManagedAttribute(defaultValue="*")
    public String getBindingAddress();

    @Override
    @ManagedAttribute(defaultValue="false")
    public boolean getNeedClientAuth();

    @Override
    @ManagedAttribute(defaultValue="false")
    public boolean getWantClientAuth();

    @Override
    @ManagedAttribute
    public TrustStore<?> getClientCertRecorder();

    @Override
    @ManagedAttribute(mandatory=true)
    public AuthenticationProvider getAuthenticationProvider();

    @Override
    @ManagedAttribute(defaultValue="TCP", validValues={"[ \"TCP\" ]", "[ \"SSL\" ]", "[ \"TCP\", \"SSL\" ]"})
    public Set<Transport> getTransports();

    @Override
    @ManagedAttribute(defaultValue="HTTP", validValues={"[ \"HTTP\"]"})
    public Set<Protocol> getProtocols();

    public void setPortManager(PortManager var1);

    @ManagedAttribute(defaultValue="${port.http.threadPool.maximum}")
    public int getThreadPoolMaximum();

    @ManagedAttribute(defaultValue="${port.http.threadPool.minimum}")
    public int getThreadPoolMinimum();

    @ManagedAttribute(defaultValue="false", description="If true allow operations which may return confidential information to be executed on insecure connections")
    public boolean isAllowConfidentialOperationsOnInsecureChannels();
}

