/*
 * Decompiled with CFR 0.152.
 */
package org.apache.qpid.server.model.port;

import com.fasterxml.jackson.databind.ObjectMapper;
import com.google.common.util.concurrent.ListenableFuture;
import com.google.common.util.concurrent.SettableFuture;
import java.io.IOException;
import java.io.StringWriter;
import java.io.Writer;
import java.net.SocketAddress;
import java.security.GeneralSecurityException;
import java.security.PrivilegedAction;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Collections;
import java.util.Comparator;
import java.util.HashMap;
import java.util.HashSet;
import java.util.Map;
import java.util.Set;
import java.util.TreeSet;
import java.util.concurrent.atomic.AtomicBoolean;
import java.util.concurrent.atomic.AtomicInteger;
import javax.net.ssl.KeyManager;
import javax.net.ssl.SSLContext;
import javax.net.ssl.TrustManager;
import javax.net.ssl.X509TrustManager;
import javax.security.auth.Subject;
import org.apache.qpid.server.configuration.IllegalConfigurationException;
import org.apache.qpid.server.logging.messages.BrokerMessages;
import org.apache.qpid.server.logging.messages.PortMessages;
import org.apache.qpid.server.logging.subjects.PortLogSubject;
import org.apache.qpid.server.model.ConfiguredObject;
import org.apache.qpid.server.model.Container;
import org.apache.qpid.server.model.KeyStore;
import org.apache.qpid.server.model.ManagedAttributeField;
import org.apache.qpid.server.model.ManagedObjectFactoryConstructor;
import org.apache.qpid.server.model.NamedAddressSpace;
import org.apache.qpid.server.model.Protocol;
import org.apache.qpid.server.model.State;
import org.apache.qpid.server.model.SystemConfig;
import org.apache.qpid.server.model.Transport;
import org.apache.qpid.server.model.TrustStore;
import org.apache.qpid.server.model.VirtualHostAlias;
import org.apache.qpid.server.model.port.AbstractClientAuthCapablePortWithAuthProvider;
import org.apache.qpid.server.model.port.AmqpPort;
import org.apache.qpid.server.plugin.ProtocolEngineCreator;
import org.apache.qpid.server.plugin.QpidServiceLoader;
import org.apache.qpid.server.plugin.TransportProviderFactory;
import org.apache.qpid.server.transport.AcceptingTransport;
import org.apache.qpid.server.transport.PortBindFailureException;
import org.apache.qpid.server.transport.TransportProvider;
import org.apache.qpid.server.util.PortUtil;
import org.apache.qpid.server.util.ServerScopedRuntimeException;
import org.apache.qpid.transport.network.security.ssl.QpidMultipleTrustManager;
import org.apache.qpid.transport.network.security.ssl.SSLUtil;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class AmqpPortImpl
extends AbstractClientAuthCapablePortWithAuthProvider<AmqpPortImpl>
implements AmqpPort<AmqpPortImpl> {
    private static final Logger LOGGER = LoggerFactory.getLogger(AmqpPortImpl.class);
    public static final String DEFAULT_BINDING_ADDRESS = "*";
    private static final Comparator<VirtualHostAlias> VIRTUAL_HOST_ALIAS_COMPARATOR = new Comparator<VirtualHostAlias>(){

        @Override
        public int compare(VirtualHostAlias left, VirtualHostAlias right) {
            int comparison = left.getPriority() - right.getPriority();
            if (comparison == 0) {
                long rightTime;
                long leftTime = left.getCreatedTime() == null ? 0L : left.getCreatedTime().getTime();
                long createCompare = leftTime - (rightTime = right.getCreatedTime() == null ? 0L : right.getCreatedTime().getTime());
                comparison = createCompare == 0L ? left.getName().compareTo(right.getName()) : (createCompare < 0L ? -1 : 1);
            }
            return comparison;
        }
    };
    @ManagedAttributeField
    private boolean _tcpNoDelay;
    @ManagedAttributeField
    private String _bindingAddress;
    @ManagedAttributeField
    private int _maxOpenConnections;
    @ManagedAttributeField
    private int _threadPoolSize;
    @ManagedAttributeField
    private int _numberOfSelectors;
    private final AtomicInteger _connectionCount = new AtomicInteger();
    private final AtomicBoolean _connectionCountWarningGiven = new AtomicBoolean();
    private final Container<?> _container;
    private final AtomicBoolean _closing = new AtomicBoolean();
    private final SettableFuture _noConnectionsRemain = SettableFuture.create();
    private AcceptingTransport _transport;
    private SSLContext _sslContext;
    private volatile int _connectionWarnCount;
    private volatile long _protocolHandshakeTimeout;

    @ManagedObjectFactoryConstructor
    public AmqpPortImpl(Map<String, Object> attributes, Container<?> container) {
        super(attributes, container);
        this._container = container;
    }

    @Override
    public int getThreadPoolSize() {
        return this._threadPoolSize;
    }

    @Override
    public int getNumberOfSelectors() {
        return this._numberOfSelectors;
    }

    @Override
    public SSLContext getSSLContext() {
        return this._sslContext;
    }

    @Override
    public String getBindingAddress() {
        return this._bindingAddress;
    }

    @Override
    public boolean isTcpNoDelay() {
        return this._tcpNoDelay;
    }

    @Override
    public int getMaxOpenConnections() {
        return this._maxOpenConnections;
    }

    @Override
    protected void onCreate() {
        super.onCreate();
        final HashMap<String, Object> nameAliasAttributes = new HashMap<String, Object>();
        nameAliasAttributes.put("name", "nameAlias");
        nameAliasAttributes.put("type", "nameAlias");
        nameAliasAttributes.put("durable", true);
        final HashMap<String, Object> defaultAliasAttributes = new HashMap<String, Object>();
        defaultAliasAttributes.put("name", "defaultAlias");
        defaultAliasAttributes.put("type", "defaultAlias");
        defaultAliasAttributes.put("durable", true);
        final HashMap<String, Object> hostnameAliasAttributes = new HashMap<String, Object>();
        hostnameAliasAttributes.put("name", "hostnameAlias");
        hostnameAliasAttributes.put("type", "hostnameAlias");
        hostnameAliasAttributes.put("durable", true);
        Subject.doAs(this.getSubjectWithAddedSystemRights(), new PrivilegedAction<Object>(){

            @Override
            public Object run() {
                AmqpPortImpl.this.createChild(VirtualHostAlias.class, nameAliasAttributes, new ConfiguredObject[0]);
                AmqpPortImpl.this.createChild(VirtualHostAlias.class, defaultAliasAttributes, new ConfiguredObject[0]);
                AmqpPortImpl.this.createChild(VirtualHostAlias.class, hostnameAliasAttributes, new ConfiguredObject[0]);
                return null;
            }
        });
    }

    @Override
    protected void onOpen() {
        super.onOpen();
        this._protocolHandshakeTimeout = this.getContextValue(Long.class, "qpid.port.protocol_handshake_timeout");
        this._connectionWarnCount = this.getContextValue(Integer.class, "qpid.port.open_connections_warn_percent");
    }

    @Override
    public <C extends ConfiguredObject> ListenableFuture<C> addChildAsync(Class<C> childClass, Map<String, Object> attributes, ConfiguredObject ... otherParents) {
        if (VirtualHostAlias.class.isAssignableFrom(childClass)) {
            return this.getObjectFactory().createAsync(childClass, attributes, this);
        }
        return super.addChildAsync(childClass, attributes, otherParents);
    }

    @Override
    public NamedAddressSpace getAddressSpace(String name) {
        TreeSet<VirtualHostAlias> aliases = new TreeSet<VirtualHostAlias>(VIRTUAL_HOST_ALIAS_COMPARATOR);
        aliases.addAll(this.getChildren(VirtualHostAlias.class));
        for (VirtualHostAlias alias : aliases) {
            NamedAddressSpace addressSpace = alias.getAddressSpace(name);
            if (addressSpace == null) continue;
            return addressSpace;
        }
        return null;
    }

    @Override
    protected State onActivate() {
        if (this.getAncestor(SystemConfig.class).isManagementMode()) {
            return State.QUIESCED;
        }
        Set<Transport> transports = this.getTransports();
        TransportProvider transportProvider = null;
        HashSet<Transport> transportSet = new HashSet<Transport>(transports);
        for (TransportProviderFactory tpf : new QpidServiceLoader().instancesOf(TransportProviderFactory.class)) {
            if (!tpf.getSupportedTransports().contains(transports)) continue;
            transportProvider = tpf.getTransportProvider(transportSet);
        }
        if (transportProvider == null) {
            throw new IllegalConfigurationException("No transport providers found which can satisfy the requirement to support the transports: " + transports);
        }
        if (transports.contains((Object)Transport.SSL) || transports.contains((Object)Transport.WSS)) {
            this._sslContext = this.createSslContext();
        }
        Protocol defaultSupportedProtocolReply = this.getDefaultAmqpSupportedReply();
        try {
            this._transport = transportProvider.createTransport(transportSet, this._sslContext, this, this.getProtocols(), defaultSupportedProtocolReply);
            this._transport.start();
            for (Transport transport : this.getTransports()) {
                this._container.getEventLogger().message(BrokerMessages.LISTENING(String.valueOf((Object)transport), this._transport.getAcceptingPort()));
            }
            return State.ACTIVE;
        }
        catch (PortBindFailureException e) {
            this._container.getEventLogger().message(PortMessages.BIND_FAILED(this.getType().toUpperCase(), this.getPort()));
            throw e;
        }
    }

    @Override
    protected ListenableFuture<Void> beforeClose() {
        this._closing.set(true);
        if (this._connectionCount.get() == 0) {
            this._noConnectionsRemain.set(null);
        }
        return this._noConnectionsRemain;
    }

    @Override
    protected void onClose() {
        if (this._transport != null) {
            for (Transport transport : this.getTransports()) {
                this._container.getEventLogger().message(BrokerMessages.SHUTTING_DOWN(String.valueOf((Object)transport), this._transport.getAcceptingPort()));
            }
            this._transport.close();
        }
    }

    @Override
    public int getNetworkBufferSize() {
        return this._container.getNetworkBufferSize();
    }

    @Override
    public void validateOnCreate() {
        super.validateOnCreate();
        String bindingAddress = this.getBindingAddress();
        if (!PortUtil.isPortAvailable(bindingAddress, this.getPort())) {
            throw new IllegalConfigurationException(String.format("Cannot bind to port %d and binding address '%s'. Port is already is use.", this.getPort(), bindingAddress == null || "".equals(bindingAddress) ? DEFAULT_BINDING_ADDRESS : bindingAddress));
        }
    }

    @Override
    public void onValidate() {
        super.onValidate();
        Collection<VirtualHostAlias> aliases = this.getChildren(VirtualHostAlias.class);
        if (aliases.size() == 0) {
            LOGGER.warn("{} has no virtualhost aliases defined.  No AMQP connections will be possible through this port until at least one alias is added.", (Object)this);
        }
        this.validateThreadPoolSettings(this);
    }

    @Override
    protected void validateChange(ConfiguredObject<?> proxyForValidation, Set<String> changedAttributes) {
        super.validateChange(proxyForValidation, changedAttributes);
        AmqpPort changed = (AmqpPort)proxyForValidation;
        if (changedAttributes.contains("threadPoolSize") || changedAttributes.contains("numberOfSelectors")) {
            this.validateThreadPoolSettings(changed);
        }
    }

    private void validateThreadPoolSettings(AmqpPort changed) {
        if (changed.getThreadPoolSize() < 1) {
            throw new IllegalConfigurationException(String.format("Thread pool size %d on Port %s must be greater than zero.", changed.getThreadPoolSize(), this.getName()));
        }
        if (changed.getNumberOfSelectors() < 1) {
            throw new IllegalConfigurationException(String.format("Number of Selectors %d on Port %s must be greater than zero.", changed.getNumberOfSelectors(), this.getName()));
        }
        if (changed.getThreadPoolSize() <= changed.getNumberOfSelectors()) {
            throw new IllegalConfigurationException(String.format("Number of Selectors %d on Port %s must be greater than the thread pool size %d.", changed.getNumberOfSelectors(), this.getName(), changed.getThreadPoolSize()));
        }
    }

    private SSLContext createSslContext() {
        boolean needClientCert;
        KeyStore keyStore = this.getKeyStore();
        Collection<TrustStore> trustStores = this.getTrustStores();
        boolean bl = needClientCert = (Boolean)this.getAttribute("needClientAuth") != false || (Boolean)this.getAttribute("wantClientAuth") != false;
        if (needClientCert && trustStores.isEmpty()) {
            throw new IllegalConfigurationException("Client certificate authentication is enabled on AMQP port '" + this.getName() + "' but no trust store defined");
        }
        try {
            TrustManager[] trustManagers;
            SSLContext sslContext = SSLUtil.tryGetSSLContext();
            KeyManager[] keyManagers = keyStore.getKeyManagers();
            if (trustStores == null || trustStores.isEmpty()) {
                trustManagers = null;
            } else if (trustStores.size() == 1) {
                trustManagers = trustStores.iterator().next().getTrustManagers();
            } else {
                ArrayList<TrustManager> trustManagerList = new ArrayList<TrustManager>();
                QpidMultipleTrustManager mulTrustManager = new QpidMultipleTrustManager();
                for (TrustStore ts : trustStores) {
                    TrustManager[] managers = ts.getTrustManagers();
                    if (managers == null) continue;
                    for (TrustManager manager : managers) {
                        if (manager instanceof X509TrustManager) {
                            mulTrustManager.addTrustManager((X509TrustManager)manager);
                            continue;
                        }
                        trustManagerList.add(manager);
                    }
                }
                if (!mulTrustManager.isEmpty()) {
                    trustManagerList.add((TrustManager)mulTrustManager);
                }
                trustManagers = trustManagerList.toArray(new TrustManager[trustManagerList.size()]);
            }
            sslContext.init(keyManagers, trustManagers, null);
            return sslContext;
        }
        catch (GeneralSecurityException e) {
            throw new IllegalArgumentException("Unable to create SSLContext for key or trust store", e);
        }
    }

    private Protocol getDefaultAmqpSupportedReply() {
        String defaultAmqpSupportedReply = this.getContextKeys(false).contains("qpid.broker_default_supported_protocol_version_reply") ? this.getContextValue(String.class, "qpid.broker_default_supported_protocol_version_reply") : null;
        Protocol protocol = null;
        if (defaultAmqpSupportedReply != null && defaultAmqpSupportedReply.length() != 0) {
            try {
                protocol = Protocol.valueOf("AMQP_" + defaultAmqpSupportedReply.substring(1));
            }
            catch (IllegalArgumentException e) {
                LOGGER.warn("The configured default reply ({}) is not a valid value for a protocol.  This value will be ignored", (Object)defaultAmqpSupportedReply);
            }
        }
        Set<Protocol> protocolSet = this.getProtocols();
        if (protocol != null && !protocolSet.contains((Object)protocol)) {
            LOGGER.warn("The configured default reply ({}) to an unsupported protocol version initiation is not supported on this port.  Only the following versions are supported: {}", (Object)defaultAmqpSupportedReply, protocolSet);
            protocol = null;
        }
        return protocol;
    }

    public static Set<Protocol> getInstalledProtocols() {
        HashSet<Protocol> protocols = new HashSet<Protocol>();
        for (ProtocolEngineCreator installedEngine : new QpidServiceLoader().instancesOf(ProtocolEngineCreator.class)) {
            protocols.add(installedEngine.getVersion());
        }
        return protocols;
    }

    public static Collection<String> getAllAvailableProtocolCombinations() {
        Set<Protocol> protocols = AmqpPortImpl.getInstalledProtocols();
        HashSet<Set<String>> last = new HashSet<Set<String>>();
        for (Protocol protocol : protocols) {
            last.add(Collections.singleton(protocol.name()));
        }
        HashSet protocolCombinations = new HashSet(last);
        for (int i = 1; i < protocols.size(); ++i) {
            HashSet current = new HashSet();
            for (Set set : last) {
                for (Protocol p : protocols) {
                    if (set.contains(p.name())) continue;
                    HashSet<String> potential = new HashSet<String>(set);
                    potential.add(p.name());
                    current.add(potential);
                }
            }
            protocolCombinations.addAll(current);
            last = current;
        }
        HashSet<String> combinationsAsString = new HashSet<String>(protocolCombinations.size());
        ObjectMapper mapper = new ObjectMapper();
        for (Set set : protocolCombinations) {
            try {
                StringWriter writer = new StringWriter();
                Throwable throwable = null;
                try {
                    mapper.writeValue((Writer)writer, (Object)set);
                    combinationsAsString.add(writer.toString());
                }
                catch (Throwable throwable2) {
                    throwable = throwable2;
                    throw throwable2;
                }
                finally {
                    if (writer == null) continue;
                    if (throwable != null) {
                        try {
                            writer.close();
                        }
                        catch (Throwable x2) {
                            throwable.addSuppressed(x2);
                        }
                        continue;
                    }
                    writer.close();
                }
            }
            catch (IOException e) {
                throw new IllegalArgumentException("Unexpected IO Exception generating JSON string", e);
            }
        }
        return Collections.unmodifiableSet(combinationsAsString);
    }

    public static Collection<String> getAllAvailableTransportCombinations() {
        HashSet<Set<Transport>> combinations = new HashSet<Set<Transport>>();
        for (TransportProviderFactory providerFactory : new QpidServiceLoader().instancesOf(TransportProviderFactory.class)) {
            combinations.addAll(providerFactory.getSupportedTransports());
        }
        HashSet<String> combinationsAsString = new HashSet<String>(combinations.size());
        ObjectMapper mapper = new ObjectMapper();
        for (Set set : combinations) {
            try {
                StringWriter writer = new StringWriter();
                Throwable throwable = null;
                try {
                    mapper.writeValue((Writer)writer, (Object)set);
                    combinationsAsString.add(writer.toString());
                }
                catch (Throwable throwable2) {
                    throwable = throwable2;
                    throw throwable2;
                }
                finally {
                    if (writer == null) continue;
                    if (throwable != null) {
                        try {
                            writer.close();
                        }
                        catch (Throwable x2) {
                            throwable.addSuppressed(x2);
                        }
                        continue;
                    }
                    writer.close();
                }
            }
            catch (IOException e) {
                throw new IllegalArgumentException("Unexpected IO Exception generating JSON string", e);
            }
        }
        return Collections.unmodifiableSet(combinationsAsString);
    }

    /*
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    public static String getInstalledProtocolsAsString() {
        Set<Protocol> installedProtocols = AmqpPortImpl.getInstalledProtocols();
        ObjectMapper mapper = new ObjectMapper();
        try (StringWriter output = new StringWriter();){
            mapper.writeValue((Writer)output, installedProtocols);
            String string = output.toString();
            return string;
        }
        catch (IOException e) {
            throw new ServerScopedRuntimeException(e);
        }
    }

    @Override
    public int incrementConnectionCount() {
        int openConnections = this._connectionCount.incrementAndGet();
        int maxOpenConnections = this.getMaxOpenConnections();
        if (maxOpenConnections > 0 && openConnections > maxOpenConnections * this._connectionWarnCount / 100 && this._connectionCountWarningGiven.compareAndSet(false, true)) {
            this._container.getEventLogger().message(new PortLogSubject(this), PortMessages.CONNECTION_COUNT_WARN(openConnections, this._connectionWarnCount, maxOpenConnections));
        }
        return openConnections;
    }

    @Override
    public int decrementConnectionCount() {
        int openConnections = this._connectionCount.decrementAndGet();
        int maxOpenConnections = this.getMaxOpenConnections();
        if (maxOpenConnections > 0 && openConnections < maxOpenConnections * AmqpPortImpl.square(this._connectionWarnCount) / 10000) {
            this._connectionCountWarningGiven.compareAndSet(true, false);
        }
        if (this._closing.get() && this._connectionCount.get() == 0) {
            this._noConnectionsRemain.set(null);
        }
        return openConnections;
    }

    private static int square(int val) {
        return val * val;
    }

    @Override
    public boolean canAcceptNewConnection(SocketAddress remoteSocketAddress) {
        String addressString = remoteSocketAddress.toString();
        if (this._closing.get()) {
            this._container.getEventLogger().message(new PortLogSubject(this), PortMessages.CONNECTION_REJECTED_CLOSED(addressString));
            return false;
        }
        if (this._maxOpenConnections > 0 && this._connectionCount.get() >= this._maxOpenConnections) {
            this._container.getEventLogger().message(new PortLogSubject(this), PortMessages.CONNECTION_REJECTED_TOO_MANY(addressString, this._maxOpenConnections));
            return false;
        }
        return true;
    }

    @Override
    public int getConnectionCount() {
        return this._connectionCount.get();
    }

    @Override
    public long getProtocolHandshakeTimeout() {
        return this._protocolHandshakeTimeout;
    }
}

